{$F-}  { Far Calls.............On             }
{$A+}  { Data Alignment........Word           }
{$X+}   { Enhanced Syntax.......On             }
{$V-}   { String Type Checking..Relaxed        }
{$P+}   { Open Strings..........On             }
{$T-}   { @ Pointers............UnTyped        }
{$G+}   { 286 OpCodes...........On             }
{$B-}   { Boolean Evaluation....Short Circuit  }

{$R+}  { Range Checking........Off            }
{$S+}  { Stack Checking........Off            }
{$Q+}  { Overflow Checking.....Off            }

unit edit_vga;
InterFace
uses scaninit,scanio,crt,my2,consts,version;
Var a:word;
  code : integer;
  dummy : string;
  i : integer;
  j : integer;
  dummy_int : longint;
  pos, posold : integer;
  stop : boolean;
  _x1, _x2, _y1, _y2 : byte;
  found : integer;
  old_verkauf : string;
  pk_source : integer;
  pointing : ^screentype;
  error:boolean;
  cha:char;
  tmp_word: word;
  _reserved1:real;

FUNCTION edit_init(where:byte):byte;
procedure edit_reinit;
procedure edit_save;
procedure write_modem;
procedure edit_modem;
procedure write_response;
procedure edit_response;
procedure write_log;
procedure edit_log;
procedure write_misc;
procedure edit_misc;
procedure write_exec;
procedure edit_exec;
procedure write_scan;
procedure edit_scan;
procedure reprint;

Implementation
procedure write_modem;
const
  tbl : array[1..20, 1..4] of byte =(
  (27,  3,  1,  1), {com}  (28,  4,  3,  3), {base}
  (39,  4,  2,  2), {irq}  (27,  5,  5,  5), {speed}
  (39,  5,  3,  3), {data}
  (62,  3,  3,  3), {fossil} (62,  5,  3,  3), {autodata}
  (29,  6, 18, 18), {hangup}
  (32,  8, 25, 25), {init1}  (32,  9, 25, 25), {init2}
  (32, 10, 20, 20), {dialp}  (32, 11, 20, 20), {dials}
  (32, 12, 20, 20), {hangup} (32, 13, 20, 20), {speakn}
  (32, 14, 20, 20), {speakf}
  (34, 16,  1,  1), {flee}   (61, 16,  1,  1), {outflee}
  (34, 17,  4,  4), {cmddel} (61, 17,  2,  2), {chardel}
  (34, 18,  5,  5)  {waitcall} );

begin
  with config do begin
    str(comport,dummy);
    write_field(tbl[ 1,1],tbl[ 1, 2],tbl[ 1,3], dummy);
    str(irq, dummy);
    write_field(tbl[ 3,1],tbl[ 3, 2],tbl[ 3,3], dummy);
    dummy := word2hex(baseadress);
    dummy := dummy[2] + dummy[3] + dummy[4];
    write_field(tbl[ 2,1],tbl[ 2, 2],tbl[ 2,3], dummy);
    case speed of
	300 : dummy_int := 0;
       1200 : dummy_int := 1;
       2400 : dummy_int := 2;
       4800 : dummy_int := 3;
       9600 : dummy_int := 4;
      19200 : dummy_int := 5;
      38400 : dummy_int := 6;
      57600 : dummy_int := 7;
    else dummy_int:=4; end;
    write_field(tbl[ 4,1],tbl[ 4, 2],tbl[ 4,3], pk_baud^[dummy_int]);
    if b_data = 7 then dummy_int := 10 else dummy_int:=0;
       case b_parity of
            'E' : dummy_int := dummy_int + 2;
	    'O' : dummy_int := dummy_int + 4;
	    'M' : dummy_int := dummy_int + 6;
	    'S' : dummy_int := dummy_int + 8;
	  end;
       if b_stop = 2 then inc(dummy_int);

    write_field(tbl[ 5,1],tbl[ 5, 2],tbl[ 5,3], pk_mode^[dummy_int]);
    if use_fossil = true then
      dummy := 'YES'
    else
      dummy := 'NO';
    write_field(tbl[ 6,1],tbl[ 6, 2],tbl[ 6,3], dummy);
    if auto_detect = true then
      dummy := 'YES'
    else
      dummy := 'NO';
    write_field(tbl[ 7,1],tbl[ 7, 2],tbl[ 7,3], dummy);

    if fast_hangup = true then
      dummy := 'FAST'
    else
      dummy := 'SECURE';
    if dumb = true then
      dummy := dummy + '/DUMB/'
    else
      dummy := dummy + '/SMART/';
    if intelligent = true then
      dummy := dummy + 'CHECK'
    else
      dummy := dummy + 'WAIT';
    write_field(tbl[ 8,1],tbl[ 8, 2],tbl[ 8,3], dummy);

    write_field(tbl[ 9,1],tbl[ 9, 2],tbl[ 9,3], init1);
    write_field(tbl[10,1],tbl[10, 2],tbl[10,3], init2);

    write_field(tbl[11,1],tbl[11, 2],tbl[11,3], dial_prefix);
    write_field(tbl[12,1],tbl[12, 2],tbl[12,3], dial_suffix);
    write_field(tbl[13,1],tbl[13, 2],tbl[13,3], hangup);
    write_field(tbl[14,1],tbl[14, 2],tbl[14,3], speakeron);
    write_field(tbl[15,1],tbl[15, 2],tbl[15,3], speakeroff);
    dummy := flee;
    write_field(tbl[16,1],tbl[16, 2],tbl[16,3], dummy);
    write_field(tbl[17,1],tbl[17, 2],tbl[17,3], dialup_hangup);
    str(cmd_delay, dummy);
    write_field(tbl[18,1],tbl[18, 2],tbl[18,3], dummy);
    str(char_delay, dummy);
    write_field(tbl[19,1],tbl[19, 2],tbl[19,3], dummy);

    str(waitbetweencalls, dummy);
    write_field(tbl[20,1],tbl[20, 2],tbl[20,3], dummy);
  end;
end;


procedure edit_modem;
const
  tbl : array[1..20, 1..4] of byte =(
  (27,  3,  1,  1), {com}  (28,  4,  3,  3), {base}
  (39,  4,  2,  2), {irq}  (27,  5,  5,  5), {speed}
  (39,  5,  3,  3), {data}
  (62,  3,  3,  3), {fossil} (62,  5,  3,  3), {autodata}
  (29,  6, 18, 18), {hangup}
  (32,  8, 25, 25), {init1}  (32,  9, 25, 25), {init2}
  (32, 10, 20, 20), {dialp}  (32, 11, 20, 20), {dials}
  (32, 12, 20, 20), {hangup} (32, 13, 20, 20), {speakn}
  (32, 14, 20, 20), {speakf}
  (34, 16,  1,  1), {flee}   (61, 16,  1,  1), {outflee}
  (34, 17,  4,  4), {cmddel} (61, 17,  2,  2), {chardel}
  (34, 18,  5,  5)  {waitcall} );

begin
  for i := 0 to 33 do
  move(pointing^[i*160], screen[i*160], 160);
  pos := 1;
  posold := 1;
  stop := false;
  write_modem;
  display_help(pos);
  field_color(tbl[pos,1], tbl[pos,2], tbl[pos,3], $7F);
  repeat
    taste := #0;
    stop := false;
    write_modem;
    if pos <> posold then begin
      field_color(tbl[pos, 1], tbl[pos,2], tbl[pos,3], $7F);
      field_color(tbl[posold,1],tbl[posold,2],tbl[posold,3],$78);
      remove_help(posold);
      display_help(pos);
    end;
    posold := pos;
    dummy := '';
    with config do begin
      case pos of
	1 : begin
	      str(comport, dummy);
	      readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
	      val(dummy, comport, code);
	    end;
	2 : begin
	      dummy := word2hex(baseadress);
	      dummy := dummy[2] + dummy[3] + dummy[4];
	      readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_hex, dummy, taste, false);
	      dummy := '0' + dummy;
	      baseadress := hex2word(dummy);
	    end;
	3 : begin
	      str(irq, dummy);
	      readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
	      val(dummy, irq, code);
	    end;
	4 : begin
	      cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
		case speed of
		    300 : pk_source := 0;
		   1200 : pk_source := 1;
		   2400 : pk_source := 2;
		   4800 : pk_source := 3;
		   9600 : pk_source := 4;
		  19200 : pk_source := 5;
		  38400 : pk_source := 6;
		  57600 : pk_source := 7;
                else pk_source:=4;
		end;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3], 8, 8, pk_source, pk_baud, taste,  $87, $0E, $8F, false);
		val(pk_baud^[pk_source], speed, code);
	      end;
	    end;
	5 : begin
	      cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
		if b_data = 7 then pk_source := 10 else pk_source:=0;
		case b_parity of
		  'E' : pk_source := pk_source + 2;
		  'O' : pk_source := pk_source + 4;
		  'M' : pk_source := pk_source + 6;
		  'S' : pk_source := pk_source + 8;
		end;
                if b_stop = 2 then inc(pk_source);
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],20,20,pk_source,pk_mode,taste, $87, $0E, $8F, false);
		val(pk_mode^[pk_source][1], b_data, code);
		b_parity := pk_mode^[pk_source][2];
		val(pk_mode^[pk_source][3], b_stop, code);
	    end; end;
	6 : begin
	      cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
                if use_fossil then pk_source:=0 else pk_source:=1;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],2,2,pk_source,pk_yes_no,taste,  $87, $0E, $8F, false);
                if pk_yes_no^[pk_source] = 'YES' then use_fossil:=true else use_fossil:=false;
             end;end;
	7 : begin
	      cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
                if auto_detect then pk_source:=0 else pk_source:=1;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],2,2,pk_source,pk_yes_no,taste,  $87, $0E, $8F, false);
                if pk_yes_no^[pk_source] = 'YES' then auto_detect:=true else auto_detect:=false;
{		auto_detect := not auto_detect;}
	    end;end;
	8 : begin
	      cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
                if not fast_hangup then pk_source:=1 else pk_source:=0;
                if dumb then pk_source:=pk_source+2;
                if not intelligent then pk_source:=pk_source+4;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],8,8,pk_source,pk_hangup,taste,  $87, $0E, $8F, false);
                if pk_source>3 then begin intelligent:=false; pk_source:=pk_source-4; end else intelligent:=true;
                if pk_source>1 then begin dumb:=true; pk_source:=pk_source-2; end else dumb:=false;
                if pk_source=1 then fast_hangup:=false else fast_hangup:=true;
                end;
	    end;
	9 : begin readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, init1, taste, false); upc(init1); end;
       10 : begin readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, init2, taste, false);       upc(init2); end;
       11 : begin readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, dial_prefix, taste, false);
       upc(dial_prefix); end;
       12 : begin readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, dial_suffix, taste, false);
       upc(dial_suffix); end;
       13 : begin readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, hangup, taste, false);
       upc(hangup); end;
       14 : begin readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, speakeron, taste, false);
       upc(speakeron); end;
       15 : begin readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, speakeroff, taste, false);
       upc(speakeroff); end;
       16 : begin
	      dummy := flee;
	      readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, dummy, taste, false);
	      flee := dummy[1];
	    end;
       17 : begin dummy:=dialup_hangup;
            readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, dummy, taste, false);
            dialup_hangup:=dummy[1]; end;
       18 : begin
	    str(cmd_delay, dummy);
	    readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
	    val(dummy, dummy_int, code);
	    if dummy_int > 10000 then
	      cmd_delay := 10000
	    else
	      cmd_delay := dummy_int;
	    end;
       19 : begin
	    str(char_delay, dummy);
	    readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
	    val(dummy, dummy_int, code);
	    if dummy_int > 255 then
	      char_delay := 255
	    else
	      char_delay := dummy_int;
	    end;
       20 : begin
	      str(waitbetweencalls, dummy);
	      readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
	      val(dummy, dummy_int, code);
	      if dummy_int > 65535 then
		waitbetweencalls := 65535
	      else
		waitbetweencalls := dummy_int;
	    end;
      end;
    end;
    case ord(taste) of
      up     : if pos > 1 then dec(pos) else pos := 20;
      sh_tab : if pos > 1 then dec(pos) else pos := 20;
      down   : if pos < 20 then inc(pos) else pos := 1;
      tab    : if pos < 20 then inc(pos) else pos := 1;
      pgup   : if pos > 1 then pos := 1;
      pgdown : if pos < 20 then pos := 20;
      return : if pos < 20 then inc(pos) else pos := 1;
      esc    : stop := true;
    end;
  until stop = true;
  field_color(tbl[pos, 1], tbl[pos,2], tbl[pos,3], $78);
  remove_help(pos);
end;

procedure write_response;
const
  tbl : array[1..90, 1..4] of byte =(
  (23,  5, 15, 15), (23,  6, 15, 15), (23,  7, 15, 15), (23,  8, 15, 15),
  (23,  9, 15, 15), (23, 10, 15, 15), (23, 11, 15, 15), (23, 12, 15, 15),
  (23, 13, 15, 15), (23, 14, 15, 15), (23, 15, 15, 15), (23, 16, 15, 15),
  (23, 17, 15, 15), (23, 18, 15, 15), (23, 19, 15, 15), (23, 20, 15, 15),
  (23, 21, 15, 15), (23, 22, 15, 15),

  (39,  5,  3,  3), (39,  6,  3,  3), (39,  7,  3,  3), (39,  8,  3,  3),
  (39,  9,  3,  3), (39, 10,  3,  3), (39, 11,  3,  3), (39, 12,  3,  3),
  (39, 13,  3,  3), (39, 14,  3,  3), (39, 15,  3,  3), (39, 16,  3,  3),
  (39, 17,  3,  3), (39, 18,  3,  3), (39, 19,  3,  3), (39, 20,  3,  3),
  (39, 21,  3,  3), (39, 22,  3,  3),

  (43,  5,  3,  3), (43,  6,  3,  3), (43,  7,  3,  3), (43,  8,  3,  3),
  (43,  9,  3,  3), (43, 10,  3,  3), (43, 11,  3,  3), (43, 12,  3,  3),
  (43, 13,  3,  3), (43, 14,  3,  3), (43, 15,  3,  3), (43, 16,  3,  3),
  (43, 17,  3,  3), (43, 18,  3,  3), (43, 19,  3,  3), (43, 20,  3,  3),
  (43, 21,  3,  3), (43, 22,  3,  3),

  (47,  5,  3,  3), (47,  6,  3,  3), (47,  7,  3,  3), (47,  8,  3,  3),
  (47,  9,  3,  3), (47, 10,  3,  3), (47, 11,  3,  3), (47, 12,  3,  3),
  (47, 13,  3,  3), (47, 14,  3,  3), (47, 15,  3,  3), (47, 16,  3,  3),
  (47, 17,  3,  3), (47, 18,  3,  3), (47, 19,  3,  3), (47, 20,  3,  3),
  (47, 21,  3,  3), (47, 22,  3,  3),

  (51,  5, 20, 20), (51,  6, 20, 20), (51,  7, 20, 20), (51,  8, 20, 20),
  (51,  9, 20, 20), (51, 10, 20, 20), (51, 11, 20, 20), (51, 12, 20, 20),
  (51, 13, 20, 20), (51, 14, 20, 20), (51, 15, 20, 20), (51, 16, 20, 20),
  (51, 17, 20, 20), (51, 18, 20, 20), (51, 19, 20, 20), (51, 20, 20, 20),
  (51, 21, 20, 20), (51, 22, 20, 20));
begin
  with config do begin
    for i := 1 to 18 do begin
      write_field(tbl[ i,1],tbl[ i, 2],tbl[ i, 3], modem_respond_id[i].response);
      str(modem_respond_id[i].rings_from, dummy);
      write_field(tbl[ i+18, 1],tbl[ i+18, 2],tbl[ i+18, 3], dummy);
      str(modem_respond_id[i].rings_to, dummy);
      write_field(tbl[ i+36,1],tbl[ i+36, 2],tbl[ i+36, 3], dummy);
      if modem_respond_id[i].print = true then
	dummy := 'YES'
      else
	dummy := 'NO';
      write_field(tbl[ i+54,1],tbl[ i+54, 2],tbl[ i+54, 3], dummy);
      write_field(tbl[ i+72,1],tbl[ i+72, 2],tbl[ i+72, 3], pk_prg^[modem_respond_id[i].exec_it]);
    end;
  end;
end;

procedure edit_response;
const
  tbl : array[1..90, 1..4] of byte =(
  (23,  5, 15, 15), (23,  6, 15, 15), (23,  7, 15, 15), (23,  8, 15, 15),
  (23,  9, 15, 15), (23, 10, 15, 15), (23, 11, 15, 15), (23, 12, 15, 15),
  (23, 13, 15, 15), (23, 14, 15, 15), (23, 15, 15, 15), (23, 16, 15, 15),
  (23, 17, 15, 15), (23, 18, 15, 15), (23, 19, 15, 15), (23, 20, 15, 15),
  (23, 21, 15, 15), (23, 22, 15, 15),

  (39,  5,  3,  3), (39,  6,  3,  3), (39,  7,  3,  3), (39,  8,  3,  3),
  (39,  9,  3,  3), (39, 10,  3,  3), (39, 11,  3,  3), (39, 12,  3,  3),
  (39, 13,  3,  3), (39, 14,  3,  3), (39, 15,  3,  3), (39, 16,  3,  3),
  (39, 17,  3,  3), (39, 18,  3,  3), (39, 19,  3,  3), (39, 20,  3,  3),
  (39, 21,  3,  3), (39, 22,  3,  3),

  (43,  5,  3,  3), (43,  6,  3,  3), (43,  7,  3,  3), (43,  8,  3,  3),
  (43,  9,  3,  3), (43, 10,  3,  3), (43, 11,  3,  3), (43, 12,  3,  3),
  (43, 13,  3,  3), (43, 14,  3,  3), (43, 15,  3,  3), (43, 16,  3,  3),
  (43, 17,  3,  3), (43, 18,  3,  3), (43, 19,  3,  3), (43, 20,  3,  3),
  (43, 21,  3,  3), (43, 22,  3,  3),

  (47,  5,  3,  3), (47,  6,  3,  3), (47,  7,  3,  3), (47,  8,  3,  3),
  (47,  9,  3,  3), (47, 10,  3,  3), (47, 11,  3,  3), (47, 12,  3,  3),
  (47, 13,  3,  3), (47, 14,  3,  3), (47, 15,  3,  3), (47, 16,  3,  3),
  (47, 17,  3,  3), (47, 18,  3,  3), (47, 19,  3,  3), (47, 20,  3,  3),
  (47, 21,  3,  3), (47, 22,  3,  3),

  (51,  5, 20, 20), (51,  6, 20, 20), (51,  7, 20, 20), (51,  8, 20, 20),
  (51,  9, 20, 20), (51, 10, 20, 20), (51, 11, 20, 20), (51, 12, 20, 20),
  (51, 13, 20, 20), (51, 14, 20, 20), (51, 15, 20, 20), (51, 16, 20, 20),
  (51, 17, 20, 20), (51, 18, 20, 20), (51, 19, 20, 20), (51, 20, 20, 20),
  (51, 21, 20, 20), (51, 22, 20, 20));
begin
  pk_prg^[0] := '[NONE]';
  for i := 1 to 8 do begin
    pk_prg^[i] := '';
    if config.execute[i].fname <> '' then begin
      j := length(config.execute[i].fname);
      while (config.execute[i].fname[j] <> '\') and (length(pk_prg^[i]) < 20) and (j > 0) do begin
	pk_prg^[i] := config.execute[i].fname[j] + pk_prg^[i];
	dec(j);
      end;
    end;
      if pk_prg^[i] = '' then pk_prg^[i] := '[NONE]';
      Str(i,dummy);
      pk_prg^[i] := 'F'+dummy+' - '+ pk_prg^[i];
  end;
  for i := 0 to 33 do
    move(pointing^[i*160], screen[i*160], 160);
  pos := 1;
  posold := 1;
  stop := false;
  write_response;
 display_help(21+ steprate(pos,18));
 field_color(tbl[pos,1], tbl[pos,2], tbl[pos,3], $7F);
  repeat
    taste := #0;
    stop := false;
    write_response;
    if pos <> posold then begin
      field_color(tbl[pos, 1], tbl[pos,2], tbl[pos,3], $7F);
      field_color(tbl[posold,1],tbl[posold,2],tbl[posold,3],$78);
     remove_help(steprate(pos,18) +21);
      display_help(steprate(pos,18) +21);
   end;
    posold := pos;
    dummy := '';
    repeat time until keypressed;
    taste := readkey;
    if ord(taste) in [32..255, 13] then begin
      with config do begin
	case pos of
	   1..18 : begin
		     readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, modem_respond_id[pos].response,  taste, true);
		     modem_respond_id[pos].response := upper(modem_respond_id[pos].response);
		   end;
	  19..36 : begin
		     str(modem_respond_id[pos-18].rings_from, dummy);
		     readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_alnum, dummy, taste, true);
		     val(dummy, dummy_int, code);
		     if dummy_int > 255 then
		       modem_respond_id[pos-18].rings_from := 255
		     else
		       modem_respond_id[pos-18].rings_from := dummy_int;
		   end;
	  37..54 : begin
		     str(modem_respond_id[pos-36].rings_to, dummy);
		     readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_alnum, dummy, taste, true);
		     val(dummy, dummy_int, code);
		     if dummy_int > 255 then
		       modem_respond_id[pos-36].rings_to := 255
		     else
		       modem_respond_id[pos-36].rings_to := dummy_int;
		   end;
	  55..72 : begin
		     if taste = #13 then
{###}
		       modem_respond_id[pos-54].print := not modem_respond_id[pos-54].print
		   end;
	  73..90 : begin
		     if taste = #13 then begin
		       pk_source := modem_respond_id[pos-72].exec_it;
		       read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],9,9,pk_source,pk_prg,taste,$87,$0E,$8F,false);
		       modem_respond_id[pos-72].exec_it := pk_source;
                       if pk_source>0 then if execute[modem_respond_id[pos-72].exec_it].fname='' then
                                              modem_respond_id[pos-72].exec_it:=0;
		     end;
		   end;
	end;
      end;
    end;
    if taste = #0 then taste := readkey;
    if taste = #13 then taste := #0;
    cursoroff;
    case ord(taste) of
      up     : if pos mod 18 <> 1 then dec(pos) else pos := pos + 17;
      sh_tab : if pos mod 18 <> 1 then dec(pos) else pos := pos + 17;
      down   : if pos mod 18 > 0 then inc(pos) else pos := pos - 17;
      tab    : if pos mod 18 > 0 then inc(pos) else pos := pos - 17;
      pgup   : if pos > 1  then pos := ((pos + 17) div 18) * 18 - 17;
      pgdown : if pos < 90 then pos := ((pos + 17) div 18) * 18;
      return : if pos < 90 then inc(pos) else pos := 1;
      esc    : stop := true;
      right  : if pos < 73 then pos := pos + 18 else pos := pos - 72;
      left   : if pos > 18 then pos := pos - 18 else pos := pos + 72;
      home   : if pos > 1 then pos := 1;
      ende   : if pos < 90 then pos := 90;
    end;
  until stop = true;
  field_color(tbl[pos, 1], tbl[pos,2], tbl[pos,3], $78);
  remove_help(steprate(pos,18) + 21);
end;

procedure write_log;
const
  tbl : array[1..17, 1..4] of byte =(
  (42,  3,  8,  8), (42,  4,  8,  8), (42,  5,  8,  8), (42,  6,  8,  8),
  (42,  7,  8,  8), (42,  8,  8,  8), (42,  9,  8,  8), (42, 10,  8,  8),
  (42, 11,  8,  8), (42, 12,  8,  8), (42, 13,  8,  8), (42, 14,  8,  8),
  (42, 15,  8,  8), (42, 16,  8,  8), (42, 17,  8,  8), (42, 18,  8,  8),
  (42, 19,  8,  8) );
begin
  with config do begin
    for i := 1 to 17 do
      write_field(tbl[ i,1],tbl[ i, 2],tbl[ i, 3], logs[i-1]);
  end;
end;


procedure edit_log;
const
  tbl : array[1..17, 1..4] of byte =(
  (42,  3,  8,  8), (42,  4,  8,  8), (42,  5,  8,  8), (42,  6,  8,  8),
  (42,  7,  8,  8), (42,  8,  8,  8), (42,  9,  8,  8), (42, 10,  8,  8),
  (42, 11,  8,  8), (42, 12,  8,  8), (42, 13,  8,  8), (42, 14,  8,  8),
  (42, 15,  8,  8), (42, 16,  8,  8), (42, 17,  8,  8), (42, 18,  8,  8),
  (42, 19,  8,  8) );
begin
  for i := 0 to 33 do
    move(pointing^[i*160], screen[i*160], 160);
  pos := 1;
  posold := 1;
  stop := false;
  write_log;
 display_help(26);
 field_color(tbl[pos,1], tbl[pos,2], tbl[pos,3], $7F);
  repeat
    taste := #0;
    stop := false;
    write_log;
    if pos <> posold then begin
      field_color(tbl[pos, 1], tbl[pos,2], tbl[pos,3], $7F);
      field_color(tbl[posold,1],tbl[posold,2],tbl[posold,3],$78);
     remove_help(26);
      display_help(26);
   end;
    posold := pos;
    dummy := '';
    with config do begin
     case pos of
       1..17 : begin
		 readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_alnum+'-_', logs[pos-1], taste, false);
		 logs[pos-1] := upper(logs[pos-1]);
	       end;
       end;
    end;
    case ord(taste) of
      up     : if pos > 1 then dec(pos) else pos := 17;
      sh_tab : if pos > 1 then dec(pos) else pos := 17;
      down   : if pos < 17 then inc(pos) else pos := 1;
      tab    : if pos < 17 then inc(pos) else pos := 1;
      pgup   : if pos > 1 then pos := 1;
      pgdown : if pos < 17 then pos := 17;
      return : if pos < 17 then inc(pos) else pos := 1;
      esc    : stop := true;
    end;
  until stop = true;
  field_color(tbl[pos, 1], tbl[pos,2], tbl[pos,3], $78);
  remove_help(26);
end;

procedure write_exec;
const
  tbl : array[1..26, 1..4] of byte =(
  (20,  5, 18, 50),  (20,  6, 18, 50),
  (20,  7, 18, 50),  (20,  8, 18, 50),
  (20,  9, 18, 50),  (20, 10, 18, 50),
  (20, 11, 18, 50),  (20, 12, 18, 50),

  (41,  5, 26, 50),  (41,  6, 26, 50),
  (41,  7, 26, 50),  (41,  8, 26, 50),
  (41,  9, 26, 50),  (41, 10, 26, 50),
  (41, 11, 26, 50),  (41, 12, 26, 50),

  (71,  5, 3, 3),  (71,  6, 3, 3),
  (71,  7, 3, 3),  (71,  8, 3, 3),
  (71,  9, 3, 3),  (71, 10, 3, 3),
  (71, 11, 3, 3),  (71, 12, 3, 3),

  (24, 15, 18, 18), (24, 16, 18, 18));
begin
  with config do begin
    for i := 1 to 8 do write_field(tbl[ i,1],tbl[ i, 2],tbl[ i, 3], execute[i].fname);
    for i := 1 to 8 do write_field(tbl[ i+8,1],tbl[ i+8, 2],tbl[ i+8, 3], execute[i].params);
    for i := 1 to 8 do begin Str(execute[i].react,dummy);
                             write_field(tbl[ i+16, 1],tbl[ i+16, 2],tbl[ i+16, 3], dummy); end;
    write_field(tbl[ 25,1],tbl[ 25, 2],tbl[ 25, 3], pk_prg^[exec_timeout]);
    write_field(tbl[ 26,1],tbl[ 26, 2],tbl[ 26, 3], pk_prg^[exec_ringout]);
  end;
end;

procedure edit_exec;
const
  tbl : array[1..26, 1..4] of byte =(
  (20,  5, 18, 50),  (20,  6, 18, 50),
  (20,  7, 18, 50),  (20,  8, 18, 50),
  (20,  9, 18, 50),  (20, 10, 18, 50),
  (20, 11, 18, 50),  (20, 12, 18, 50),

  (41,  5, 26, 50),  (41,  6, 26, 50),
  (41,  7, 26, 50),  (41,  8, 26, 50),
  (41,  9, 26, 50),  (41, 10, 26, 50),
  (41, 11, 26, 50),  (41, 12, 26, 50),

  (71,  5, 3, 3),  (71,  6, 3, 3),
  (71,  7, 3, 3),  (71,  8, 3, 3),
  (71,  9, 3, 3),  (71, 10, 3, 3),
  (71, 11, 3, 3),  (71, 12, 3, 3),

  (24, 15, 18, 18), (24, 16, 18, 18));
begin
  for i := 0 to 33 do
    move(pointing^[i*160], screen[i*160], 160);
  pos := 1;
  posold := 1;
  stop := false;
  pk_prg^[0] := '[NONE]';
  for i := 1 to 8 do begin
    pk_prg^[i] := '';
    if config.execute[i].fname <> '' then begin
      j := length(config.execute[i].fname);
      while (config.execute[i].fname[j] <> '\') and (length(pk_prg^[i]) < 20) and (j > 0) do begin
	pk_prg^[i] := config.execute[i].fname[j] + pk_prg^[i];
	dec(j);
      end;
    end;
      if pk_prg^[i] = '' then pk_prg^[i] := '[NONE]';
      Str(i,dummy);
      pk_prg^[i] := 'F'+dummy+' - '+ pk_prg^[i];
  end;
  write_exec;
 display_help(steprate(pos,8) + 44);
 field_color(tbl[pos,1], tbl[pos,2], tbl[pos,3], $7F);
  repeat
    taste := #0;
    stop := false;
    write_exec;
    if pos <> posold then begin
      field_color(tbl[pos, 1], tbl[pos,2], tbl[pos,3], $7F);
      field_color(tbl[posold,1],tbl[posold,2],tbl[posold,3],$78);
     if posold<=24 then remove_help(steprate(pos,8) + 44) else remove_help(posold + 22);
     if pos <= 24 then display_help(steprate(pos,8) + 44) else display_help(pos +22);
   end;
    posold := pos; cursoroff;
    dummy := '';
    repeat time until keypressed;
    taste := readkey;
    if ord(taste) <> 0 {in [32..255, 13]} then begin
    with config do begin
     case pos of
       1..8 : begin
		 readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, execute[pos].fname, taste, true);
		 upc(execute[pos].fname);
              end;
       9..16: begin
		 readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, execute[pos-8].params, taste, true);
		 upc(execute[pos-8].params);
              end;
      17..24: begin
                 Str(execute[pos-16].react,dummy);
		 readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, true);
                 Val(dummy,a,code);
                 if a < 7 then execute[pos-16].react:=a;
              end;
       25: begin cursoroff; if taste = #13 then begin
		       pk_source := exec_timeout;
		       read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],9,9,pk_source,pk_prg,taste,$87,$0E,$8F,false);
		       exec_timeout := pk_source;
                       if pk_source>0 then if execute[exec_timeout].fname='' then
                                              exec_timeout:=0;
		     end; cursoron;
           end;
       26: begin cursoroff; if taste = #13 then begin
		       pk_source := exec_ringout;
		       read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],9,9,pk_source,pk_prg,taste,$87,$0E,$8F,false);
		       exec_ringout := pk_source;
                       if pk_source>0 then if execute[exec_ringout].fname='' then
                                              exec_ringout:=0;
		     end; cursoron;
           end;
       end;
       pk_prg^[0] := '[NONE]';
  for i := 1 to 8 do begin
    pk_prg^[i] := '';
    if config.execute[i].fname <> '' then begin
      j := length(config.execute[i].fname);
      while (config.execute[i].fname[j] <> '\') and (length(pk_prg^[i]) < 20) and (j > 0) do begin
	pk_prg^[i] := config.execute[i].fname[j] + pk_prg^[i];
	dec(j);
      end;
    end;
      if pk_prg^[i] = '' then pk_prg^[i] := '[NONE]';
      Str(i,dummy);
      pk_prg^[i] := 'F'+dummy+' - '+ pk_prg^[i];
  end;

    end; end;
    if taste = #0 then taste := readkey;
    if taste = #13 then taste := #0;
    cursoroff;
    case ord(taste) of
      up     : if pos > 1 then begin if pos = 25 then pos:=8 else if (pos=9)or(pos=17) then pos:=26 else dec(pos) ;
                               end else pos:=26;
      sh_tab : if pos > 1 then begin if pos = 25 then pos:=8 else if (pos=9)or(pos=17) then pos:=26 else dec(pos) ;
                               end else pos:=26;
      down   : if pos < 26 then begin if (pos mod 8 = 0) then pos:=25 else inc(pos); end else pos := 1;
      tab    : if pos < 26 then begin if (pos mod 8 = 0) then pos:=25 else inc(pos); end else pos := 1;
      pgup   : pos := 1;
      pgdown : pos := 26;
      return : if pos < 26 then begin if (pos mod 8 = 0) then pos:=25 else inc(pos); end else pos := 1;
      left   : if (pos>8)and(pos<25) then pos:=pos-8;
      right  : if pos<17 then pos:=pos+8;
      esc    : stop := true;
    end;
  until stop = true;
  field_color(tbl[pos, 1], tbl[pos,2], tbl[pos,3], $78);
  if pos <= 24 then remove_help(steprate(pos,8) + 44) else remove_help(pos +22);
end;

procedure write_scan;
const
  tbl : array[1..17, 1..4] of byte =(
  (18,  4,  8,  8), {scanmode}
  (18,  5, 16, 16), {dialing}
  (52,  5,  4,  4), {step}
  (28,  6,  3,  3), {manual}
  (55,  6,  3,  3), {m-timeout}
  (26,  8,  6,  6), {carrierhackmode}
  (52,  8,  3,  3), {n-timeout}
  (14,  9, 61,255), {nudge}
  (16, 11,  3,  3), {timeout}
  (17, 12,  2,  2), {ringout}
  (55, 11,  3,  3), {redialbusy}
  (55, 12,  3,  3), {busyoverwrite}
  (31, 14,  3,  3), {doelapse}
  (57, 14,  3,  3), {nodial_exit}
  (29, 16,  3,  3), {autodatsave}
  (29, 17,  3,  3), {savedatatypes}
  (33, 18, 29, 29)  {datfilesave}
  );
begin
  with config do begin
    case scanmode of  1:dummy:='CARRIERS';  2:dummy:='TONES';  else begin dummy:='CARRIERS'; scanmode:=1; end;end;
    write_field(tbl[1, 1],tbl[1, 2],tbl[1, 3], dummy);
    if dialing=0 then dummy:='RANDOM' else if dialing<0 then dummy:='SEQUENTIELL DOWN' else dummy:='SEQUENTIELL UP';
    write_field(tbl[2, 1],tbl[2, 2],tbl[2, 3], dummy);
    a:=Abs(dialing); Str(a,dummy);
    write_field(tbl[3, 1],tbl[3, 2],tbl[3, 3], dummy);
    if manual then dummy:='ON' else dummy:='OFF';
    write_field(tbl[4, 1],tbl[4, 2],tbl[4, 3], dummy);
    Str(manual_timeout,dummy);
    write_field(tbl[5, 1],tbl[5, 2],tbl[5, 3], dummy);
    case carrier_hack_mode of
    0:dummy:='WAIT';1:dummy:='NUDGE';2:dummy:='MANUAL';3:dummy:='OFF';else begin dummy:='OFF';carrier_hack_mode:=3;end;end;
    write_field(tbl[6, 1],tbl[6, 2],tbl[6, 3], dummy);
    Str(nudge_delay,dummy);
    write_field(tbl[7, 1],tbl[7, 2],tbl[7, 3], dummy);
    dummy := nudge; if length(dummy) > tbl[8,3] then dummy[0] := chr(tbl[8,3]);
    write_field(tbl[8, 1],tbl[8, 2],tbl[8, 3], dummy);
    Str(timeout,dummy);
    write_field(tbl[9, 1],tbl[9, 2],tbl[9, 3], dummy);
    Str(ringout,dummy);
    write_field(tbl[10, 1],tbl[10, 2],tbl[10, 3], dummy);
    if redial_busy then dummy:='YES' else dummy:='NO';
    write_field(tbl[11, 1],tbl[11, 2],tbl[11, 3], dummy);
    if busy_overwrite then dummy:='YES' else dummy:='NO';
    write_field(tbl[12, 1],tbl[12, 2],tbl[12, 3], dummy);
    if do_elapse then dummy:='YES' else dummy:='NO';
    write_field(tbl[13, 1],tbl[13, 2],tbl[13, 3], dummy);
    Str(nodial_exit,dummy);
    write_field(tbl[14, 1],tbl[14, 2],tbl[14, 3], dummy);
    Str(auto_dat_save,dummy);
    write_field(tbl[15, 1],tbl[15, 2],tbl[15, 3], dummy);
    Str(save_data,dummy);
    write_field(tbl[16, 1],tbl[16, 2],tbl[16, 3], dummy);
    if datfilesave>3 then datfilesave:=0;
    if datfilesave div 2 = 0 then dummy:='Delete Left' else dummy:='Delete Right';
    if datfilesave mod 2 = 0 then dummy:=dummy + ' + Delete Special';
    write_field(tbl[17, 1],tbl[17, 2],tbl[17, 3], dummy);
  end;
end;

procedure edit_scan;
const
  tbl : array[1..17, 1..4] of byte =(
  (18,  4,  8,  8), {scanmode}
  (18,  5, 16, 16), {dialing}
  (52,  5,  4,  4), {step}
  (28,  6,  3,  3), {manual}
  (55,  6,  3,  3), {m-timeout}
  (26,  8,  6,  6), {carrierhackmode}
  (52,  8,  3,  3), {n-timeout}
  (14,  9, 61,255), {nudge}
  (16, 11,  3,  3), {timeout}
  (17, 12,  2,  2), {ringout}
  (55, 11,  3,  3), {redialbusy}
  (55, 12,  3,  3), {busyoverwrite}
  (31, 14,  3,  3), {doelapse}
  (57, 14,  3,  3), {nodial_exit}
  (29, 16,  3,  3), {autodatsave}
  (29, 17,  3,  3), {savedatatypes}
  (33, 18, 29, 29)  {datfilesave}
  );
begin
  for i := 0 to 33 do
    move(pointing^[i*160], screen[i*160], 160);
  pos := 1;
  posold := 1;
  stop := false;
  write_scan;
 display_help(pos+26);
 field_color(tbl[pos,1], tbl[pos,2], tbl[pos,3], $7F);
  repeat
    taste := #0;
    stop := false;
    write_scan;
    if pos <> posold then begin
      field_color(tbl[pos, 1], tbl[pos,2], tbl[pos,3], $7F);
      field_color(tbl[posold,1],tbl[posold,2],tbl[posold,3],$78);
     remove_help(posold+26);
      display_help(pos+26);
   end;
    posold := pos;
    dummy := '';
    with config do begin
      case pos of
         1:begin
	      cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
		if scanmode=0 then pk_source:=0 else pk_source := scanmode-1;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3], 2, 2, pk_source, pk_scan, taste,  $87, $0E, $8F, false);
		scanmode := pk_source+1;
	      end;
            end;
         2:begin
	      cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
		if dialing=0 then pk_source:=0 else if dialing<0 then pk_source:=2 else pk_source:=1; a:=pk_source;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3], 3, 3, pk_source, pk_dial, taste,  $87, $0E, $8F, false);
                if a<>pk_source then begin
                   if pk_source=0 then dialing:=0 else if pk_source=1 then dialing:=1 else dialing:=-1;
                end;
	      end;
            end;
         3: begin
              Str(dialing,dummy); if dummy[1]='-' then Delete(dummy,1,1);
              readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
              Val(dummy,a,code);
              if dialing<0 then dialing:=-a else dialing:=a;
            end;
         4: begin
	      cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
                if manual then pk_source:=0 else pk_source:=1;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],2,2,pk_source,pk_on_off,taste,  $87, $0E, $8F, false);
                if pk_on_off^[pk_source] = 'ON' then manual:=true else manual:=false;
             end;end;
         5: begin
            Str(manual_timeout,dummy);
            readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
            Val(dummy,a,code);
            if a<=255 then manual_timeout:=a else manual_timeout:=255;
            end;
	 6: begin
	      cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
		pk_source := carrier_hack_mode;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3], 4, 4, pk_source, pk_hackmode, taste,  $87, $0E, $8F, false);
		carrier_hack_mode := pk_source;
	      end;
	    end;
	 7: begin
	      str(nudge_delay, dummy);
	      readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, dummy, taste, false);
	      val(dummy, dummy_int, code);
	      if dummy_int > 60 then
		 nudge_delay := 60
	      else
		 nudge_delay := dummy_int;
	    end;
	 8: readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, nudge, taste, false);
	 9: begin
	      str(timeout, dummy);
	      readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
	      val(dummy, dummy_int, code);
	      if dummy_int > 255 then
		 timeout := 255
	      else
		 timeout := dummy_int;
	    end;
	10: begin
	      str(ringout, dummy);
	      readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
	      val(dummy, dummy_int, code);
	      if dummy_int > 99 then
		 ringout := 99
	      else
		 ringout := dummy_int;
	    end;
        11: begin
	      cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
                if redial_busy then pk_source:=0 else pk_source:=1;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],2,2,pk_source,pk_yes_no,taste,  $87, $0E, $8F, false);
                if pk_yes_no^[pk_source] = 'YES' then redial_busy:=true else redial_busy:=false;
             end;end;
        12: begin
	      cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
                if busy_overwrite then pk_source:=0 else pk_source:=1;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],2,2,pk_source,pk_yes_no,taste,  $87, $0E, $8F, false);
                if pk_yes_no^[pk_source] = 'YES' then busy_overwrite:=true else busy_overwrite:=false;
             end;end;
        13: begin
	      cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
                if do_elapse then pk_source:=0 else pk_source:=1;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],2,2,pk_source,pk_yes_no,taste,  $87, $0E, $8F, false);
                if pk_yes_no^[pk_source] = 'YES' then do_elapse:=true else do_elapse:=false;
             end;end;
	14: begin
	      str(nodial_exit, dummy);
	      readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
	      val(dummy, dummy_int, code);
	      if dummy_int > 255 then
		 nodial_exit := 255
	      else
		 nodial_exit := dummy_int;
	    end;
	15: begin
	      str(auto_dat_save, dummy);
	      readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
	      val(dummy, dummy_int, code);
	      if dummy_int > 255 then
		 auto_dat_save := 255
	      else
		 auto_dat_save := dummy_int;
	    end;
	16: begin
	      str(save_data, dummy);
	      readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
	      val(dummy, dummy_int, code);
              case dummy_int of
                 0..31:save_data:=dummy_int;
                 128..159:save_data:=dummy_int;
                 else save_data:=5; end;
	    end;
        17: begin
	      cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
                pk_source:=datfilesave;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],4,4,pk_source,pk_datfilesave,taste,  $87, $0E, $8F, false);
                datfilesave:=pk_source;
             end;end;
    end;
  end;
  case ord(taste) of
    up     : begin if pos > 1 then dec(pos) else pos := 17;
                   if (pos=3)and(config.dialing=0) then dec(pos); end;
    sh_tab : begin if pos > 1 then dec(pos) else pos := 17;
                   if (pos=3)and(config.dialing=0) then dec(pos); end;
    down   : begin if pos < 17 then inc(pos) else pos := 1;
                   if (pos=3)and(config.dialing=0) then inc(pos); end;
    tab    : begin if pos < 17 then inc(pos) else pos := 1;
                   if (pos=3)and(config.dialing=0) then inc(pos); end;
    pgup   : pos := 1;
    pgdown : pos := 17;
    return : begin if pos < 17 then inc(pos) else pos := 1;
                   if (pos=3)and(config.dialing=0) then inc(pos); end;
    esc    : stop := true;
  end;
  until stop = true;
  field_color(tbl[pos, 1], tbl[pos,2], tbl[pos,3], $78);
 remove_help(pos+26);
end;

procedure write_misc;
const  tbl : array[1..20, 1..4] of byte =(
  (24,  4, 25, 25), (67,  4,  3,  3),
  (24,  5, 25, 25), (67,  5,  3,  3),
  (24,  6, 25, 25), (67,  6,  3,  3),
  (28,  8,  3,  3), {extern dialer}
  (16,  9, 12, 50),  (39,  9, 18, 50),  (67,  9,  3,  3),
  (26, 11,  9,  9), {progress bar}
  (26, 12,  3,  3), {del 0}

  (53, 11,  3,  3), {autoblank}
  (61, 12,  3,  3), {suspend blank}

  (26, 14, 11, 11), {use delayers}
  (26, 15,  3,  3),
  (26, 16,  3,  3), {dial delay}
  (52, 15,  4,  4),
  (52, 16,  4,  4), {send delay}
  (33, 18,  5,  5)  {random wait between call}
  );
begin
  with config do begin
    write_field(tbl[1 , 1],tbl[1 , 2],tbl[1 , 3], _custom1);
    if _custom12 = true then      dummy := 'YES'    else      dummy := 'NO';
    write_field(tbl[2 , 1],tbl[2 , 2],tbl[2 , 3], dummy);
    write_field(tbl[3 , 1],tbl[3 , 2],tbl[3 , 3], _custom2);
    if _custom22 = true then      dummy := 'YES'    else      dummy := 'NO';
    write_field(tbl[4 , 1],tbl[4 , 2],tbl[4 , 3], dummy);
    write_field(tbl[5 , 1],tbl[5 , 2],tbl[5 , 3], _custom3);
    if _custom32 = true then      dummy := 'YES'    else      dummy := 'NO';
    write_field(tbl[6 , 1],tbl[6 , 2],tbl[6 , 3], dummy);
    if do_dial_exec = true then      dummy := 'YES'    else      dummy := 'NO';
    write_field(tbl[7 , 1],tbl[7 , 2],tbl[7 , 3], dummy);
    write_field(tbl[8 , 1],tbl[8 , 2],tbl[8 , 3], execute[9].fname);
    write_field(tbl[9 , 1],tbl[9 , 2],tbl[9 , 3], execute[9].params);
    Str(execute[9].react,dummy);
    write_field(tbl[10, 1],tbl[10, 2],tbl[10, 3], dummy);
    write_field(tbl[11, 1],tbl[11, 2],tbl[11, 3], pk_progress^[balken]);
    if delete_zero = true then      dummy := 'YES'    else      dummy := 'NO';
    write_field(tbl[12, 1],tbl[12, 2],tbl[12, 3], dummy);

    Str(autoblank,dummy);
    write_field(tbl[13, 1],tbl[13, 2],tbl[13, 3], dummy);
    if suspend = true then      dummy := 'YES'    else      dummy := 'NO';
    write_field(tbl[14, 1],tbl[14, 2],tbl[14, 3], dummy);

    if dial_delayer>3 then dial_delayer:=0;
    write_field(tbl[15, 1],tbl[15, 2],tbl[15, 3], pk_delay^[dial_delayer]);
    Str(dial_delay_from,dummy);
    write_field(tbl[16, 1],tbl[16, 2],tbl[16, 3], dummy);
    Str(dial_delay_to,dummy);
    write_field(tbl[17, 1],tbl[17, 2],tbl[17, 3], dummy);
    Str(send_delay_from,dummy);
    write_field(tbl[18, 1],tbl[18, 2],tbl[18, 3], dummy);
    Str(send_delay_to,dummy);
    write_field(tbl[19, 1],tbl[19, 2],tbl[19, 3], dummy);
    _reserved1:=reserved1;
    tmp_word:=Trunc(_reserved1*256)+reserved2;
    Str(tmp_word, dummy);
    write_field(tbl[20, 1],tbl[20, 2],tbl[20, 3], dummy);
  end;
end;

procedure edit_misc;
const  tbl : array[1..20, 1..4] of byte =(
  (24,  4, 25, 25), (67,  4,  3,  3),
  (24,  5, 25, 25), (67,  5,  3,  3),
  (24,  6, 25, 25), (67,  6,  3,  3),
  (28,  8,  3,  3), {extern dialer}
  (16,  9, 12, 50),  (39,  9, 18, 50),  (67,  9,  3,  3),
  (26, 11,  9,  9), {progress bar}
  (26, 12,  3,  3), {del 0}

  (53, 11,  3,  3), {autoblank}
  (61, 12,  3,  3), {suspend blank}

  (24, 14, 11, 11), {use delayers}
  (26, 15,  3,  3),
  (26, 16,  3,  3), {dial delay}
  (52, 15,  4,  4),
  (52, 16,  4,  4), {send delay}
  (33, 18,  5,  5)  {random wait between calls}
  );
Var bytab:word;
begin
  for i := 0 to 33 do
    move(pointing^[i*160], screen[i*160], 160);
  pos := 1;
  posold := 1;
  stop := false;
  write_misc;
 display_help(pos+48);
 field_color(tbl[pos,1], tbl[pos,2], tbl[pos,3], $7F);
  repeat
    taste := #0;
    stop := false;
    write_misc;
    if pos <> posold then begin
      field_color(tbl[pos, 1], tbl[pos,2], tbl[pos,3], $7F);
      field_color(tbl[posold,1],tbl[posold,2],tbl[posold,3],$78);
     remove_help(posold+48);
      display_help(pos+48);
   end;
    posold := pos;
    dummy := '';
    with config do begin
      case pos of
	 1: readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, _custom1, taste, false);
	 3: readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, _custom2, taste, false);
	 5: readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, _custom3, taste, false);
	 2:begin cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
                if _custom12 then pk_source:=0 else pk_source:=1;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],2,2,pk_source,pk_yes_no,taste,  $87, $0E, $8F, false);
                if pk_yes_no^[pk_source] = 'YES' then _custom12:=true else _custom12:=false;
             end;end;
	 4:begin cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
                if _custom22 then pk_source:=0 else pk_source:=1;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],2,2,pk_source,pk_yes_no,taste,  $87, $0E, $8F, false);
                if pk_yes_no^[pk_source] = 'YES' then _custom22:=true else _custom22:=false;
             end;end;
	 6:begin cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
                if _custom32 then pk_source:=0 else pk_source:=1;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],2,2,pk_source,pk_yes_no,taste,  $87, $0E, $8F, false);
                if pk_yes_no^[pk_source] = 'YES' then _custom32:=true else _custom32:=false;
             end;end;
	 7:begin cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
                if do_dial_exec then pk_source:=0 else pk_source:=1;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],2,2,pk_source,pk_yes_no,taste,  $87, $0E, $8F, false);
                if pk_yes_no^[pk_source] = 'YES' then do_dial_exec:=true else do_dial_exec:=false;
             end;end;
	 8: begin readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, execute[9].fname  , taste, false);
                  Upc(execute[9].fname);end;
	 9: readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_ascii, execute[9].params , taste, false);
        10: begin Str(execute[9].react,dummy);
		 readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
                 Val(dummy,a,code);
                 if a < 4 then execute[9].react:=a;
            end;
	11: begin
	      cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
		pk_source := balken;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3], 3, 3, pk_source, pk_progress, taste,  $87, $0E, $8F, false);
		balken := pk_source;
	      end;
	    end;
	12:begin cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
                if delete_zero then pk_source:=0 else pk_source:=1;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],2,2,pk_source,pk_yes_no,taste,  $87, $0E, $8F, false);
                if pk_yes_no^[pk_source] = 'YES' then delete_zero:=true else delete_zero:=false;
             end;end;

	13:begin
	      str(autoblank, dummy);
	      readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
	      val(dummy, bytab, code);
              if bytab > 254 then autoblank:=255 else autoblank:=bytab;
           end;
	14:begin cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
                if suspend then pk_source:=0 else pk_source:=1;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],2,2,pk_source,pk_yes_no,taste,  $87, $0E, $8F, false);
                if pk_yes_no^[pk_source] = 'YES' then suspend:=true else suspend:=false;
             end;end;

	15:begin cursoroff;
	      repeat time until keypressed;
	      taste := readkey;
	      if taste = #0 then
		taste := readkey
	      else if taste = #13 then begin
                pk_source:=dial_delayer;
		read_picklist(tbl[pos,1]+1,tbl[pos,2]+1,tbl[pos,3],4,4,pk_source,pk_delay,taste,  $87, $0E, $8F, false);
                dial_delayer:=pk_source;
             end;end;
        16: begin Str(dial_delay_from,dummy);
		 readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
                 Val(dummy,a,code);
                 if (a <= 255) then if (a<=dial_delay_to) then dial_delay_from:=a else dial_delay_from:=dial_delay_to;
            end;
        17: begin Str(dial_delay_to,dummy);
		 readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
                 Val(dummy,a,code);
                 if (a <= 255) then begin if (a>=dial_delay_from) then dial_delay_to:=a else dial_delay_to:=dial_delay_from;
                 end else dial_delay_to:=255;
            end;
        18: begin Str(send_delay_from,dummy);
		 readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
                 Val(dummy,a,code);
                 if (a < 10000) then if (a<=send_delay_to) then send_delay_from:=a else send_delay_from:=send_delay_to;
            end;
        19: begin Str(send_delay_to,dummy);
		 readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
                 Val(dummy,a,code);
                 if (a < 10000) then if (a>=send_delay_from) then send_delay_to:=a else send_delay_to:=send_delay_from;
            end;
        20: begin _reserved1:=reserved1;tmp_word:=Trunc(_reserved1*256)+reserved2; Str(tmp_word,dummy);
                  readstr(tbl[pos,1],tbl[pos,2],tbl[pos,3],tbl[pos,4], mask_num, dummy, taste, false);
                  Val(dummy, dummy_int, code);
                  if dummy_int<0 then dummy_int:=0;
                  if dummy_int>65535 then dummy_int:=65535;
                  reserved1:= dummy_int div 256; reserved2:= dummy_int mod 256;
            end;
    end;
  end;
  case ord(taste) of
    up     : if pos > 1 then dec(pos) else pos := 20;
    sh_tab : if pos > 1 then dec(pos) else pos := 20;
    down   : if pos < 20 then inc(pos) else pos := 1;
    tab    : if pos < 20 then inc(pos) else pos := 1;
    pgup   : if pos > 1 then pos := 1;
    pgdown : if pos < 20 then pos := 20;
    return : if pos < 20 then inc(pos) else pos := 1;
    esc    : stop := true;
  end;
  until stop = true;
  field_color(tbl[pos, 1], tbl[pos,2], tbl[pos,3], $78);
 remove_help(pos+48);
end;

procedure reprint;
begin
   for i := 0 to 33 do
     move(pointing^[i*160], screen[i*160], 160);
   TextColor(0);
   write_field(35, 28, 12, FileName(loadfile));
end;

FUNCTION edit_init(where:byte):byte;
begin
 reprint;
 pk_source:=done;
 read_picklist(31,12,16,8,8,pk_source,pk_init,taste,  $87, $0E, $8F, false);
 edit_init:=pk_source; if escaped then edit_init:=7;
end;


procedure edit_reinit;
begin
 pk_source:=2;
 read_picklist(30,12,17,3,3,pk_source,pk_reinit,taste,  $87, $0E, $8F, false);
 if pk_source = 0 then init;
 if pk_source = 1 then loadit;
end;

procedure edit_save;
begin
   repeat
   reprint;
   pk_source:=0; error:=false; cursoroff;
   read_picklist(29,12,19,4,4,pk_source,pk_save,taste, $87, $0E, $8F, false);
   if escaped then pk_source:=3;
   case pk_source of
   0:begin
      if loadfile<>'' then begin
      assign(config_file,loadfile); {I-}; rewrite(config_file); {I+};
      if IOResult<>0 then begin
          cha:=PutWindow('ERROR','','Couldn`t create File!','','','[Press Enter]',#13+#32+#27,true);
          TextBackGround(1);
      end else begin error:=true; write(config_file,config); close(config_file); end;
      end else begin  cha:=PutWindow('ERROR','','Couldn`t create File!','Input resetted!','','[Press Enter]',#13+#32+#27,true);
          TextBackGround(1); end;
     end;
   1:error:=true;
   2:begin readstr(35,28,12,50, mask_ascii, loadfile, taste, false);
           loadfile:=ForeName(loadfile)+'.CFG'; end;
   3:error:=true;
   end;
   until error;
   if ((pk_source=0)or(pk_source=1))and(escaped=false) then error:=true else error:=false;
end;

begin
     Checkbreak:=False;
end.
