{$R-}
{$S-}
{$O-}

Unit COMMUNIC;

{****************************************************************************}
InterFace
Uses Config, Crt, My2;
Type LineZustand  = (On,Off);
     ParityType   = (None,Even,Odd,Mark,Space);
     StopBitType  = 1..2;
     WordLenType  = 5..8;
     BaudRateType = 75..115200;
     SeriellBuffer = ARRAY [0..$7FFF] OF CHAR;
     SeriellDiscrType = RECORD
                         PortAdresse,                      (* Basis-Adresse des 8250               *)
                         PortIRQ        : WORD;            (* Interrupt-Kanal der Schnittstelle    *)
                         Transmit       : BOOLEAN;         (* FALSE, wenn Empfangspuffer fast voll *)
                         TransmitMask   : BYTE;            (* Maske fr die Statusleitungen        *)
                         BufferSize,                       (* Grsse des Empfangspuffers in Byte   *)
                         BufferFull,                       (* Fll-Grenze fr den Empfangspuffer   *)
                         Top,                              (* erstes Zeichen im Ringpuffers        *)
                         Bottom,                           (* letztes Zeichen im Ringpuffer        *)
                         Anzahl         : WORD;            (* Anzahl Zeichen im Ringpuffer         *)
                         Buffer         : ^SeriellBuffer;  (* Pointer auf den Ringpuffer im Heap   *)
                         Install        : BOOLEAN;         (* TRUE, wenn der Handler belegt ist    *)
                         PortInterrupt,                    (* Pointer auf die Interruptroutine     *)
                         OldVector      : POINTER;         (* Ursprnglicher Interrupt-Vektor      *)
                         LineMask, OldIntMask, OldMCR, OldIER : BYTE;
                         CountInt, CountInChar, CountOutChar, CountError, CountOverflow  : WORD;
                         NS16550Flag    : BOOLEAN;
                       END;
{Fossil}
      FosData = record
         ssize    : word;
         version, revision : byte;
         segment, offset, rcvbuf, i_avail, sndbuf, o_avail : word;
         width, height, baud : byte;
      end;


Const WaitHangOn     = 5 * 18;
      PortBufferSize = $3FF;
      DSRInput  = $20;
      CTSInput  = $10;
      CDInput   = $80;
      RIInput   = $40;
      DTROutput = $01;
      RTSOutput = $02;
      MaxKanal       = 8;      (* Max. sind acht Handler gleichzeitig nutzbar   *)
      NotInstall     = 20000;  (* Der Handler wurde noch nicht installiert      *)
      NoHandler      = 20001;  (* Es ist kein freier Handler mehr vorhanden     *)
      NoChip         = 20002;  (* An der Adresse liegt kein ser. Baustein       *)
      WrongHandler   = 20003;  (* Falsche Handlernummer ( 1 < kanal > MaxKanal) *)
      WrongBaudRate  = 20100;  (* Ungltige Baudrate                            *)
      WrongStopBit   = 20101;  (* Ungltige Anzahl Stopp-Bits                   *)
      WrongWordLen   = 20102;  (* Ungltige bertragungswort-Lnge              *)
{Fossil}
      loopspersec = 6500;
      timeout  = 256;

var SeriellOk    : BOOLEAN;   (* TRUE, wenn kein Fehler erkannt wurde *)
    SeriellError : WORD;      (* <> 0, wenn ein Fehler erkannt wurde  *)
    FiFoAktiv    : BOOLEAN;
    kanal,channel,kanal2:word;
{fossil}
    PortNum, BaudRate : word;
    Parity  : Char;
    DataBits, StopBits : Byte;
    FosInfo : FosData;
    FossilIDStr : string;
{own}
    hh, mm, ss, ms : word;
    debug_filename : string[80];
    ansstr         : string[127];


PROCEDURE FreeInterrupts(kanal : word);

PROCEDURE InstallSeriellHandler (adr,irq,size : WORD ; VAR kanal : WORD);
PROCEDURE DeInstallSeriellHandler (kanal : WORD);
PROCEDURE GetHandlerInfo (kanal : WORD ; VAR adr,ir,buflen : WORD);
FUNCTION  SeriellRead (kanal : WORD) : CHAR;
PROCEDURE SeriellCheckRead (kanal : WORD ; VAR zeichen : CHAR ; VAR flag : BOOLEAN);
PROCEDURE SeriellWrite (kanal : WORD ; zeichen : CHAR);
PROCEDURE ClearSeriellBuffer (kanal : WORD);
FUNCTION  ReceiverReady (kanal : WORD) : BOOLEAN;
FUNCTION  TransmitterReady (kanal : WORD) : BOOLEAN;
FUNCTION  ClearToSend (kanal : WORD) : BOOLEAN;
FUNCTION  DataSetReady (kanal : WORD) : BOOLEAN;
FUNCTION  BreakDetected (kanal : WORD) : BOOLEAN;
FUNCTION  CarrierDetector (kanal : WORD) : BOOLEAN;
FUNCTION  ReceiveFlowBreak (kanal : WORD) : BOOLEAN;
FUNCTION  SendFlowBreak (kanal : WORD) : BOOLEAN;
PROCEDURE DataTerminalReady (kanal : WORD ; zustand : LineZustand);
PROCEDURE RequestToSend (kanal : WORD ; zustand : LineZustand);
PROCEDURE SendBreak (kanal : WORD);
PROCEDURE SetStatusMask (kanal,mask : WORD);
PROCEDURE SetTransmitMask (kanal,mask : WORD);
FUNCTION  SeriellStatus (kanal : WORD) : BOOLEAN;
PROCEDURE SetParameter (kanal : WORD; rate : BaudRateType; parity : ParitYType; stopbit : StopBitType; wordlen : WordLenType);
PROCEDURE SetBaudrate (kanal : WORD ; rate : BaudRateType);
FUNCTION  GetBaudrate (kanal : WORD) : BaudRateType;
PROCEDURE SetParity (kanal : WORD ; parity : ParityType);
FUNCTION  GetParity (kanal : WORD) : ParityType;
PROCEDURE SetStopBit (kanal : WORD ; stopbit : StopBitType);
FUNCTION  GetStopBit (kanal : WORD) : StopBitType;
PROCEDURE SetWordLen (kanal : WORD ; wordlen : WordLenType);
FUNCTION  GetWordLen (kanal : WORD) : WordLenType;
PROCEDURE ClearHandlerStatistic (kanal : WORD);
FUNCTION  GetIntCounter (kanal : WORD) : WORD;
FUNCTION  GetReceiveCounter (kanal : WORD) : WORD;
FUNCTION  GetSendCounter (kanal : WORD) : WORD;
FUNCTION  GetErrorCounter (kanal : WORD) : WORD;
FUNCTION  GetOverflowCounter (kanal : WORD) : WORD;
PROCEDURE ShowTransferStatistic (kanal : WORD);
PROCEDURE KILLMODEMOUTPUT;

{fossil}
function  carrier : boolean;
function  ck : boolean;
procedure closefossil;
function  com_baud(baud:byte) : word;
function  com_data(baud:byte):byte;
function  com_parity(baud:byte):char;
function  com_stop(baud:byte):byte;
procedure comm_set_baud( baud:word; parity : char; data, stop : byte);
procedure flushbuff;
procedure flowcontrol(kind:byte);
function  fpresent : boolean;
procedure getfosinfo( var fosinfo : fosdata);
procedure hangupphone;
procedure modemput(initstr:string);
function  openfossil : boolean;
function  outempty : boolean;
procedure purgeline;
procedure purgeoutput;
procedure readblk(segment,offset,count:word);
function  readline(seconds:integer): integer;
function  receive : char;
procedure send(letter : char);
procedure set_baudrate ( baud : word);
procedure setcheck( on : boolean);
procedure setdtr( a : boolean);
function  serialchar : boolean;
procedure sendtext(initstr : string);
procedure sendblk( Seg_Ment, Off_Set, count:word);

{own}
PROCEDURE DEBUG_MODEM (mode:boolean);
procedure HardHangup(fle:char;hangu:string);
PROCEDURE SeriellWriteStr (kanal3 : WORD ; line : STRING);
Function  CD:boolean; {* Carrier Detecting - Present? *}
Function  TR:boolean; {* Terminal Ready - *}
Function  RR:boolean; {* Receiver Ready - *}
Function  SR:char; {* Seriell Read - Read Char *}
Procedure SW(send_char:char); {* Seriell Write - Write Char *}
Procedure SWSTR(send_string:string); {* Seriell Write String - Write String *}
Procedure DEINSTALLPORT;
Function  INITPORT:byte;
Procedure SETPORT(parity:char;data,stop:byte);
Procedure DISCONNECT(hanguptype:byte);
Function  CHECKOK(wait:word):boolean;


{****************************************************************************}
Implementation
Uses dos;

type
    ptrmask = record   { segment:offset mask for address pointers }
       poff : word;
       pseg : word;
    end;
CONST
    IntrCtrl1      = $20;    (* Basisadresse des ersten Interruptcontroler's  *)
    IntrCtrl2      = $A0;    (* Basisadresse des zweiten Interruptcontroler's *)

VAR i, HandlerSize    : WORD;      (* Grsses eines Handler-Record's      *)
    altexitproc       : POINTER;   (* Pointer auf die alte Exit-Procedure *)
    SeriellDiscriptor : ARRAY [1..MaxKanal] OF SeriellDiscrType;
    Ticker            : LONGINT ABSOLUTE $40:$6C;
    time3:longint;
    debug_file : text;
    debug_switch : boolean;
{fossil}
    regs : registers;

{$L RS232Pas }
PROCEDURE SeriellIntrProc1; External;  (* Definition der externen Interruptroutinen *)
PROCEDURE SeriellIntrProc2; External;
PROCEDURE SeriellIntrProc3; External;
PROCEDURE SeriellIntrProc4; External;
PROCEDURE SeriellIntrProc5; External;
PROCEDURE SeriellIntrProc6; External;
PROCEDURE SeriellIntrProc7; External;
PROCEDURE SeriellIntrProc8; External;
PROCEDURE DisableInterrupt; InLine ($FA);
PROCEDURE EnableInterrupt; InLine ($FB);
(*************************************************************************)

PROCEDURE FreeInterrupts(kanal : word);
VAR adr : WORD;
begin
      WITH SeriellDiscriptor [kanal] DO BEGIN
        IF (Buffer <> NIL) THEN BEGIN                        (* Wenn ein Empfangspuffer angelegt   *)
          FreeMem (Buffer,BufferSize);                       (* wurde, wird dieser vom Heap        *)
          Buffer:=NIL;                                       (* entfernt.                          *)
        END;
        DisableInterrupt;
        PORT [PortAdresse + $01]:=OldIER;                       (* alle Interrupts des 8250 sperren   *)
        PORT [PortAdresse + $04]:=OldMCR;
        IF (PortIRQ <> 0) THEN BEGIN                         (* Interrupt am 8259 sperren und den  *)
          IF (PortIRQ < 8) THEN BEGIN                        (* die Vektor-Adresse restaureien.    *)
            adr:=IntrCtrl1 + $01;
            PORT [adr]:=PORT [adr] OR OldIntMask;
            SetIntVec ($08 + PortIRQ,OldVector);
          END  (* of IF *)
          ELSE BEGIN
            adr:=IntrCtrl2 + $01;
            PORT [adr]:=PORT [adr] OR OldIntMask;
            SetIntVec ($70 + (PortIRQ - 8),OldVector);
          END;  (* of ELSE *)
        END;  (* of IF *)
        EnableInterrupt;
        Install:=FALSE;                        (* Handler freigeben                  *)
     end;
end;


PROCEDURE ClearError;
BEGIN
  SeriellOk:=TRUE;
  SeriellError:=0;
END;  (* of ClearError *)

PROCEDURE SetError (err : WORD);
BEGIN
  SeriellOk:=FALSE;
  SeriellError:=err;
END;  (* of SetErrror *)

PROCEDURE InstallSeriellHandler;
VAR dummy : BYTE;
    wert  : WORD;
BEGIN
  kanal:=1;
  WHILE (SeriellDiscriptor [kanal].Install = TRUE) AND (kanal < MaxKanal) DO  INC (kanal);
  IF (kanal <= MaxKanal) and (kanal>0) THEN BEGIN
    wert:=PORT [adr + $06];
    IF ((PORT [adr + $06] AND $0F) = 0) THEN BEGIN
      WITH SeriellDiscriptor [kanal] DO BEGIN
        Transmit:=TRUE;
        Top:=0;
        Bottom:=0;
        Anzahl:=0;
        CountInt:=0;
        CountInChar:=0;
        CountOutChar:=0;
        CountError:=0;
        CountOverflow:=0;
        TransmitMask:=RTSOutput;
        PortAdresse:=adr;
        PortIRQ:=irq;
        DisableInterrupt;
        OldIER:=PORT [PortAdresse + $01];
        adr:=PortAdresse + $04;
        OldMCR:=PORT [adr];
        PORT [adr]:=OldMCR AND $F7;            (* Alle Interrupts mit OUT 2 sperren  *)
        dummy:=PORT [PortAdresse + $02];
        IF ((dummy AND $C0) > 0) THEN
          NS16550Flag:=TRUE
        ELSE BEGIN
          PORT [PortAdresse + $02]:=$01;
          dummy:=PORT [PortAdresse + $02];
          NS16550Flag:=((dummy AND $C0) > 0);
        END;  (* of ELSE *)
        IF NS16550Flag THEN BEGIN
          IF FiFoAktiv THEN
            PORT [PortAdresse + $02]:=$E1
          ELSE PORT [PortAdresse + $02]:=0;
        END;  (* of IF *)
        dummy:=PORT [PortAdresse];
        dummy:=PORT [PortAdresse + $05];       (* Leitungsstatus-Register lschen    *)
        IF (PortIRQ <> 0) THEN BEGIN           (* Empfangsintr. nur bei IRQ <> 0 installieren *)
          IF (size > $7FFF) THEN size:=$7FFF;  (* Buffersize max. $7FFF            *)
          IF (MaxAvail < size) THEN            (* wenn zuwenig Platz auf dem Heap, *)
            BufferSize:=MaxAvail               (* dann wird der Buffer verkleinert *)
          ELSE BufferSize:=size;
          GetMem (Buffer,BufferSize);          (* Speicher fr den Empfangsbuffer reservieren *)
          BufferFull:=WORD (LONGINT (BufferSize) * 90 DIV 100);
          IF (BufferFull < 10) THEN BufferFull:=10;
          PORT [PortAdresse + $01]:=$01;       (* Interrupt bei Empfang zulassen    *)
          adr:=PortAdresse + $04;
          wert:=PORT [adr];
          PORT [adr]:=wert OR TransmitMask OR $08;          (* Die Steuerleitungen setzen        *)
          IF (PortIRQ < 8) THEN BEGIN                        (* IRQ0 - IRQ7: erster 8259   *)
            GetIntVec ($08 + PortIRQ,OldVector);             (* Interrupt-Vektor retten    *)
            SetIntVec ($08 + PortIRQ,PortInterrupt);         (* und neu setzen             *)

            adr:=IntrCtrl1 + $01;
            OldIntMask:=PORT [adr];
            PORT [adr]:=OldIntMask AND ($FF XOR 1 SHL PortIRQ);
            OldIntMask:=OldIntMask AND (1 SHL PortIRQ);
          END  (* of IF THEN *)
          ELSE BEGIN                                         (* IRQ8 - IRQ15: zweiter 8259 *)
            GetIntVec ($70 + (PortIRQ - 8),OldVector);       (* Interrupt-Vektor retten    *)
            SetIntVec ($70 + (PortIRQ - 8),PortInterrupt);   (* und neu setzen             *)

            adr:=IntrCtrl2 + $01;
            OldIntMask:=PORT [adr];
            PORT [adr]:=OldIntMask AND ($FF XOR 1 SHL (PortIRQ - 8));
            OldIntMask:=OldIntMask AND (1 SHL (PortIRQ - 8));
          END;  (* of ELSE *)
        END  (* of IF THEN *)
        ELSE BEGIN
          Buffer:=NIL;                        (* Ohne Interrupt auch kein Puffer      *)
          OldIntMask:=$00;
        END;  (* of ELSE *)
        dummy:=PORT [PortAdresse];
        dummy:=PORT [PortAdresse + $05];       (* Leitungsstatus-Register lschen    *)
        EnableInterrupt;
        Install:=TRUE;                         (* Handler als belegt kennzeichenen     *)
        ClearError;
      END;  (* of WITH *)
    END  (* of IF THEN *)
    ELSE BEGIN
      kanal:=0;
      SetError (NoChip);
    END;  (* of ELSE *)
  END  (* of IF THEN *)
  ELSE BEGIN
    kanal:=0;                                  (* kanal = 0 wenn kein Handler frei ist *)
    SetError (NoHandler);
  END;  (* of ELSE *)
END;  (* of InstallSeriellHandler *)

PROCEDURE DeInstallSeriellHandler;
VAR adr : WORD;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN          (* Nur gltige Handler bearbeiten     *)
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        IF (Buffer <> NIL) THEN BEGIN                        (* Wenn ein Empfangspuffer angelegt   *)
          FreeMem (Buffer,BufferSize);                       (* wurde, wird dieser vom Heap        *)
          Buffer:=NIL;                                       (* entfernt.                          *)
        END;  (* of IF *)
        DisableInterrupt;
        PORT [PortAdresse + $01]:=OldIER;                       (* alle Interrupts des 8250 sperren   *)
        PORT [PortAdresse + $04]:=OldMCR;
        IF (PortIRQ <> 0) THEN BEGIN                         (* Interrupt am 8259 sperren und den  *)
          IF (PortIRQ < 8) THEN BEGIN                        (* die Vektor-Adresse restaureien.    *)
            adr:=IntrCtrl1 + $01;
            PORT [adr]:=PORT [adr] OR OldIntMask;
            SetIntVec ($08 + PortIRQ,OldVector);
          END  (* of IF *)
          ELSE BEGIN
            adr:=IntrCtrl2 + $01;
            PORT [adr]:=PORT [adr] OR OldIntMask;
            SetIntVec ($70 + (PortIRQ - 8),OldVector);
          END;  (* of ELSE *)
        END;  (* of IF *)
        EnableInterrupt;
        Install:=FALSE;                        (* Handler freigeben                  *)
      END  (* of IF *)
      ELSE SetError (NotInstall);
    END;  (* of WITH *)
  END  (* of IF *)
  ELSE SetError (WrongHandler);
END;  (* of DeInstallSeriellHandler *)

PROCEDURE GetHandlerInfo;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN          (* Nur gltige Handler bearbeiten     *)
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        adr:=PortAdresse;
        ir:=PortIRQ;
        buflen:=BufferSize;
      END  (* of IF *)
      ELSE SetError (NotInstall);
    END;  (* of WITH *)
  END  (* of IF *)
  ELSE SetError (WrongHandler);
END;  (* of GetHandlerInfo *)

FUNCTION SeriellRead; External;

PROCEDURE SeriellCheckRead;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        IF (Anzahl > 0) THEN BEGIN
          zeichen:=Buffer^[Bottom];                (* Zeichen aus dem Puffer holen und     *)
          flag:=TRUE;
        END  (* of IF *)
        ELSE flag:=FALSE;
        ClearError;
      END  (* of IF THEN *)
      ELSE SetError (NotInstall);
    END;  (* of WITH *)
  END  (* of IF THEN *)
  ELSE SetError (WrongHandler);
END;  (* of SeriellCheckRead *)

PROCEDURE SeriellWrite; External;

PROCEDURE ClearSeriellBuffer;
VAR  adr : WORD;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        DisableInterrupt;
        Anzahl:=0;
        Top:=0;
        Bottom:=0;
        IF NOT (Transmit) THEN BEGIN                       (* Wenn der Puffer fast voll war,       *)
          IF (Anzahl < (BufferSize - $10)) THEN BEGIN      (* teste, ob wieder Platz vorhanden ist *)
            adr:=PortAdresse + $04;
            Port [adr]:=Port [adr] OR TransmitMask;        (* Wenn ja, Steuerleitungen setzen und  *)
            Transmit:=TRUE;                                (* das Flag fr "Puffer voll" lschen.  *)
          END;  (* of IF *)
        END;  (* of IF *)
        EnableInterrupt;
        ClearError;
      END  (* of IF *)
      ELSE SetError (NotInstall);
    END;  (* of WITH *)
  END  (* of IF THEN *)
  ELSE SetError (WrongHandler);
END;  (* of ClearSeriellBuffer *)

FUNCTION ReceiverReady; External;

FUNCTION TransmitterReady;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        TransmitterReady:=((Port [PortAdresse + $05] AND $20) > 0);
      END  (* of IF *)
      ELSE TransmitterReady:=FALSE;
    END;  (* of WITH *)
    ClearError;
  END  (* of IF THEN *)
  ELSE BEGIN
    TransmitterReady:=FALSE;
    SetError (WrongHandler);
  END;  (* of ELSE *)
END;  (* of TransmitterReady *)

FUNCTION ClearToSend;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        ClearToSend:=((Port [PortAdresse + $06] AND $10) > 0);
      END  (* of IF *)
      ELSE ClearToSend:=FALSE;
    END;  (* of WITH *)
    ClearError;
  END  (* of IF *)
  ELSE BEGIN
    ClearToSend:=FALSE;
    SetError (WrongHandler);
  END;  (* of ELSE *)
END;  (* of ClearToSend *)

FUNCTION DataSetReady;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        DataSetReady:=((Port [PortAdresse + $06] AND $20) > 0);
      END  (* of IF *)
      ELSE DataSetReady:=FALSE;
    END;  (* of WITH *)
    ClearError;
  END  (* of IF *)
  ELSE BEGIN
    DataSetReady:=FALSE;
    SetError (WrongHandler);
  END;  (* of ELSE *)
END;  (* of DataSetReady *)

FUNCTION CarrierDetector;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        CarrierDetector:=((Port [PortAdresse + $06] AND $80) > 0);
      END  (* of IF *)
      ELSE CarrierDetector:=FALSE;
    END;  (* of WITH *)
    ClearError;
  END  (* of IF *)
  ELSE BEGIN
    CarrierDetector:=FALSE;
    SetError (WrongHandler);
  END;  (* of ELSE *)
END;  (* of CarrierDetector *)

FUNCTION BreakDetected;
VAR adresse : WORD;
    break   : BOOLEAN;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        adresse:=PortAdresse + $05;
        break:=((Port [adresse] AND $08) > 0);
        IF break THEN Port [adresse]:=Port [adresse] AND $F7;
        BreakDetected:=break;
      END  (* of IF *)
      ELSE BreakDetected:=FALSE;
    END;  (* of WITH *)
    ClearError;
  END  (* of IF *)
  ELSE BEGIN
    BreakDetected:=FALSE;
    SetError (WrongHandler);
  END;  (* of ELSE *)
END;  (* of BreakDetected *)

FUNCTION ReceiveFlowBreak;
VAR break   : BOOLEAN;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN
        ReceiveFlowBreak:=NOT (Transmit)
      ELSE ReceiveFlowBreak:=FALSE;
    END;  (* of WITH *)
    ClearError;
  END  (* of IF *)
  ELSE BEGIN
    ReceiveFlowBreak:=FALSE;
    SetError (WrongHandler);
  END;  (* of ELSE *)
END;  (* of ReceiveFlowBreak *)

FUNCTION SendFlowBreak;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        SendFlowBreak:=((Port [PortAdresse + $06] AND LineMask) <> LineMask);
      END  (* of IF *)
      ELSE SendFlowBreak:=FALSE;
    END;  (* of WITH *)
    ClearError;
  END  (* of IF *)
  ELSE BEGIN
    SendFlowBreak:=FALSE;
    SetError (WrongHandler);
  END;  (* of ELSE *)
END;  (* of SendFlowBreak *)

PROCEDURE DataTerminalReady;
VAR wert, adr : WORD;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        adr:=PortAdresse + $04;
        wert:=PORT [adr];
        IF (zustand = On) THEN
          wert:=wert OR $01
        ELSE wert:=wert AND $FE;
        PORT [adr]:=wert;
        ClearError;
      END  (* of IF THEN *)
      ELSE SetError (NotInstall);
    END;  (* of WITH *)
  END  (* of IF *)
  ELSE SetError (WrongHandler);
END;  (* of DataTerminalReady *)

PROCEDURE RequestToSend;
VAR wert, adr : WORD;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        adr:=PortAdresse + $04;
        wert:=PORT [adr];
        IF (zustand = On) THEN
          wert:=wert OR $02
        ELSE wert:=wert AND $FD;
        PORT [adr]:=wert;
        ClearError;
      END  (* of IF THEN *)
      ELSE SetError (NotInstall);
    END;  (* of WITH *)
  END  (* of IF *)
  ELSE SetError (WrongHandler);
END;  (* of RequestToSend *)

PROCEDURE SendBreak;
VAR breaktime : LONGINT;
    teiler, adr : WORD;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        adr:=PortAdresse + $03;
        DisableInterrupt;
        PORT [adr]:=PORT [adr] OR $80;
        teiler:=PortW [PortAdresse];
        PORT [adr]:=PORT [adr] AND $7F;
        EnableInterrupt;
        breaktime:=teiler DIV 200;
        IF (breaktime < 1) THEN breaktime:=1;
        breaktime:=Ticker + breaktime;
        Port [adr]:=Port [adr] OR $40;
        REPEAT
        UNTIL (Ticker > breaktime);
        Port [adr]:=Port [adr] AND $BF;
        ClearError;
      END  (* of IF THEN *)
      ELSE SetError (NotInstall);
    END;  (* of WITH *)
  END  (* of IF *)
  ELSE SetError (WrongHandler);
END;  (* of SendBreak *)

PROCEDURE SetStatusMask;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    SeriellDiscriptor [kanal].LineMask:=(mask MOD $FF);
    ClearError;
  END  (* of IF THEN *)
  ELSE SetError (WrongHandler);
END;  (* of SetStatusMask *)

PROCEDURE SetTransmitMask;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    SeriellDiscriptor [kanal].TransmitMask:=(mask MOD $FF);
    ClearError;
  END  (* of IF THEN *)
  ELSE SetError (WrongHandler);
END;  (* of SetTransmitMask *)

FUNCTION SeriellStatus;
VAR status : WORD;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        IF ((Port [PortAdresse + $05] AND $20) > 0) THEN
          SeriellStatus:=((Port [PortAdresse + $06] AND LineMask) = LineMask)
        ELSE SeriellStatus:=FALSE;
        ClearError;
      END  (* of IF *)
      ELSE BEGIN
        SeriellStatus:=FALSE;
        SetError (NotInstall);
      END;  (* of ELSE *)
    END;  (* of WITH *)
  END  (* of IF *)
  ELSE BEGIN
    SeriellStatus:=FALSE;
    SetError (WrongHandler);
  END;  (* of ELSE *)
END;  (* of SeriellStatus *)

{$F+}
PROCEDURE SeriellInterfaceExit;
{$F-}
VAR adr : WORD;
BEGIN
  FOR i:=1 TO MaxKanal DO BEGIN
    WITH SeriellDiscriptor [i] DO BEGIN
      IF Install THEN BEGIN
        IF (Buffer <> NIL) THEN BEGIN                        (* Wenn ein Empfangspuffer angelegt   *)
          FreeMem (Buffer,BufferSize);                       (* wurde, wird dieser vom Heap        *)
          Buffer:=NIL;                                       (* entfernt.                          *)
        END;  (* of IF *)
        DisableInterrupt;
        PORT [PortAdresse + $01]:=OldIER;                       (* alle Interrupts des 8250 sperren   *)
        PORT [PortAdresse + $04]:=OldMCR;
        IF (PortIRQ <> 0) THEN BEGIN                         (* Interrupt am 8259 sperren und den  *)
          IF (PortIRQ < 8) THEN BEGIN                        (* die Vektor-Adresse restaureien.    *)
            adr:=IntrCtrl1 + $01;
            PORT [adr]:=PORT [adr] OR OldIntMask;
            SetIntVec ($08 + PortIRQ,OldVector);
          END  (* of IF *)
          ELSE BEGIN
            adr:=IntrCtrl2 + $01;
            PORT [adr]:=PORT [adr] OR OldIntMask;
            SetIntVec ($70 + (PortIRQ - 8),OldVector);
          END;  (* of ELSE *)
        END;  (* of IF *)
        EnableInterrupt;
        Install:=FALSE;                        (* Handler freigeben                  *)
      END;  (* of IF *)
    END;  (* of WITH *)
  END;  (* of FOR *)
  ExitProc:=altexitproc;
END;  (* of SeriellInterfaceExit *)

PROCEDURE SetParameter;
VAR basisadr, wert : WORD;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        DisableInterrupt;
        basisadr:=PortAdresse;
        PORT[basisadr + 3]:=$80;
        wert:=WORD (115200 DIV rate);
        PORTW [basisadr]:=wert;
        wert:=0;
        CASE Parity OF
           Even : wert:=wert OR $18;
            Odd : wert:=wert OR $08;
           Mark : wert:=wert OR $28;
          Space : wert:=wert OR $38;
        END;  (* of CASE *)
        IF (stopbit = 2) THEN wert:=wert OR $04;
        wert:=wert + (wordlen - 5);
        Port [basisadr + $03]:=wert;
        wert:=Port [basisadr + $05];
        EnableInterrupt;
        ClearError;
      END  (* of IF THEN *)
      ELSE SetError (NotInstall);
    END;  (* of WITH *)
  END  (* of IF *)
  ELSE SetError (WrongHandler);
END;  (* of SetParameter *)

PROCEDURE SetBaudrate;
VAR basisadr, wert : WORD;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        DisableInterrupt;
        basisadr:=PortAdresse;
        PORT[basisadr + 3]:=PORT[basisadr + 3] OR $80;
        wert:=WORD (115200 DIV rate);
        PORTW [basisadr]:=wert;
        PORT[basisadr + 3]:=PORT[basisadr + 3] AND $7F;
        wert:=Port [basisadr + $05];
        ClearError;
        EnableInterrupt;
      END  (* of IF THEN *)
      ELSE SetError (NotInstall);
    END;  (* of WITH *)
  END  (* of IF *)
  ELSE SetError (WrongHandler);
END;  (* of SetBaudrate *)

FUNCTION GetBaudrate;
VAR teiler, basisadr, wert : WORD;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        basisadr:=PortAdresse;
        DisableInterrupt;
        PORT [basisadr+3]:=PORT[basisadr+3] OR $80;
        teiler:=PORTW[basisadr];
        PORT [basisadr + 3]:=PORT [basisadr + 3] AND $7F;
        EnableInterrupt;
        IF (teiler <> 0) THEN
          GetBaudrate:=LONGINT (115200 DIV teiler)
        ELSE GetBaudrate:=75;
        ClearError;
      END  (* of IF *)
      ELSE BEGIN
        GetBaudrate:=75;
        SetError (NotInstall);
      END;  (* of ELSE *)
    END;  (* of WITH *)
  END  (* of IF *)
  ELSE BEGIN
    GetBaudrate:=75;
    SetError (WrongHandler);
  END;  (* of ELSE *)
END;  (* of GetBaudrate *)

PROCEDURE SetParity;
VAR basisadr, wert : WORD;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        basisadr:=PortAdresse;
        DisableInterrupt;
        wert:=Port [basisadr + $03];
        wert:=wert AND $C7;
        CASE Parity OF
           Even : wert:=wert OR $18;
            Odd : wert:=wert OR $08;
           Mark : wert:=wert OR $28;
          Space : wert:=wert OR $38;
        END;  (* of CASE *)
        Port [basisadr + $03]:=wert;
        wert:=Port [basisadr + $05];
        EnableInterrupt;
      END  (* of IF *)
      ELSE SetError (NotInstall);
    END;  (* of WITH *)
  END  (* of IF *)
  ELSE SetError (WrongHandler);
END;  (* of SetParity *)

FUNCTION GetParity;
VAR basisadr, wert : WORD;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        basisadr:=PortAdresse;
        wert:=Port [basisadr + $03] AND $38;
        IF ((wert AND $08) > 0) THEN BEGIN
          wert:=wert SHR 4;
          CASE wert OF
            0 : GetParity:=Odd;
            1 : GetParity:=Even;
            2 : GetParity:=Mark;
            3 : GetParity:=Space;
          END;  (* of CASE *)
        END  (* of IF THEN *)
        ELSE GetParity:=None;
      END  (* of IF *)
      ELSE BEGIN
        GetParity:=None;
        SetError (NotInstall);
      END;  (* of ELSE *)
    END;  (* of WITH *)
  END  (* of IF *)
  ELSE BEGIN
    GetParity:=None;
    SetError (WrongHandler);
  END;  (* of ELSE *)
END;  (* of GetParity *)

PROCEDURE SetStopBit;
VAR basisadr, wert : WORD;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        basisadr:=PortAdresse;
        DisableInterrupt;
        wert:=Port [basisadr + $03];
        IF (stopbit = 2) THEN
          wert:=wert OR $04
        ELSE wert:=wert AND $FB;
        Port [basisadr + $03]:=wert;
        wert:=Port [basisadr + $05];
        EnableInterrupt;
      END  (* of IF THEN *)
      ELSE SetError (NotInstall);
    END;  (* of WITH *)
  END  (* of IF THEN *)
  ELSE SetError (WrongHandler);
END;  (* of SetStopBit *)

FUNCTION GetStopBit;
VAR basisadr, wert : WORD;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        basisadr:=PortAdresse;
        wert:=Port [basisadr + $03];
        IF ((wert AND $04) > 0) THEN
          GetStopBit:=2
        ELSE GetStopBit:=1;
      END  (* of IF *)
      ELSE BEGIN
        GetStopBit:=1;
        SetError (NotInstall);
      END;  (* of ELSE *)
    END;  (* of WITH *)
  END  (* of IF THEN *)
  ELSE BEGIN
    GetStopBit:=1;
    SetError (WrongHandler);
  END;  (* of ELSE *)
END;  (* of GetStopBit *)

PROCEDURE SetWordLen;
VAR basisadr, wert : WORD;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        basisadr:=PortAdresse;
        DisableInterrupt;
        wert:=Port [basisadr + $03];
        wert:=wert AND $FC;
        wert:=wert + (wordlen - 5);
        Port [basisadr + $03]:=wert;
        wert:=Port [basisadr + $05];
        EnableInterrupt;
      END  (* of IF THEN *)
      ELSE SetError (NotInstall);
    END;  (* of WITH *)
  END  (* of IF *)
  ELSE SetError (WrongHandler);
END;  (* of SetWordLen *)

FUNCTION GetWordLen;
VAR basisadr, wert : WORD;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        basisadr:=PortAdresse;
        wert:=Port [basisadr + $03];
        GetWordLen:=(wert AND $03) + 5;
      END  (* of IF THEN *)
      ELSE BEGIN
        GetWordLen:=5;
        SetError (NotInstall);
      END;  (* of IF *)
    END;  (* of WITH *)
  END  (* of IF THEN *)
  ELSE BEGIN
    GetWordLen:=5;
    SetError (WrongHandler);
  END;  (* of ELSE *)
END;  (* of GetWordLen *)

PROCEDURE ClearHandlerStatistic;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        CountInt:=0;
        CountInChar:=0;
        CountOutChar:=0;
        CountError:=0;
        CountOverflow:=0;
        ClearError;
      END  (* of IF THEN *)
      ELSE SetError (NotInstall);
    END;  (* of WITH *)
  END  (* of IF *)
  ELSE SetError (WrongHandler);
END;  (* of SetWordLen *)

FUNCTION GetIntCounter;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        GetIntCounter:=CountInt;
        ClearError;
      END  (* of IF THEN *)
      ELSE BEGIN
        GetIntCounter:=0;
        SetError (NotInstall);
      END;  (* of IF *)
    END;  (* of WITH *)
  END  (* of IF THEN *)
  ELSE BEGIN
    GetIntCounter:=0;
    SetError (WrongHandler);
  END;  (* of ELSE *)
END;  (* of GetIntCounter *)

FUNCTION GetReceiveCounter;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        GetReceiveCounter:=CountInChar;
        ClearError;
      END  (* of IF THEN *)
      ELSE BEGIN
        GetReceiveCounter:=0;
        SetError (NotInstall);
      END;  (* of IF *)
    END;  (* of WITH *)
  END  (* of IF THEN *)
  ELSE BEGIN
    GetReceiveCounter:=0;
    SetError (WrongHandler);
  END;  (* of ELSE *)
END;  (* of GetReceiveCounter *)

FUNCTION GetSendCounter;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        GetSendCounter:=CountOutChar;
        ClearError;
      END  (* of IF THEN *)
      ELSE BEGIN
        GetSendCounter:=0;
        SetError (NotInstall);
      END;  (* of IF *)
    END;  (* of WITH *)
  END  (* of IF THEN *)
  ELSE BEGIN
    GetSendCounter:=0;
    SetError (WrongHandler);
  END;  (* of ELSE *)
END;  (* of GetSendCounter *)

FUNCTION GetErrorCounter;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        GetErrorCounter:=CountError;
        ClearError;
      END  (* of IF THEN *)
      ELSE BEGIN
        GetErrorCounter:=0;
        SetError (NotInstall);
      END;  (* of IF *)
    END;  (* of WITH *)
  END  (* of IF THEN *)
  ELSE BEGIN
    GetErrorCounter:=0;
    SetError (WrongHandler);
  END;  (* of ELSE *)
END;  (* of GetErrorCounter *)

FUNCTION GetOverflowCounter;
BEGIN
  IF (kanal > 0) AND (kanal <= MaxKanal) THEN BEGIN
    WITH SeriellDiscriptor [kanal] DO BEGIN
      IF Install THEN BEGIN
        GetOverflowCounter:=CountOverflow;
        ClearError;
      END  (* of IF THEN *)
      ELSE BEGIN
        GetOverflowCounter:=0;
        SetError (NotInstall);
      END;  (* of IF *)
    END;  (* of WITH *)
  END  (* of IF THEN *)
  ELSE BEGIN
    GetOverflowCounter:=0;
    SetError (WrongHandler);
  END;  (* of ELSE *)
END;  (* of GetOverflowCounter *)

PROCEDURE ShowTransferStatistic (kanal : WORD);
BEGIN
  WriteLn;
  WriteLn ('Transferstatistic for channel ' + CHR ((kanal MOD 10) + 48));
  WriteLn;
  WriteLn ('Interrupt''s ......... ',GetIntCounter (kanal));
  WriteLn ('Sent char''s ......... ',GetSendCounter (kanal));
  WriteLn ('Received char''s ..... ',GetReceiveCounter (kanal));
  WriteLn ('Errors detected ..... ',GetErrorCounter (kanal));
  WriteLn ('Overflows detected .. ',GetOverflowCounter (kanal));
  WriteLn;
  WriteLn ('Carrier Connect ..... ',CarrierDetector(kanal));
  WriteLn;
END;  (* of ShowTransferStatistik *)


{### FOSSIL ###}

function Asc2Str(var s; max: byte): string;
{ Converts an ASCIIZ string to a Turbo Pascal string with a max length: max. }
var starray  : array[1..255] of char absolute s;
    len      : integer;
begin
     len        := pos(#0,starray)-1;                       { Get the length }
     if (len > max) or (len < 0) then               { length exceeds maximum }
       len      := max;                                  { so set to maximum }
     Asc2Str    := starray;
     Asc2Str[0] := chr(len);                                    { Set length }
end;  { Asc2Str }

function com_baud(baud:byte):word;
begin
  baud := baud shr 5;
  case baud of
    $02 : com_baud :=   300;
    $03 : com_baud :=   600;
    $04 : com_baud :=  1200;
    $05 : com_baud :=  2400;
    $06 : com_baud :=  4800;
    $07 : com_baud :=  9600;
    $00 : com_baud := 19200;
    $01 : com_baud := 38400;
  else
    com_baud := 1200;
  end;
end;

function fpresent : boolean;             (* FOSSIL there? *)
Var Int14Vec : Pointer;
begin
  GetIntVec($14, Int14Vec);
  FPresent := (MemW[Seg(Int14Vec^):Ofs(Int14Vec^) + 6] = $1954);
end;

function openfossil : boolean;
begin
  regs.ah := $04;
  regs.dx := PortNum;
  Intr($14,regs); { TPX00( regs) ; }
  OpenFossil := (Regs.AX = $1954);
end;

function ck : boolean;
begin
   ck := FALSE;
   if keypressed then
      ck := (readkey in [#3,#11])
   else if serialchar then ck := (receive in [#3,#11]);
end;

procedure closefossil;
begin
  asm
     mov ah, 5
     mov dx, portnum
     int 14h
  end;
end;

function com_data(baud:byte):byte; { pass it: FossInfo.baud }
var p : boolean;
begin
    p := (baud and $03) = $03;
    if p then com_data := 8 else com_data := 7;
end;

function com_parity(baud:byte):char; { pass it: FossInfo.baud }
var p : boolean;
begin
    p := (baud and $18) = $18;
    if p then com_parity := 'E' else begin
       p := (baud and $08) = $08;
       if p then com_parity := 'O' else com_parity := 'N';
    end;
end;

function com_stop(baud:byte):byte; { pass it: FossInfo.baud }
begin
  com_stop := (baud and $04) + 1;
end;

procedure comm_set_baud( baud : word; parity : char; data, stop : byte);
var value : byte;
begin
   Regs.AH := 0;
   Regs.DX := PortNum;
   value := $60;
   case baud of
       300 : value:=$40;
       600 : value:=$60;
      1200 : value:=$80;
      2400 : value:=$A0;
      4800 : value:=$C0;
      9600 : value:=$E0;
     19200 : value:=$00;
     38400 : value:=$20;
     57600 : value:=$20;
     else value:=$A0;
   end;
   case upcase(parity) of
   {  'N': value := value OR $10; }
     'E': value := value + $18;
     'O': value := value + $08;
   end;
   case data of
     7 : value := value + $02;
     8 : value := value + $03;
   end;
   case stop of
     2 : value := value + $04;
   end;
   regs.al := value;
   Intr($14,regs);
end;

procedure flowcontrol(kind:byte);
begin
   asm
     mov AH, 0FH        { Enable/Disable ComPort Flow Control }
     mov AL, kind       { Type of flow control as above       }
     mov DX, Portnum
     int 14H
   end;
end;

procedure set_baudrate ( baud : word); { issues N-8-1 }
begin
   case baud of
       300 : Regs.AL:=$43;
       600 : Regs.AL:=$63;
      1200 : Regs.AL:=$83;
      2400 : Regs.AL:=$A3;
      4800 : Regs.AL:=$C3;
      9600 : Regs.AL:=$E3;
     19200 : Regs.AL:=$03;
     38400 : Regs.AL:=$23;
     57600 : Regs.AL:=$23;
   else
      regs.al := $A3;
   end;
   regs.ah := $00;
   regs.dx := Portnum;
   Intr($14, regs);
end;

function carrier : boolean;
begin
asm
      mov  dx, PortNum
      mov  ah, 3
      int  14H
      xor  dl, dl
      and  al, 80H
      jz   @2
      inc  dl
@2:   mov  @Result, DL
end;
end;

function keychar : boolean;
begin
  asm
       mov  ah, 0DH
       mov  dx, Portnum
       int  14H
       xor  dl, dl
       inc  ax
       jz   @1
       mov  dl, 1
  @1:  mov @Result, dl
  end;
end;

procedure setdtr( A : Boolean); assembler;
asm
     mov ah, 6
     mov dx, Portnum
     mov al, a
     int 14H
end;

function serialchar : boolean;
begin
   asm
       mov  dx, Portnum
       mov  ah, 0CH
       int  14H          { $FF if no characters }
       xor  dl, dl
       inc  ax
       jz   @l1          { would be zero if no characters here }
       inc  dl           { There is one! }
  @l1: mov  @Result, DL
  end;
end;

function receive : char;
begin
   asm
      mov ah, 2
      mov dx, Portnum
      int 14H
      mov @result, al
   end;
end;

function outempty : boolean;
begin
asm
     mov  ah, 3
     mov  dx, PortNum
     int  14H
     xor  dl, dl
     and  ah, 40H
     jz   @l1
     inc  dl
@l1: mov  @Result, DL
end;
end;

procedure send(Letter : char);
Begin
{  while not outempty do;###}
  asm
       mov AH, 01H
       mov AL, Letter
       mov dx, PortNum
       int 14H
  end;
end;

procedure flushbuff; assembler;
asm
   mov ah, 8
   mov dx, portnum
   int 14h
end;

procedure getfosinfo( var fosinfo : fosdata);
var  p    : ^byte;
     s    : string;
begin
   regs.ah := $1B;
   regs.cx := SizeOf(fosinfo);
   regs.es := Seg(fosinfo);
   regs.di := Ofs(fosinfo);
   regs.dx := PortNum;
   intr($14,regs);
   p := ptr(fosinfo.offset,fosinfo.segment);
   s := Asc2Str(p^ , 255);
   FossilIdStr := s;
end;

procedure modemput( initstr : String); { send a command to modem }
var i: integer;
begin
  for i := 1 to length(initstr) do begin
    case initstr[i] of
      '-' : begin end;      { Hyphen        Stripped            }
      '.' : send(',');      { Period        Translated to Comma }
      '^' : setdtr(TRUE);   { Carat         Raise DTR Line      }
      '`' : delay2(50);      { Accent Mark   1/20th Second delay2 }
      'v' : setdtr(FALSE);  { Lower Case V  Lower DTR Line      }
      '|' : send(#13);       { Pipe,Bar      Carriage Return Sent}
      '~' : delay2(1000);    { Tilde         1 Second delay2      }
    else Send(initstr[i]);
    end; { case }
    delay2(10);
  end; { for }
  {FlushBuff;}
  delay2(500);
end;

function readline(seconds:integer): integer;
var j : integer;
begin
    j := loopspersec * seconds;
    repeat
      dec(j)
    until SerialChar OR (j = 0);
    IF j = 0 THEN
       READLINE := timeout
    ELSE READLINE := ORD(Receive);
end;

procedure purgeline; assembler;
asm
    mov ah, 0aH
    mov dx, Portnum
    Int 14H
end;

procedure purgeoutput; assembler;
asm
   mov ah, 9
   mov dx, PortNum
   int 14H
end;

procedure setcheck( on : boolean); assembler;
asm
    mov ah,  10H
    mov dx,  Portnum
    mov al,  on
    int 14H
end;

procedure sendtext(initstr: string);
var i: integer;
begin
   for i := 1 to ord(initstr[0]) DO send(initstr[i]);
end;

procedure hangupphone;
var i : integer;
    regs : Registers;
begin
  setdtr(false);
  delay2(1000);
  repeat
     delay2(500);
     inc(i);
  until (not carrier) OR (i >= 5);
  if carrier then write(#07+#07+#07+#07,'*Hangup Manually*');
  setdtr(true);
end;

PROCEDURE SendBlk(Seg_Ment, Off_Set, count : word);
begin
asm
      mov ES, Seg_Ment
 @1:  mov CX, Count
      mov AH, 19H
      mov DI, Off_Set
      mov DX, PortNum
      int 14H
      sub Count, AX
      add Off_Set, AX
      cmp Count, 0
      jnz @1
end;
end;

PROCEDURE ReadBlk(segment,offset,count : word );
begin
   regs.es := segment;
   while (count > 0) do begin
      regs.ah := $18;
      regs.di := offset;
      regs.cx := count;
      regs.dx := PortNum;
      intr($14,regs);
      count := count - regs.ax;            { # of chars to go }
      offset := offset + regs.ax;
   end;
end;

{### OWN ###}
PROCEDURE DEBUG_MODEM (mode:boolean);
begin
   if (mode) and (debug_switch=false) then begin
      if debug_filename<>'' then begin
         assign(debug_file,debug_filename);
{I-}
         append(debug_file);
{I+}
         If IOResult<>0 then begin
{I-}
            rewrite(debug_file);
{I+}
            If IOResult=0 then debug_switch:=true;
         end else debug_switch:=true;
      end;
   end else if (mode=false) and (debug_switch) then begin
      close(debug_file);
      debug_switch:=false;
   end;
end;

procedure HardHangup(fle:char;hangu:string);
begin
  SW(#13);
  delay2(1300);
  SW(fle); SW(fle); SW(fle);
  delay2(1200);
  SWSTR(hangu+#13);
  delay2(1000);
end;

PROCEDURE SeriellWriteStr (kanal3 : WORD ; line : STRING);
VAR i : WORD;
BEGIN
  for i:=1 to length(line) do begin repeat Multitasker until TransmitterReady(kanal3); SeriellWrite(kanal3,line[i]); end;
END;  (* of SeriellWriteStr *)

Function CD:boolean;
begin
   if cfg.use_fossil then CD:=Carrier else CD:=CarrierDetector(kanal2);
end;
Function TR:boolean;
begin
   if cfg.use_fossil then TR:=OutEmpty else TR:=TransmitterReady(kanal2);
end;
Function RR:boolean;
begin
   if cfg.use_fossil then RR:=SerialChar else RR:=ReceiverReady(kanal2);
end;
Function SR:char;
Var readchar:char;
begin
   if cfg.use_fossil then readchar:=Receive else readchar:=SeriellRead(kanal2);
   SR:=readchar;
   if debug_switch then write(debug_file,readchar);
end;
Procedure SW(send_char:char);
begin
   if cfg.use_fossil then Send(send_char) else SeriellWrite(kanal2,send_char);
end;
Procedure SWSTR(send_string:string);
begin
   if cfg.use_fossil then SendText(send_string) else SeriellWriteStr(kanal2,send_string);
end;
Procedure SetPort(parity:char;data,stop:byte);
begin
   if (cfg.speed=57600) and (cfg.use_fossil) then cfg.speed:=38400;
   if cfg.use_fossil then
      begin
         if cfg.comport=0 then Portnum:=1 else PortNum:=cfg.comport-1;
         Comm_Set_Baud(cfg.speed,parity,data,stop)
      end else begin
         case UpCase(parity) of
            'O': SetParameter(kanal2,cfg.speed,Odd,stop,data);
            'E': SetParameter(kanal2,cfg.speed,Even,stop,data);
            'M': SetParameter(kanal2,cfg.speed,Mark,stop,data);
            'S': SetParameter(kanal2,cfg.speed,Space,stop,data);
            else SetParameter(kanal2,cfg.speed,None,stop,data) end;
      end;
end;

Procedure DEINSTALLPORT;
begin
   if cfg.use_fossil then CloseFossil else DeinstallSeriellHandler(kanal2);
end;

Function  INITPORT:byte;
begin
   InitPort:=0;
  Multitasker;
   if cfg.use_fossil then begin
      if cfg.speed=14400 then cfg.speed:=19200;
      If not OpenFossil then InitPort:=24 else Comm_Set_Baud(cfg.speed, 'N', 8, 1);
   end else begin
     Multitasker;
      InstallSeriellHandler(cfg.baseadress,cfg.irq,PortBufferSize,kanal2);
     Multitasker;
      if kanal2=0 then InitPort:=1 else begin
        Multitasker;
         SetParameter(kanal2,cfg.speed,None,1,8);
        Multitasker;
         SetStatusMask(kanal2,CTSInput);
        Multitasker;
         SetTransmitMask(kanal2,RTSOutput);
        Multitasker;
         DataTerminalReady(kanal2,On);
        Multitasker;
         ClearHandlerStatistic(kanal2);
        Multitasker;
         Init_Elapse(time3);
         repeat Multitasker until (TR)or(Elapse(time3)>2);
         if Elapse(time3)>2 then InitPort:=1;
        Multitasker;
      end;
   end;
end;

Procedure DISCONNECT(hanguptype:byte); {0:fast, 1:wait, 2:carrier}
begin
   if outdial=false then begin
      if cfg.use_fossil then begin
         HangUpPhone;
         if cfg.fast_hangup=false then begin
            if Carrier then HardHangup(cfg.flee,cfg.hangup)
               else begin
               Send(#13); delay2(cfg.cmd_delay); SendText('AT'+cfg.hangup+#13);
               end;
            if (hanguptype=2)or(cfg.fast_hangup=false) then delay2(500);
         end;
      end else begin
         IF (CarrierDetector(kanal2))or(TransmitterReady(kanal2)=false) THEN BEGIN
                if carrierDetector(kanal2) then DataTerminalReady (kanal2,Off);
                Init_Elapse(time3);
                repeat Multitasker until (Elapse(time3)>5)or(CarrierDetector(kanal2)=false);
                if carrierDetector(kanal2) then begin
                   DataTerminalReady (kanal2,On);
                   Init_Elapse(time3);
                   repeat Multitasker until(TransmitterReady(kanal2))or(Elapse(time3)>3);
                   if TransmitterReady(kanal2) then HardHangup(cfg.flee,cfg.hangup) else begin
                      DeInstallSeriellHandler(kanal2);
                      InitPort;
                      If CarrierDetector(kanal2) then Disconnect(2);
                   end;
                end;
                DataTerminalReady (kanal2,On);
         END ELSE BEGIN
             if cfg.fast_hangup=false then begin
                SeriellWrite(kanal2,#13);
                delay2(cfg.cmd_delay+200);
             end;
             SeriellWriteStr(kanal2,'AT'+cfg.hangup+#13);
         END;
         if hanguptype>0 then delay2(500);
      end
   end else begin
     if hanguptype=2 then HardHangup(cfg.dialup_hangup, 'ATH')
        else begin
           SW(#13); delay2(500);
           SWStr('ATH'+#13);
        end;
     if hanguptype=1 then delay2(500);
     if hanguptype=2 then delay2(1000);
   end;
END;  (* of Disconnect *)

Function  CHECKOK(wait:word):boolean;
Var timeans:longint; done_ans:boolean;
BEGIN
   Init_Elapse(timeans); done_ans:=false; CHECKOK:=false; ansstr:='';
   repeat
       if RR then begin ansstr:=ansstr + SR;
          if Pos('ERROR',ansstr)>0 then done_ans:=true;
          if Pos('BUSY',ansstr)>0 then done_ans:=true;
          if Pos('OK',ansstr)>0 then done_ans:=true;
          if Pos('NO CARRIER',ansstr)>0 then done_ans:=true;
          if Pos('VOICE',ansstr)>0 then done_ans:=true;
       end else Multitasker;
   until (done_ans)or(Elapse_MS(timeans)>wait)or(Length(ansstr)>=126);
   If POS('OK',ansstr)>0 then CHECKOK:=true;
END; {* of CheckOK *}

Procedure KILLMODEMOUTPUT;
begin
   Delay2(10); ansstr:='';
   while RR do begin ansstr:=ansstr+SR; delay2(3); if length(ansstr)>=126 then Delete(ansstr,1,2);end;
end;

{****************************************************************************}


{* MAIN *}
BEGIN
  SetCBreak(False); Checkbreak:=false;
  HandlerSize:=SizeOf (SeriellDiscrType);
  FOR i:=1 TO Maxkanal DO BEGIN
    WITH SeriellDiscriptor [i] DO BEGIN
      Install:=FALSE;
      Buffer:=NIL;
      OldVector:=NIL;
    END;  (* of WITH *)
  END;  (* of FOR *)
  SeriellDiscriptor [1].PortInterrupt:=@SeriellIntrProc1;
  SeriellDiscriptor [2].PortInterrupt:=@SeriellIntrProc2;
  SeriellDiscriptor [3].PortInterrupt:=@SeriellIntrProc3;
  SeriellDiscriptor [4].PortInterrupt:=@SeriellIntrProc4;
  SeriellDiscriptor [5].PortInterrupt:=@SeriellIntrProc5;
  SeriellDiscriptor [6].PortInterrupt:=@SeriellIntrProc6;
  SeriellDiscriptor [7].PortInterrupt:=@SeriellIntrProc7;
  SeriellDiscriptor [8].PortInterrupt:=@SeriellIntrProc8;
  altexitproc:=ExitProc;
  ExitProc:=@SeriellInterfaceExit;
  SeriellError:=0;
  SeriellOk:=TRUE;
  FiFoAktiv:=TRUE;
  Debug_filename:='MODEM.LOG';
END.
