program extract_numbers;
uses my2,crt,dos,version;
var f,g     : text;
    x, y, z : string;
    i, j, k : string;
    a, b, c : word;
    fname1, fname2 : string;
    le      : byte;
    i_by, read, count : word;
    lang    : longint;
    remove, only, check, quit, finish : boolean;
    by, prefix : string;
    ch      : char;



procedure help;
begin
   writeln('EXTR-NO.EXE <inputfile> <outputfile> [<numberlength> <prefix> REMOVE ONLY]');
   writeln;
   writeln('OPTIONS : <inputfile>    File to search for (phone) numbers');
   writeln('          <outputfile>   File to write found numbers to');
   writeln;
   writeln('OPTIONAL: <numberlength> numbers must have at least this length (Standard:8)');
   writeln('          <prefix>       will write this prefix in front of every valid number');
   writeln('                         Note that <prefix> must be a number only, like 800');
   writeln('          REMOVE         if this word is specified, all "+/-.,() " are removed');
   writeln('          ONLY           if this word is specified, the numbers may have NOT');
   writeln('                         seperators like "-" in "1-800" in it.');
   writeln;
   writeln('if you want to specify the <prefix>, REMOVE and/or ONLY option, you must set');
   writeln('the numberlength before that!');
   halt;
end;

procedure error(typ:byte);
begin
   write('Error (',typ,') : ');
   case typ of
     1:writeln('Inputfile not found : ',fname1);
     2:writeln('Couldn`t create outputfile : ',fname2);
     3:writeln('Minimum number length variable must be between 1 and 255');
     4:writeln('Unknown Option : ',ParamStr(4));
     5:writeln('Inputfile and outputfile must be different!');
     6:writeln('Unknown Option : ',ParamStr(5));
     7:writeln('Prefix must be a number only! (like 800 or 0130) : ',prefix);
   end;
   halt;
end;

begin
   writeln('EXTRACT NUMBERS ',ver,author,email); writeln;
   prefix:=''; Checkbreak:=false; SetCBreak(FALSE);
   if (Paramcount<2)or(Paramcount>6) then help;
   fname1:=ParamStr(1); fname2:=ParamStr(2); Upc(fname1); Upc(Fname2);
   if not checkfile(fname1) then Error(1);
   le:=8; remove:=false;
   if fname1=fname2 then error(5);
   if paramcount>2 then le:=Str2Longint(ParamStr(3)) mod 256;
   if le=0 then Error(3);
   only:=false;
   if (ParamCount>3) then begin
      x:=PAramStr(4);
      if Upcase(X[1])='R' then remove:=True;
      if Upcase(X[1])='O' then Only:=True;
      if (x[1]>='0')and(x[1]<='9') then prefix:=x;
      if (remove=false)and(only=false)and(prefix='') then error(4);
   end;
   if (ParamCount>4) then begin
      x:=PAramStr(5);
      if Upcase(X[1])='R' then remove:=True;
      if Upcase(X[1])='O' then Only:=True;
      if (x[1]>='0')and(x[1]<='9') then prefix:=x;
      if (remove=false)and(only=false) then error(5);
   end;
   if (ParamCount=6) then begin
      x:=PAramStr(5);
      if Upcase(X[1])='R' then remove:=True;
      if Upcase(X[1])='O' then Only:=True;
      if (x[1]>='0')and(x[1]<='9') then prefix:=x;
      if (remove=false)or(only=false)or(prefix='') then error(5);
   end;
   if prefix<>'' then if (Str2Longint(prefix)<1)and((prefix[1]<>'0')or(Length(prefix)>1)) then error(7);
   assign(g,fname2);
   if Checkfile(fname2) then begin
      write('Filename exists. Append? (Y/n) ');
      repeat Multitasker until keypressed; ch:=Upcase(readkey);
      if ch='N' then begin writeln ('No'); {I-} rewrite(g); {I+} end else
                     begin writeln ('Yes');{I-} append(g); {I+} end;
      if ch=#0 then ch:=readkey; writeln;
   end else begin {I-} rewrite(g); {I+} end;
   if IOResult<>0 then Error(2);
   assign(f,fname1); reset(f);
   count:=0;
   writeln('Inputfile   : ',fname1);
   writeln('Outputfile  : ',fname2);
   writeln('Min. Length : ',le);
     write('Remove Chars: '); if remove then writeln('ON') else writeln('OFF');
     write('Only Numbers: '); if only then writeln('ON') else writeln('OFF');
     write('Prefix      : '); if prefix='' then writeln('<none>') else writeln(prefix);
   if only then remove:=false; z:='0123456789'; if only=false then z:=z+'+/ -.,()';
   while EOF(f)=false do begin
     readln(f,x); a:=1;
     repeat
        while ((x[a]<'0')or(x[a]>'9'))and(a+le-1<=length(x)) do inc(a);
        if (x[a]>='0')and(x[a]<='9') then begin y:=''; check:=false; quit:=false; finish:=false;
           repeat
             y:=y+x[a]; inc(a);
             if a<=Length(x) then begin if Pos(x[a],'+/ -.,()')>0 then begin
                if check=false then check:=true else quit:=true;
             end else check:=false; end;
             if a>Length(x) then begin finish:=true; a:=Length(x); end;
           until (Pos(x[a],z)=0)or(a-1>=Length(x))or(quit)or(finish); if quit then Delete(y,Length(y),1);
           i:=RemoveChar(y,'0123456789');
           if length(i)>=le then begin inc(count); if (only)or(remove) then writeln(g,prefix,i) else writeln(g,prefix,y); end;
        end;
     until a+le-1>=length(x);
   end;
   close(f); close(g); writeln(count,' numbers found.');
end.
