{ͻ
  Unit      _Declare.pas                                 
                                                         
  Compiler  Turbo Pascal 6.0                             
                                                         
  Date      02.02.90                                     
                                                         
  Update    06.06.90                                     
                                                         
  Autor     Reiner Schlles                              
 Ķ
  Inhalt    Beinhaltet die globalen Vereinbarungen von   
            Konstanten, Variablen und Datentypen, die in 
            den brigen Units des Unitsystems bentigt   
            werden.                                      
 ͼ}
Unit _Declare;
{ͻ
  Interface (ffentlicher Teil)                           
 ͼ}
Interface
uses {Einzubindende Bibliotheken}
  Crt,Dos;                {Units aus dem Turbo Pascal-System}

const {Globale Konstanten}
  _MaxReal: real =  1.7E38;
  _MinReal: real = -1.7E38;

  _Error : byte = 0;   {Fehlernummer. Initialisierung mit  }
                       {0 fr fehlerfreie Ausfhrung.      }
  _WarnTon: boolean = true;   {Der bei einigen Routien ver-}
                              {wendete Piepton kann global }
                              {ein- oder ausgeschaltet wer-}
                              {den:   TRUE  - Piepton ein  }
                              {       FALSE - Piepton aus  }
                              {Fehlermeldungen bleiben da- }
                              {von jedoch unberhrt.       }

type
  {String-Vereinbarungen unterschiedlicher Lnge}
  _Str1    = string[1];                {String der Lnge  1}
  _Str2    = string[2];                {String der Lnge  2}
  _Str3    = string[3];                {String der Lnge  3}
  _Str4    = string[4];                {String der Lnge  4}
  _Str5    = string[5];                {String der Lnge  5}
  _Str6    = string[6];                {String der Lnge  6}
  _Str7    = string[7];                {String der Lnge  7}
  _Str8    = string[8];                {String der Lnge  8}
  _Str9    = string[9];                {String der Lnge  9}
  _Str10   = string[10];               {String der Lnge 10}
  _Str11   = string[11];               {String der Lnge 11}
  _Str12   = string[12];               {String der Lnge 12}
  _Str14   = string[14];               {String der Lnge 14}
  _Str15   = string[15];               {String der Lnge 15}
  _Str20   = string[20];               {String der Lnge 20}
  _Str25   = string[25];               {String der Lnge 25}
  _Str30   = string[30];               {String der Lnge 30}
  _Str40   = string[40];               {String der Lnge 40}
  _WorkStr = string[79];        {Globaler Arbeitsstring der}
                                                  {Lnge 79}
  _LongStr = string[127];      {Max.Lnge einer Zeile in TP}

{Ŀ
  Monitorparameter zur Auswahl der Vorder- und der Hinter-
  grundfarbe. Fr die Farben gelten die in der Standard-  
  Unit Crt vereinbarten Konstanten.                       
                                                          
  Die Monitorparameter sollten jedoch nicht hier, sondern 
  ausschlielich mit der Routine _SetMonitor  aus der Unit
  _IO verndert werden, da dort auch entsprechende Kon-   
  trollen durchgefhrt werden.                            
 }
  _MonitorPara = record
                   Vordergrund,
                   Hintergrund : byte;
                 end;
var
  _Taste : char;                {Fr beliebigen Tastendruck}
  _ok    : boolean;                {Fr Funktionsergebnisse}
  _Regs  : Registers;                   {Prozessor-Register}
  _Config: _MonitorPara;                     {Monitorfarben}
  _JN,                          {Antwort auf Frage mit J, N}
  _Ja,                            {Antwort auf Frage mit Ja}
  _Nein  : Set of char;         {Antwort auf Frage mit Nein}
  _OldVordergrund,         {Werden zur temporren Zwischen-}
  _OldHintergrund : byte;             {speicherung bentigt}

  {Verzeichnis der globalen Routinen}

  procedure _SetConfigColor;

{ͻ
  Implementation (Nicht-ffentlicher Teil)                
 ͼ}
Implementation

{ͻ
  _SetConfigColor                                         
 Ķ
  Setzt Vorder- und Hintergrundfarben, die in der Variab- 
  len _Config momentan gespeichert sind.                  
 ͼ}
procedure _SetConfigColor;
begin
  TextColor(_Config.Vordergrund);             {Farbe setzen}
  TextBackground(_Config.Hintergrund);        {Farbe setzen}
end;
{ͻ
  Initialisierungs-Teil (Ausfhrungsteil)                 
 ͼ}
begin
  _JN  := ['J','j','N','n'];             {Menge fr Antwort}
  _Ja  := ['J','j'];                     {Menge fr Antwort}
  _Nein:= ['N','n'];                     {Menge fr Antwort}
  _Config.Vordergrund:= White;               {Weie Schrift}
  _Config.Hintergrund:= Black;       {Schwarzer Hintergrund}
  _SetConfigColor;                      {FarbVoreinstellung}
  _OldVordergrund:= _Config.Vordergrund;              {Init}
  _OldHintergrund:= _Config.Hintergrund;              {Init}
  Clrscr;                               {Bildschirm lschen}
{ͻ
  End of Unit                                             
 ͼ}
end.
