Program Modem_Detector;
Uses Communic,Config,My2,Crt,Version;
Const WaitHangOn     = 5 * 18;
      PortBufferSize = $3FF;
Type Configs = record
                  irq   : byte;
                  base  : word;
                  found : byte; {0=no, 1=yes, 2=carrier}
               end;
Var f    : text;
    AT_  : string[3];
    len, i, m : byte;
    answer, tmp_str, filename : string;
    zeichen : char;
    a,b,c,d,h_h,m_m,s_s,m_s : word;
    CfgMod : Array [1..48] of Configs;
    extended, use_fossil, special, no_output, slow_modem, hard : boolean;
    time : longint;

Procedure Help;
begin
   ClrScr;
   write('MODEM DETECTOR ',ver,author,email);
   len:=80 - 15 - length(ver) - length(author) - length(email) - 5;
   for i:=1 to len do write(' ');

   TextColor(thc_color); write('[THC]'); TextColor(7); for a:=1 to 80 do write('');
   writeln;
   writeln;
   writeln('SYNOPSIS : Autodetects modems connected to the computer.');
   writeln;
   writeln('SYNTAX   : MOD-DET.EXE [-e] [-h] [-n] [-s] [-t] [-u] [-f <file>]');
   writeln;
   writeln('OPTIONS  : (wrong options are ignored)');
   writeln(' -e        Extended Modem Scan (scans unusual irqs)');
   writeln(' -h        Hard extended Modem Scan (can freeze your computer!)');
   writeln(' -n        No output to screen! (of course only useful with -f <file>)');
   writeln(' -s        Use this if you''ve got a fast modem, not a slow one.');
   writeln(' -t        After scanning enter Terminal Mode to found modems');
   writeln(' -u        Use Fossil Driver if present (freezes on unkown ports!)');
   writeln(' -f <file> Write found modems into <file>');
   writeln;
   halt(255);
end;


Procedure VarInit;
begin
   cfg.speed:=2400;
   AT_:='AT'+#13;
   CfgMod[1].irq:=4; CfgMod[1].base:=$2E8;
   CfgMod[2].irq:=3; CfgMod[2].base:=$2F8;
   CfgMod[3].irq:=4; CfgMod[3].base:=$3E8;
   CfgMod[4].irq:=3; CfgMod[4].base:=$3F8;
   CfgMod[5].irq:=3; CfgMod[5].base:=$2E8;
   CfgMod[6].irq:=3; CfgMod[6].base:=$3E8;
   CfgMod[7].irq:=4; CfgMod[7].base:=$2F8;
   CfgMod[8].irq:=4; CfgMod[8].base:=$3F8;
   CfgMod[9].irq:=5; CfgMod[9].base:=$2E8;
   CfgMod[10].irq:=5; CfgMod[10].base:=$3E8;
   CfgMod[11].irq:=5; CfgMod[11].base:=$2F8;
   CfgMod[12].irq:=5; CfgMod[12].base:=$3F8;
   CfgMod[13].irq:=6; CfgMod[13].base:=$2F8;
   CfgMod[14].irq:=6; CfgMod[14].base:=$3F8;
   CfgMod[15].irq:=6; CfgMod[15].base:=$2E8;
   CfgMod[16].irq:=6; CfgMod[16].base:=$3E8;

   CfgMod[17].irq:=7; CfgMod[17].base:=$2F8;
   CfgMod[18].irq:=7; CfgMod[18].base:=$3F8;
   CfgMod[19].irq:=7; CfgMod[19].base:=$2E8;
   CfgMod[20].irq:=7; CfgMod[20].base:=$3E8;
   CfgMod[21].irq:=8; CfgMod[21].base:=$2F8;
   CfgMod[22].irq:=8; CfgMod[22].base:=$3F8;
   CfgMod[23].irq:=8; CfgMod[23].base:=$2E8;
   CfgMod[24].irq:=8; CfgMod[24].base:=$3E8;
   CfgMod[25].irq:=9; CfgMod[25].base:=$2F8;
   CfgMod[26].irq:=9; CfgMod[26].base:=$3F8;
   CfgMod[27].irq:=9; CfgMod[27].base:=$2E8;
   CfgMod[28].irq:=9; CfgMod[28].base:=$3E8;
   CfgMod[29].irq:=10; CfgMod[29].base:=$2F8;
   CfgMod[30].irq:=10; CfgMod[30].base:=$3F8;
   CfgMod[31].irq:=10; CfgMod[31].base:=$2E8;
   CfgMod[32].irq:=10; CfgMod[32].base:=$3E8;
   CfgMod[33].irq:=11; CfgMod[33].base:=$2F8;
   CfgMod[34].irq:=11; CfgMod[34].base:=$3F8;
   CfgMod[35].irq:=11; CfgMod[35].base:=$2E8;
   CfgMod[36].irq:=11; CfgMod[36].base:=$3E8;
   CfgMod[37].irq:=12; CfgMod[37].base:=$2F8;
   CfgMod[38].irq:=12; CfgMod[38].base:=$3F8;
   CfgMod[39].irq:=12; CfgMod[39].base:=$2E8;
   CfgMod[40].irq:=12; CfgMod[40].base:=$3E8;
   CfgMod[41].irq:=13; CfgMod[41].base:=$2F8;
   CfgMod[42].irq:=13; CfgMod[42].base:=$3F8;
   CfgMod[43].irq:=13; CfgMod[43].base:=$2E8;
   CfgMod[44].irq:=13; CfgMod[44].base:=$3E8;
   CfgMod[45].irq:=14; CfgMod[45].base:=$2F8;
   CfgMod[46].irq:=14; CfgMod[46].base:=$3F8;
   CfgMod[47].irq:=14; CfgMod[47].base:=$2E8;
   CfgMod[48].irq:=14; CfgMod[48].base:=$3E8;

   c:=0;
end;

function byte2hex(numb : byte): string;
const
  hexchars : array[0..15] of char = '0123456789ABCDEF';
begin
  byte2hex[0] := #2;
  byte2hex[1] := hexchars[numb shr  4];
  byte2hex[2] := hexchars[numb and 15];
end;

function word2hex(numb : word): string;
begin
  word2hex:= byte2hex(hi(numb)) + byte2hex(lo(numb));
end;

Function PortInit(irq:byte;base:word) : byte;
Var waiting:longint; bb:byte;
begin
   PortInit:=0;
   cfg.irq:=irq;
   cfg.baseadress:=base;
   PortNum:=b-1;
   if slow_modem then waiting:=800 else waiting:=250;

   for m:=1 to 10 do Multitasker;
   bb:=InitPort;
   for m:=1 to 10 do Multitasker;
   if (((not slow_modem) AND (bb = 0)) or (slow_modem)) then
      If CD then PortInit:=2 else begin
         if slow_modem then bb:=3 else bb:=1;
         repeat
            for m:=1 to 10 do Multitasker;
            if slow_modem then Delay2(750);
            for a:=1 to 3 do begin
               Init_Elapse(time);
               repeat Multitasker until (TR) or (Elapse_MS(time)>waiting);
               SW(AT_[a]);
            end;
            ANSWER:='';
            Init_Elapse(time);
            for m:=1 to 10 do Multitasker;
            repeat
               IF RR THEN answer:=answer + SR;
            until (Pos('OK',ANSWER)>0) or (Elapse_MS(time)>1000);
            if Pos('OK',ANSWER)>0 then PortInit:=1;
            Dec(bb);
            for m:=1 to 10 do Multitasker;
         until (bb<=0) or (Pos('OK',ANSWER)>0);
      end;

   DeInstallPort;
   for m:=1 to 10 do Multitasker;
end;

Procedure TerminalPrg;
Var zeichen2:char;
begin
   if not no_output then begin
   ClrScr;
   Writeln('[Channel:',kanal2,'] [Status:',d,' (0=OK, everything else is an ERROR)] [Ready:',TR,']');
   Writeln('Press any special key to QUIT (ALT-x, F-Keys, etc.) ...'); end;
   Init_Elapse(time);
   zeichen:=#1;
   for m:=1 to 10 do Multitasker;
   repeat
     if keypressed then begin
        zeichen:=Readkey;
        if (zeichen<>#0)and(TR) then SW(zeichen);
        Init_Elapse(time);
        for m:=1 to 10 do Multitasker;
     end;
     if RR then begin zeichen2:=SR;if not no_output then write(zeichen2); end;
     Multitasker;
   until (zeichen=#0)or(Elapse(time)>=300);
   DeinstallPort;
   while keypressed do zeichen:=Readkey;
end;


Begin
  Checkbreak:=true;
  if (ParamCount>0)and(Pos('?',ParamStr(1))>0) then help;
  VarInit; hard:=false;
  Cfg.use_fossil:=FPresent;
  slow_modem:=true;
  for a:=1 to ParamCount do begin
     tmp_str:=ParamStr(a);
     UPC(tmp_Str);
     if (tmp_str[1]='/')or(tmp_Str[1]='-') then Delete(tmp_str,1,1);
     if Length(Tmp_str)>0 then case tmp_str[1] of
     'E' : extended:=true;
     'H' : hard:=true;
     'N' : no_output:=true;
     'T' : special:=true;
     'U' : use_fossil:=true;
     'S' : slow_modem:=false;
     'F' : if a<Paramcount then begin
             inc(a);
             filename:=ParamStr(a);
             Upc(filename);
           end;
     end;
  end;
  if cfg.use_fossil and use_Fossil then cfg.use_fossil:=true;
  if hard then extended:=true;
  for m:=1 to 10 do Multitasker;

  if not no_output then begin
     ClrScr;
     writeln('MODEM DETECTOR ',ver,author,email);
{
     len:=80 - 15 - length(ver) - length(author) - length(email) - 5;
     for i:=1 to len do write(' ');
     TextColor(thc_color); write('[THC]');
}
     TextColor(7); for a:=1 to 80 do write('');

     writeln('Get the help screen with :   MOD-DET.EXE ?');
     writeln;
     writeln('Identifying Options...');
     write('                   Extended Scanning : ');
     if hard then writeln ('HARD') else if extended then writeln('YES') else writeln('NO');
     write('                   Use Fossil Driver : ');
     if use_fossil then write('YES') else write('NO ');
     if FPresent then writeln(' (Fossil Driver present)') else writeln(' (Fossil Driver not present)');
     write('                   Slow Modem Detect : ');
     if slow_modem then writeln('YES') else writeln('NO');
     write('                   Terminal Connect  : ');
     if special then writeln('YES') else writeln('NO');
     write('                   Output Filename   : ');
     if filename='' then writeln('<none>') else writeln(filename);
     writeln;
     writeln('Autodetecting modems connected to COM 1 to COM 4 ...');
  end;

  if cfg.use_fossil then begin
     for b:=1 to 4 do begin
        for m:=1 to 10 do Multitasker;
        if not no_output then begin
           TextColor(9); write('      COM ',b,' - '); TextColor(7); end;
        CfgMod[b].found:=portinit(CfgMod[b].irq,CfgMod[b].base);
        if not no_output then begin
           if (CfgMod[b].found>0) then begin
              inc(c);
              TextColor(15); write('Found!'); TextColor(7);
              if cfgmod[b].found=1 then writeln(' (Ready)') else writeln(' (ONLINE)');
           end else begin
              TextColor(8); writeln('None Found'); TextColor(7);
        end; end;
     end;
     if extended then begin
        if not no_output then begin
           writeln;
           writeln('Autodetecting modems on extended ports COM 5 to COM 8');
        end;
        for b:=5 to 8 do begin
        for m:=1 to 10 do Multitasker;
        if not no_output then begin
           TextColor(9); write('      COM ',b,' - '); TextColor(7); end;
        CfgMod[b].found:=portinit(CfgMod[b].irq,CfgMod[b].base);
        if not no_output then begin
           if CfgMod[b].found>0 then begin
              inc(c);
              TextColor(15); write('Found!'); TextColor(7);
              if cfgmod[b].found=1 then writeln(' (Ready)') else writeln(' (ONLINE)');
           end else begin
              TextColor(8); writeln('None Found'); TextColor(7);
           end;
        end; end;
     end;
  end else begin
     for b:=1 to 4 do begin
          if not no_output then begin
             TextColor(9); write('      COM ',b,' - '); TextColor(7);end;
          CfgMod[b].found:=portinit(CfgMod[b].irq,CfgMod[b].base);
          if not no_output then begin
             if CfgMod[b].found>0 then begin
                inc(c); tmp_str:=Word2Hex(CfgMod[b].base); Delete(tmp_str,1,1);
                TextColor(15); write('Found!'); TextColor(7);
                if cfgmod[b].found=1 then write(' (Ready)') else write(' (ONLINE)');
                writeln('    [Irq: ',CfgMod[b].irq,'  BaseAdress: $',tmp_str,']');
             end else begin
                TextColor(8); writeln('None Found'); TextColor(7);
          end;end;
     end;
     if extended then begin
        if not no_output then begin
           writeln;
           if slow_modem then writeln('Autodetecting modems on misc. settings ... (Takes about 40 seconds)')
           else writeln('Autodetecting modems on misc. settings ... (Takes about 5 seconds)');end;
        for b:=5 to 16 do begin
           CfgMod[b].found:=portinit(CfgMod[b].irq,CfgMod[b].base);
           if not no_output then begin
              if CfgMod[b].found>0 then begin
                 inc(c); tmp_str:=Word2Hex(CfgMod[b].base); Delete(tmp_str,1,1);
                 TextColor(15); Write('   Modem found'); TextColor(7);
                 if cfgmod[b].found=1 then write(' (Ready)') else write(' (ONLINE)');
                 writeln(' at  [Irq: ',CfgMod[b].irq,'  BaseAdress: $',tmp_str,']');
           end;end;
        end;
        if hard then begin

           if not no_output then begin
              writeln;
              if slow_modem then writeln('Autodetecting modems in hard mode! ... (Takes about 2 minutes)')
              else writeln('Autodetecting modems in hard mode! ... (Takes about 15 seconds)');end;
           for b:=17 to 48 do begin
              CfgMod[b].found:=portinit(CfgMod[b].irq,CfgMod[b].base);
               if not no_output then begin
                 if CfgMod[b].found>0 then begin
                    inc(c); tmp_str:=Word2Hex(CfgMod[b].base); Delete(tmp_str,1,1);
                    TextColor(15); Write('   Modem found'); TextColor(7);
                    if cfgmod[b].found=1 then write(' (Ready)') else write(' (ONLINE)');
                    writeln(' at  [Irq: ',CfgMod[b].irq,'  BaseAdress: $',tmp_str,']');
              end;end;
           end;

        end;
     end;
  end;

  if filename<>'' then begin
     if not no_output then writeln;
     assign(f,filename);
{I-}
     rewrite(f);
{I+}
     if IOResult=0 then begin
        if not no_output then writeln('Writing outputfile : ',filename);
        if cfg.use_fossil then begin
           for b:=1 to 8 do
              if CfgMod[b].found>0 then begin
                 write(f,'COM ',b,': Modem Detected ');
                 if CfgMod[b].found=2 then writeln(f,'(ONLINE)') else writeln(f,'(Ready)');
              end;
        end else begin
           for b:=1 to 4 do
              if CfgMod[b].found>0 then begin
                 tmp_str:=Word2Hex(CfgMod[b].base); Delete(tmp_str,1,1);
                 write(f,'COM ',b,': Modem Detected ');
                 if CfgMod[b].found=2 then write(f,'(ONLINE)') else write(f,'(Ready)');
                 writeln(f,' [Irq: ',CfgMod[b].irq,'  BaseAdress: $',tmp_str,']');
              end;
           for b:=5 to 16 do
              if CfgMod[b].found>0 then begin
                 tmp_str:=Word2Hex(CfgMod[b].base); Delete(tmp_str,1,1);
                 write(f,'Misc : Modem Detected ');
                 if CfgMod[b].found=2 then write(f,'(ONLINE)') else write(f,'(Ready)');
                 writeln(f,' [Irq: ',CfgMod[b].irq,'  BaseAdress: $',tmp_str,']');
              end;
        end;
        Close(f);
     end else if not no_output then writeln('Can`t write outputfile : ',filename);
  end;
  if not no_output then begin
     writeln;
     TextColor(9); writeln(c,' Modem(s) found.'); TextColor(7); end;
  if special then begin
     cfg.speed:=9600;
     for b:=1 to 16 do if CfgMod[b].found>0 then begin
       if not no_output then begin
         ClrScr;
         write('Press any key to enter Terminal Mode to Modem ... (Q to Quit)');
         zeichen:=UpCase(Readkey);
         if zeichen='Q' then halt;
         if zeichen=#0 then zeichen:=Readkey;
       end;
         portnum:=b-1;
         cfg.irq:=CfgMod[b].irq;
         cfg.baseadress:=CfgMod[b].base;
         for m:=1 to 10 do Multitasker;
         InitPort;
         for m:=1 to 10 do Multitasker;
         TerminalPrg;
         for m:=1 to 10 do Multitasker;
         DeinstallPort;
         for m:=1 to 10 do Multitasker;
     end;
     if not no_output then Clrscr;
  end;
End.
