/*
** xip.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 08:31:03 1999 
** Last update Thu Oct 28 20:24:42 1999 
*/
#ifndef XIP_H
#define XIP_H	1

#include "mg.h"
#include "xiperr.h"

#ifdef DEBUG_MALLOC
# include "gdm.h"
# define XIP_ALLOC_ALGORITHM	gdm_alloc_algorithm
# define XIP_ALLOC_PROC		gdm_alloc
# define XIP_REALLOC_PROC	gdm_realloc
# define XIP_FREE_PROC		gdm_free
#else
# define XIP_ALLOC_ALGORITHM	alloc_algorithm_factor2
# define XIP_ALLOC_PROC		alloc_malloc
# define XIP_REALLOC_PROC	realloc_realloc
# define XIP_FREE_PROC		free_free
#endif

#define XIP_VEC_NEW(Base,StatusPtr)	vec_new((Base),\
						FALSE,\
						XIP_ALLOC_ALGORITHM,\
						XIP_ALLOC_PROC,\
						XIP_REALLOC_PROC,\
						XIP_FREE_PROC,\
						"xip_vec",\
						(StatusPtr))

#define XIP_DICT_NEW(HashBase,VecBase,StatusPtr)	dict_new((HashBase),\
								 (VecBase),\
						      dict_hash_code_public,\
							 XIP_ALLOC_ALGORITHM,\
							 XIP_ALLOC_PROC,\
							 XIP_REALLOC_PROC,\
							 XIP_FREE_PROC,\
								 "xip_dict",\
								 (StatusPtr))

#define XIP_ID_NEW(HashBase,VecBase,StatusPtr)		id_new((HashBase),\
								 (VecBase),\
							 XIP_ALLOC_ALGORITHM,\
							 XIP_ALLOC_PROC,\
							 XIP_REALLOC_PROC,\
							 XIP_FREE_PROC,\
							       "xip_id",\
								 (StatusPtr))

extern t_32			xip_verb_level;
extern t_mask_def		xip_verb_level_mask_defs[];

#ifdef DEBUG
# define VERB_XIP_MISC		(1L<<0)

# define XIP_VERB(level)	((xip_verb_level != 0L)?\
				 (level) & xip_verb_level:FALSE) 
#endif

#endif
