/*
** pktsav.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:46:01 1999 
** Last update Thu Oct 28 20:20:47 1999 
*/
#ifndef PKTSAV_H
#define PKTSAV_H	1

#include "pkt.h"

#define PKT_SAV_COOKIE	"PKT"

/* 
 * Pkt file format is:
 * PKT_SAV_COOKIE \n
 * Pattern \n
 * Length \n
 * Net length \n
 * Timestamp in timeval format (%d.%d) \n
 * Data in hexadecimal (8 couples of 2 hex digits per line)
 *
 * Example, an icmp packet starting from a ip header:
 * PKT
 * ip
 * 84
 * 84
 * 0.0
 * 4500 0054 ffff 0000 ff01 ffff ffff ffff
 * ffff ffff 0800 dd03 0159 0000 34a5 4fbe
 * 000c aa30 0809 0a0b 0c0d 0e0f 1011 1213
 * 1415 1617 1819 1a1b 1c1d 1e1f 2021 2223
 * 2425 2627 2829 2a2b 2c2d 2e2f 3031 3233
 * 3435 3637
 */

/* PROTO pktsav.c */
/* pktsav.c */
t_status pkt_save P((t_pkt *pkt, char *fname));
t_vec *pkt_load_to_vec P((char *fname, t_status *status));
t_status pkt_load P((t_pkt *pkt, char *fname, t_alloc_proc alloc_proc, t_free_proc free_proc));
#endif
