/*
** pat_rpc.c for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:41:52 1999 
** Last update Thu Oct 28 20:19:42 1999 
*/
#include <sys/types.h>
#include <sys/socket.h>
#include "pat_rpc.h"
#include "pat_data.h"
#include "pat_32.h"
#include "pat_rpc.h"
#include "pat_rpcnum.h"

t_assoc				rpcproc_assocs[] =
{
  {"null",			(VOID_PTR)0},
  {"set",			(VOID_PTR)1},
  {"unset",			(VOID_PTR)2},
  {"getport",			(VOID_PTR)3},
  {"dump",			(VOID_PTR)4},
  {"callit",			(VOID_PTR)5},
  {NULL,			NULL},
};

t_field				rpccall_fields[] = 
{
  {"rpcversion",   OFFSET(t_rpccall *,rpcversion),	&nu32_pat,	NULL},
  {"program",   OFFSET(t_rpccall *,program),	&nu32_pat,	NULL},
  {"Program",   OFFSET(t_rpccall *,program),	&rpcnum_resolved_pat,	NULL},
  {"version",   OFFSET(t_rpccall *,version),	&nu32_pat,	NULL},
  {"procedure",   OFFSET(t_rpccall *,procedure),	&nu32_pat,	NULL},
  {"Procedure",OFFSET(t_rpccall *,procedure),&nu32assoc_pat,rpcproc_assocs},
  NULL_FIELD
};

char				*rpccall_itmpl = "\n\
<table _name=rpccall[%i%] width=100%%%% bgcolor=\"%%rpccallColor%%\">\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"set(rpccall[%i%].rpcversion)\">%%rpccall[%i%].rpcversion%%</a>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"set(rpccall[%i%].Program)\">%%rpccall[%i%].Program%%</a>\n\
(<a href=\"set(rpccall[%i%].program)\">%%rpccall[%i%].program%%</a>)\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"set(rpccall[%i%].version)\">%%rpccall[%i%].version%%</a>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"set(rpccall[%i%].Procedure)\">%%rpccall[%i%].Procedure%%</a>\n\
(<a href=\"set(rpccall[%i%].procedure)\">%%rpccall[%i%].procedure%%</a>)\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

int	rpccall_chan;

PAT_NAME_GENERIC(rpccall_pat_name,
		 (VOID_PTR)&rpccall_chan,
		 "rpccall")

PAT_GET_FIELD_GENERIC(rpccall_pat_get_field,
		      rpccall_fields)

PAT_SET_FIELD_GENERIC(rpccall_pat_set_field,
		      rpccall_fields)

PAT_GET_FIELDS_GENERIC(rpccall_pat_get_fields,
		       rpccall_fields)

PAT_GET_FIELD_PAT_GENERIC(rpccall_pat_get_field_pat,
			  rpccall_fields)

PAT_GET_TMPL_GENERIC(rpccall_pat_get_tmpl,
		     (VOID_PTR)&rpccall_chan,
		     rpccall_itmpl)

PAT_OFF_GENERIC(rpccall_pat_off,
		RPCCALL_HLEN)


PAT_SUB_GENERIC(rpccall_pat_sub,
		&data_pat)

t_pat				rpccall_pat = 
{
  rpccall_pat_name,		/* t_pat_name_proc		*/
  rpccall_pat_off,		/* t_pat_off_proc		*/
  rpccall_pat_sub,		/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  rpccall_pat_get_field,	/* t_pat_get_field_proc		*/
  rpccall_pat_set_field,	/* t_pat_set_field_proc		*/
  rpccall_pat_get_fields,	/* t_pat_get_fields_proc	*/
  rpccall_pat_get_tmpl,		/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  rpccall_pat_get_field_pat,	/* t_pat_get_field_pat_proc	*/
  NULL,				/* t_pat_extract_proc		*/
  NULL,				/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};


t_assoc				rpcdirection_assocs[] =
{
  {"call",			(VOID_PTR)RPCDIRECTION_CALL},
  {"reply",			(VOID_PTR)RPCDIRECTION_REPLY},
  {NULL,			NULL},
};

t_field				rpc_fields[] = 
{
  {"xid",	OFFSET(t_rpc *,xid),	&nu32_pat,	NULL},
  {"direction",OFFSET(t_rpc *,direction),&nu32_pat,	NULL},
  {"Direction",OFFSET(t_rpc *,direction),&nu32assoc_pat,
   rpcdirection_assocs},
  NULL_FIELD
};

char				*rpc_itmpl = "\n\
<table _name=rpc[%i%] width=100%%%% bgcolor=\"%%rpcColor%%\">\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"set(rpc[%i%].xid)\">%%rpc[%i%].xid%%</a>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"set(rpc[%i%].Direction)\">%%rpc[%i%].Direction%%</a>\n\
(<a href=\"set(rpc[%i%].direction)\">%%rpc[%i%].direction%%</a>)\n\
</td>\n\
</tr>\n\
</table>\n\
<br>\n\
";

int	rpc_chan;

PAT_NAME_GENERIC(rpc_pat_name,
		 (VOID_PTR)&rpc_chan,
		 "rpc")

PAT_GET_FIELD_GENERIC(rpc_pat_get_field,
		      rpc_fields)

PAT_SET_FIELD_GENERIC(rpc_pat_set_field,
		      rpc_fields)

PAT_GET_FIELDS_GENERIC(rpc_pat_get_fields,
		       rpc_fields)

PAT_GET_FIELD_PAT_GENERIC(rpc_pat_get_field_pat,
			  rpc_fields)

PAT_GET_TMPL_GENERIC(rpc_pat_get_tmpl,
		     (VOID_PTR)&rpc_chan,
		     rpc_itmpl)

PAT_OFF_GENERIC(rpc_pat_off,
		RPC_HLEN)
    
PAT_SUB_DECL(rpc_pat_sub)
{
  t_rpc				*rpc;
  t_u32				direction;

  PAT_RPC_CHECK(rpc,buf,len);
  direction = safe_ntohl(&(rpc->direction));
  switch (direction)
    {
    case RPCDIRECTION_CALL:
      (*pat_return) = &rpccall_pat;
      return (0);
    }
  (*pat_return) = &data_pat;
  return (0);
}

t_pat				rpc_pat = 
{
  rpc_pat_name,			/* t_pat_name_proc		*/
  rpc_pat_off,			/* t_pat_off_proc		*/
  rpc_pat_sub,			/* t_pat_sub_proc		*/
  NULL,				/* t_pat_sum_proc		*/
  rpc_pat_get_field,		/* t_pat_get_field_proc		*/
  rpc_pat_set_field,		/* t_pat_set_field_proc		*/
  rpc_pat_get_fields,		/* t_pat_get_fields_proc	*/
  rpc_pat_get_tmpl,		/* t_pat_get_tmpl_proc		*/
  NULL,				/* t_pat_get_tmpl2_proc		*/
  NULL,				/* t_pat_has_opt_proc		*/
  NULL,				/* t_pat_adapt_len_proc		*/
  rpc_pat_get_field_pat,	/* t_pat_get_field_pat_proc	*/
  NULL,				/* t_pat_extract_proc		*/
  NULL,				/* t_pat_insert_proc		*/
  NULL,				/* t_pat_get_choices_proc	*/
};
