/*
** pat_rip.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:47:58 1999 
** Last update Thu Oct 28 20:21:07 1999 
*/
#ifndef PAT_RIP_H
#define PAT_RIP_H	1

#include "pat.h"

typedef struct		s_ripinfo
{
  t_u16			family;
  t_u16			tag;
  t_32			dst;
  t_32			mask;
  t_32			router;
  t_32			metric;
} t_ripinfo;

#define RIPINFO_HLEN	20

#define PAT_RIPINFO_CHECK(ripinfopar,bufpar,lenpar) \
	if ((lenpar) < RIPINFO_HLEN)\
		return (ERR_PAT_TRUNC_PAT);\
	(ripinfopar) = (t_ripinfo *)(bufpar);

extern t_assoc		family_assocs[];

typedef struct		s_rip
{
  t_u8			cmd;
  t_u8			v;
  t_u16			mbz;
} t_rip;

#define RIP_HLEN	4

#define RIP_PORT	520

#define PAT_RIP_CHECK(rippar,bufpar,lenpar) \
	if ((lenpar) < RIP_HLEN)\
		return (ERR_PAT_TRUNC);\
	(rippar) = (t_rip *)(bufpar);

extern t_assoc		ripcmd_assocs[];

extern t_pat		ripinfo_pat;
extern t_pat		rip_pat;

/* PROTO pat_rip.c */
/* pat_rip.c */
t_status ripinfo_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status ripinfo_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status ripinfo_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status ripinfo_pat_get_fields P((void *data, t_vec *vec_str));
t_status ripinfo_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status ripinfo_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status ripinfo_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status ripinfo_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status rip_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status rip_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status rip_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status rip_pat_get_fields P((void *data, t_vec *vec_str));
t_status rip_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status rip_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status rip_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status rip_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
#endif
