/*
** mg_assoc.c for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 12:16:53 1999 vianney rancurel
** Last update Thu Oct 28 20:16:30 1999 
*/
#include "mg_assoc.h"

/* finds the first str matching assoc.
   It walks the assoc array until a NULL left member is found.
   Returns the assoc record or NULL */
t_assoc		*assoc_str_ptr_from_left(assoc,left)
t_assoc		*assoc;		       
char		*left;			/* The string to found	*/
{
  while (assoc->left)
    {
      if (!strcmp(assoc->left,left))
	return (assoc);
      assoc++;
    }
  return (NULL);
}

/* finds the first prefix matching assoc.
   It walks the assoc array until a NULL left member is found. 
   Assoc->left is assumed to be a prefix of left. 
   Returns the assoc record or NULL */
t_assoc		*assoc_str_ptr_from_nleft(assoc,left)
t_assoc		*assoc;
char		*left;
{
  while (assoc->left)
    {
      if (!strncmp(assoc->left,left,strlen(assoc->left)))
	return (assoc);
      assoc++;
    }
  return (NULL);
}

/* see assoc_str_ptr_from_left(3).
   Returns def instead of NULL if nothing matches */
VOID_PTR	assoc_str_ptr_from_left_default(assoc,left,def)
t_assoc		*assoc;
char		*left;
VOID_PTR	def;			/* Default value returned	*/
{
  t_assoc	*a;

  if (a = assoc_str_ptr_from_left(assoc,left))
    return (a->right);
  else
    return (def);
}

/* Find the first assoc matching the right member as an int.
   Returns the assoc record or NULL */
t_assoc		*assoc_str_int_from_right(assoc,right)
t_assoc		*assoc;
int		right;
{
  while (assoc->left)
    {
      if ((int)(assoc->right) == right)
	return (assoc);
      assoc++;
    }
  return (NULL);
}
