/*
** Xws.c for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 14:14:00 1999 vianney rancurel
** Last update Thu Oct 28 20:22:15 1999 
*/
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include "Xws.h"

#define NS_VERSION      "_MOZILLA_VERSION"
#define NS_COMMAND      "_MOZILLA_COMMAND"
#define NETSCAPE        "Netscape"

/* looks for a netscape window.
   This procedure is used by XwsFindNetscapeWindow(3).
   It checks for the window class or the name provided. It also try to
   find if the window has NS_VERSION property. 
   Returns the window or None */
Window		XwsNetscapeWindowCompareFunc(display,window,name)
Display		*display;
Window		window;		/* Window to check */
char		*name;		/* Name of window */
{
  Atom		type;
  int		format;
  int		status;
  unsigned long nitems;
  unsigned long	bytesafter;
  unsigned char **version;
  Window	found;
  XClassHint	*classhint;
  
  version = NULL;
  found = None;
  if (!name)
    {
      if ((XGetWindowProperty(display,
                              window,
                              XInternAtom(display,
					  NS_VERSION,
					  False),
                              0L,
                              (long)BUFSIZ,
                              False,
                              XA_STRING,
                              &type,
                              &format,
                              &nitems,
                              &bytesafter,
                              (unsigned char **)&version)) == Success)
	{
	  if (version && type != None)
	    {
	      found = window;
	      XFree((char *)version);
	    }
	}
    }
  else
    {
      classhint = XAllocClassHint();
      if ((XGetClassHint(display, window, classhint)))
	{
	  if (!strcmp(classhint->res_class, NETSCAPE) &&
	      !strcmp(classhint->res_name, name)) 
	    found = window;
	}
      XFree((char *)classhint);
    }
  return (found);
}

/* find a netscape window.
   It starts from starting_window.
   It uses by example XwsNetscapeWindow(3) as compare_func.
   Returns the Window or None. */
Window		XwsFindNetscapeWindow(display,
				      starting_window,
				      name,
				      compare_func)
Display		*display;
Window		starting_window;
char		*name;
CompareFunc	compare_func;
{
   Window	rootwindow;
   Window	window_parent;
   int		i;
   unsigned int num_children;
   Window	*children;
   Window	window;	

   num_children = 0;
   children = NULL;
   window = compare_func(display,starting_window,name);
   if (window != (Window)None) 
     return (window);
   if ((XQueryTree(display,
                   starting_window,
                   &rootwindow,
                   &window_parent,
                   &children,
                   &num_children)) == 0)
     return ((Window)None);
   i = 0;
   while (( i < num_children ) && ( window == (Window)None ))
     window = 
       XwsFindNetscapeWindow(display,
			     children[i++],
			     name,
			     compare_func);
   if (children) 
     XFree((char *)children);
   return(window);
}

/* sends a command to a netscape window. */
VOID_FUNC	XwsSendNavigatorCommand(display,window,command)
Display		*display;
Window		window;
char		*command;	/* E.g "OpenURL()" */
{
  XChangeProperty(display,
		  window,
		  XInternAtom(display, NS_COMMAND, False),
		  XA_STRING,
		  8,
		  PropModeReplace,
		  (unsigned char *)command,
		  strlen(command)+1);
  XFlush(display);
}  
