#ifndef __SPAC_FUNC_CONF_H
#define __SPAC_FUNC_CONF_H

/* File   : spak_func_config.h                                              */
/* Purpose: User configurable options for the spak_func.c functions.        */

/* The size of the input buffer.  Usually, this can be left alone, but it    */
/* can be tweaked for your I/O.  This is not a maximum value for the input;  */
/* it just defines how large a chunk is requested for reading.  Also, input  */
/* buffers are allocated in chunks of INBUF size.  To save (a small amount   */
/* of) memory, this value can be lowered.  If input is continuously larger   */
/* than INBUF, then time will be spent reallocating memory to hold all the   */
/* input.  If INBUF is set below 2, a default value will be used.            */
#define INBUF 512

#endif  /* __SPAC_FUNC_CONF_H */
