#ifndef __SPAK_FUNC_H
#define __SPAK_FUNC_H

/* File   : spak_func.h                                                     */
/* Purpose: Definitions and include files used by spak_func.c.              */

#ifdef SunOS
#include <sys/types.h>   /* u_short         */
#include <sys/socket.h>  /* struct sockaddr */
#endif  /* SunOS */

#ifdef BSDI31
#include <sys/types.h>   /* u_short         */
#include <sys/socket.h>  /* struct sockaddr */
#endif  /* BSDI31 */

#include <net/if.h>      /* struct ifreq */

#define IP  1
#define MAC 2

/* Function prototypes */
char *append_data(char *, int *, char *);
char *read_data(char *, int *);
char *get_options(char *, int *);
int get_default(struct ifreq *, int);
int my_atoi(char *, int, char *);
unsigned long getaddrbyname(char *);
void write_packet(char *, void *, unsigned int);

#endif  /* __SPAK_FUNC_H */
