/* File   : makeudp_func.c
 * Author : Karyl F. Stein <xenon@xenos.net>
 * Purpose: Functions for use by the makeudp program.  The individual
 *          functions are detailed before the function below.
 *
 * Spak is Copyright (C)1996 Karyl F. Stein <xenon@xenos.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "makeudp_sysconf.h"  /* System settings  */
#include "makeudp_conf.h"     /* Default settings */
#include <stdio.h>

#ifdef SunOS
#include <netinet/in.h>       /* sockaddr_in */
#include <arpa/nameser.h>     /* MAXDNAME    */
#include <netinet/in_systm.h> /* n_long      */
#include <resolv.h>           /* in_addr     */
#endif  /* SunOS */

#include "makeudp_func.h"     /* Function prototypes  */


/* Function: new_udp_packet
 * Return  : A new UDP packet header with default values set.
 */
struct full_udphdr *new_udp_packet (void) {
  struct full_udphdr *retval;

  /* Allocate the structure to hold the packet */
  if ((retval =
       (struct full_udphdr *) malloc(sizeof(struct full_udphdr))) == NULL) {
    fprintf(stderr, "Out of Memory\n");
    exit(1);
  }

  /* Set the packet data to the defaults */
  retval->source = 0;
  retval->destination = 0;
  retval->zero = 0;
  retval->protocol = UDP_DEFAULT_PROTOCOL;
  retval->length = UDP_DEFAULT_HEADER_SIZE;
  retval->packet.UDP_FIELD_SRC = 0;
  retval->packet.UDP_FIELD_DEST = 0;
  retval->packet.UDP_FIELD_LEN = UDP_DEFAULT_HEADER_SIZE / 4;
  retval->packet.UDP_FIELD_CSUM = 0;

  return(retval);
}
