/* File   : maketcp_func.c
 * Author : Karyl F. Stein <xenon@xenos.net>
 * Purpose: Functions for use by the maketcp program.  The individual
 *          functions are detailed before the function below.
 *
 * Spak is Copyright (C)1996 Karyl F. Stein <xenon@xenos.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include <stdio.h>

#ifdef SunOS
#include <netinet/in.h>       /* sockaddr_in */
#include <arpa/nameser.h>     /* MAXDNAME    */
#include <resolv.h>           /* in_addr     */
#include <netinet/in_systm.h> /* n_long      */
#endif  /* SunOS */

#include <stdlib.h>           /* random()             */
#include "maketcp_func.h"     /* Function prototypes  */
#include "maketcp_conf.h"     /* Default settings     */


/* Function: new_tcp_packet
 * Return  : A new TCP packet header with default values set.
 */
struct full_tcphdr *new_tcp_packet (void) {
  struct full_tcphdr *retval;

  /* Allocate the structure to hold the packet */
  if ((retval =
       (struct full_tcphdr *) malloc(sizeof(struct full_tcphdr))) == NULL) {
    fprintf(stderr, "Out of Memory\n");
    exit(1);
  }

  /* Set the packet data to the defaults */
  retval->source = 0;
  retval->destination = 0;
  retval->zero = 0;
  retval->protocol = TCP_DEFAULT_PROTOCOL;
  retval->length = TCP_DEFAULT_HEADER_SIZE;
  retval->packet.th_sport = 0;
  retval->packet.th_dport = 0;
  retval->packet.th_seq = random();
  retval->packet.th_ack = 0;
  retval->packet.th_x2 = 0;
  retval->packet.th_off = TCP_DEFAULT_HEADER_SIZE / 4;
  retval->packet.th_flags = 0;
  retval->packet.th_win = TCP_DEFAULT_WINDOW_SIZE;
  retval->packet.th_sum = 0;
  retval->packet.th_urp = 0;

  return(retval);
}
