#ifndef __MAKEETH_CONF_H
#define __MAKEETH_CONF_H

/* File   : makeeth_config.h                                                */
/* Purpose: User configurable options for the makeeth program.              */

/* Default destination MAC address.  This should be a string in the form    */
/* a:b:c:d:e:f where a through f are two digit hexadecimal numbers.         */
#define DEF_DST_MAC "00:00:0d:05:c5:bc"

/* Default source MAC address.  This should be a string in the form         */
/* a:b:c:d:e:f where a through f are two digit hexadecimal numbers.  If     */
/* this is not defined, the default source MAC is guessed by the program.   */
/* To undefine this, add a /* before the #define.                           */
#define DEF_SRC_MAC "00:00:ac:26:a8:b7"  /* */

/* Default type of the frame data.  For example, IP is 0x0800 or 2048.  ARP */
/* is 0x0806.                                                               */
#define DEF_ETH_TYPE 0x0800

#endif  /* __MAKEETH_CONF_H */
