/* File   : makearp_func.c
 * Author : Karyl F. Stein <xenon@xenos.net>
 * Purpose: Functions for use by the makearp program.  The individual
 *          functions are detailed before the function below.
 *
 * Spak is Copyright (C)1996 Karyl F. Stein <xenon@xenos.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include <stdio.h>
#include "makearp_func.h"

/* Set defaults if not defined previously or not valid.  Change these */
/* values in makearp_conf.h and not here.                             */
#ifndef DEF_HW_TYPE
#define DEF_HW_TYPE 1
#endif  /* DEF_HW_TYPE */
#ifndef DEF_PROTOCOL_TYPE
#define DEF_PROTOCOL_TYPE 0x0800
#endif  /* DEF_PROTOCOL_TYPE */
#ifndef DEF_OPERATION
#define DEF_OPERATION 1
#endif  /* DEF_OPERATION */


/* Function: new_arp_packet
 * Return  : A new ARP packet header with default values set.  Lengths of the
 *           hardware and protocol addresses are set in set_arp_defaults().
 */
struct arphdr *new_arp_packet (void) {
  struct arphdr *retval;

  /* Allocate the structure to hold the packet */
  if ((retval = (struct arphdr *) malloc(sizeof(struct arphdr))) == NULL) {
    fprintf(stderr, "Out Of Memory\n");
    exit(1);
  }

  /* Set the packet data to the defaults */
  retval->ar_op = DEF_OPERATION;
  retval->ar_hrd = DEF_HW_TYPE;
  retval->ar_pro = DEF_PROTOCOL_TYPE;
  retval->ar_hln = 0;
  retval->ar_pln = 0;

  return(retval);
}


/* Function: set_arp_defaults
 * Input   : An arp packet header.
 * Output  : The packet is resized to hold the hardware and IP addresses.
 *
 * TODO: Get rid of static sizing (rely on system header files).
 *       Add more types.
 */
int get_resize_len (void *packet) {
  int size = 0;

  switch (((struct arphdr *) packet)->ar_hrd) {
  case 1:  /* ARPHRD_ETHER (Ethernet 10Mbps) */
    size += 6 * 2;
    break;
  }

  switch (((struct arphdr *) packet)->ar_pro) {
  case 0x800:  /* IP */
    size += 4 * 2;
    break;
  }

  return(size);
}
