#ifndef __MAKEARP_CONF_H
#define __MAKEARP_CONF_H

/* File   : makearp_config.h                                                */
/* Purpose: User configurable options for the makearp program.              */
/* Notes  : ALL of the following options are settable by command line       */
/*          arguments to makearp.  The command line arguments WILL over-    */
/*          write the following settings.  The default declarations are     */
/*          given here so that a customized makearp can easily be built for */
/*          a specific system if desired.  In other words, you really do    */
/*          not have to mess with these at all, but if you know what you    */
/*          doing, setting the following may allow quick manual generation  */
/*          of packets for a specific system.                               */

/* Define the default operation.  The following are standard:               */
/* 1 = ARP Request    2 = ARP Reply    3 = RARP Request    4 = RARP Reply   */
#define DEF_OPERATION 1

/* Define the default hardware type.  Currently, only type 1 (Ethernet      */
/* 10Mbps) is internally supported by makearp.                              */
#define DEF_HW_TYPE 1

/* Define the default protocol type.  Currently, only 0x0800 (IP) is        */
/* internally supported by makearp.                                         */
#define DEF_PROTOCOL_TYPE 0x0800

/* Default destination MAC address, (for hardware type 1).  This should be  */
/* a string in the form a:b:c:d:e:f where a through f are two digit         */
/* hexadecimal numbers.                                                     */
#define DEF_DST_MAC "00:00:0d:05:c5:bc"

/* Default source MAC address, (for hardware type 1).  This should be a     */
/* string in the form a:b:c:d:e:f where a through f are two digit           */
/* hexadecimal numbers.  If this is not defined, then a valid MAC address   */
/* is attempted to be guessed.  To undefine this, add a /* before the       */
/* #define statement.                                                       */
#define DEF_SRC_MAC "00:00:ac:26:a8:b7"  /* */

#endif  /* __MAKEARP_CONF_H */
