#ifndef __ETHERNET_H
#define __ETHERNET_H

/* File   : ethernet.h                                                      */
/* Purpose: Definitions and includes for programs that deal with ethernet   */
/*          frames.                                                         */

#include "config.h"

#ifdef LINUX
#include <linux/if_ether.h>
#endif  /* LINUX */

#ifdef BSDI31
#include <sys/types.h>        /* u_char        */
#include <sys/socket.h>       /* struct inaddr */
#include <net/if.h>           /* struct ifnet  */
#include <netinet/in.h>       /* sockaddr_in */
#include <arpa/nameser.h>     /* MAXDNAME    */
#include <resolv.h>           /* in_addr     */
#include <netinet/in_systm.h> /* n_long      */
#include <netinet/if_ether.h>
#endif  /* BSDI31 */

#ifdef SunOS
#include <sys/types.h>        /* u_char        */
#include <sys/socket.h>       /* struct inaddr */
#include <net/if.h>           /* struct ifnet  */
#include <netinet/in.h>       /* sockaddr_in */
#include <arpa/nameser.h>     /* MAXDNAME    */
#include <resolv.h>           /* in_addr     */
#include <netinet/in_systm.h> /* n_long      */
#include <netinet/if_ether.h>
#endif  /* SunOS */


/* Data Types */
#ifdef LINUX
typedef struct ethhdr my_ethhdr;
#endif  /* LINUX */
#ifdef BSDI31
typedef struct ether_header my_ethhdr;
#endif  /* BSDI31 */
#ifdef SunOS
typedef struct ether_header my_ethhdr;
#endif  /* SunOS */


/* Field Names */
#ifdef LINUX
#define ETH_FIELD_DEST h_dest
#define ETH_FIELD_TYPE h_proto
#define ETH_FIELD_SRC h_source
#define IFR_FIELD_ETH ifr_hwaddr
#endif  /* LINUX */

#ifdef BSDI31
#define ETH_FIELD_DEST ether_dhost
#define ETH_FIELD_TYPE ether_type
#define ETH_FIELD_SRC ether_shost
#define IFR_FIELD_ETH ifr_enaddr
#define ETH_HLEN 14
#endif  /* BSDI31 */

#ifdef SunOS
#define ETH_FIELD_DEST ether_dhost
#define ETH_FIELD_TYPE ether_type
#define ETH_FIELD_SRC ether_shost
#define IFR_FIELD_ETH ifr_enaddr
#define ETH_HLEN 14
#endif  /* SunOS */

#endif  /* __ETHERNET_H */
