/*
** patdef.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:46:24 1999 
** Last update Thu Oct 28 20:20:50 1999 
*/
#ifndef PATDEF_H
#define PATDEF_H	1

#include "mg.h"

struct s_pat;

typedef struct		s_field
{
  char			*name;
  off_t			offset;
  struct s_pat		*pat;
  VOID_PTR		data;
} t_field;

#define NULL_FIELD	{NULL,0,NULL,NULL}

typedef struct		s_bit_field_assocs_data
{
  t_bit_field		*bit_field;
  t_assoc		*assocs;
} t_bit_field_assocs_data;

typedef t_status	(*t_pat_name_proc) P((VOID_PTR data,
					      t_id *optional_id,
					      char *str,
					      int max_len));

#define PAT_NAME_GENERIC(Proc,Chan,Name) \
t_status		Proc(data,optional_id,str,max_len)\
VOID_PTR		data;\
t_id			*optional_id;\
char			*str;\
int			max_len;\
{\
  return (pat_name_generic(optional_id,\
			   str,\
			   max_len,\
			   (Chan),\
			   (Name)));\
}

typedef t_status	(*t_pat_off_proc) P((VOID_PTR data,
					     char *buf,
					     int len,
					     t_off *off_return));

#define PAT_OFF_GENERIC(Proc,Off) \
t_status			Proc(data,buf,len,off_return)\
VOID_PTR			data;\
char				*buf;\
int				len;\
t_off				*off_return;\
{\
  (*off_return) = (Off);\
  return (0);\
}

#define PAT_OFF_DECL(Proc) \
t_status			Proc(data,buf,len,off_return)\
VOID_PTR			data;\
char				*buf;\
int				len;\
t_off				*off_return;

typedef t_status	(*t_pat_sub_proc) P((VOID_PTR data,
					     t_id *optional_id,
					     char *buf,
					     int len,
					     struct s_pat **pat_return));

#define PAT_SUB_GENERIC(Proc,SubPat) \
t_status			Proc(data,optional_id,buf,len,pat_return)\
t_id				*optional_id;\
VOID_PTR			data;\
char				*buf;\
int				len;\
t_pat				**pat_return;\
{\
   (*pat_return) = (SubPat);\
   return (0);\
}

#define PAT_SUB_DECL(Proc) \
t_status			Proc(data,optional_id,buf,len,pat_return)\
VOID_PTR			data;\
t_id				*optional_id;\
char				*buf;\
int				len;\
t_pat				**pat_return;

typedef t_status	(*t_pat_sum_proc) P((VOID_PTR data,
					     char *buf,
					     int len,
					     char *up_buf,
					     int up_len));

#define PAT_SUM_DECL(Proc) \
t_status			Proc(data,buf,len,up_buf,up_len)\
VOID_PTR			data;\
char				*buf;\
int				len;\
char				*up_buf;\
int				up_len;

typedef t_status	(*t_pat_get_field_proc) P((VOID_PTR data,
						   t_id *optional_id,
						   char *buf,
						   int len,
						   char *field,
						   char *str,
						   int max_len));

#define PAT_GET_FIELD_GENERIC(Proc,Fields) \
t_status		Proc(data,optional_id,buf,len,field,str,max_len)\
VOID_PTR		data;\
t_id			*optional_id;\
char			*buf;\
int			len;\
char			*field;\
char			*str;\
int			max_len;\
{\
   return (pat_get_field_generic(optional_id,\
				 buf,\
				 len,\
				 field,\
				 str,\
				 max_len,\
				 (Fields)));\
}

#define PAT_GET_FIELD_DECL(Proc) \
t_status		Proc(data,optional_id,buf,len,field,str,max_len)\
VOID_PTR		data;\
t_id			*optional_id;\
char			*buf;\
int			len;\
char			*field;\
char			*str;\
int			max_len;

typedef t_status	(*t_pat_set_field_proc) P((VOID_PTR data,
						   t_id *optional_id,
						   char *buf,
						   int len,
						   char *field,
						   char *value));

#define PAT_SET_FIELD_GENERIC(Proc,Fields) \
t_status		Proc(data,optional_id,buf,len,field,value)\
VOID_PTR		data;\
t_id			*optional_id;\
char			*buf;\
int			len;\
char			*field;\
char			*value;\
{\
   return (pat_set_field_generic(optional_id,\
				 buf,\
				 len,\
				 field,\
				 value,\
				 (Fields)));\
}

#define PAT_SET_FIELD_DECL(Proc) \
t_status		Proc(data,optional_id,buf,len,field,value)\
VOID_PTR		data;\
t_id			*optional_id;\
char			*buf;\
int			len;\
char			*field;\
char			*value;\

typedef t_status	(*t_pat_get_fields_proc) P((VOID_PTR data,
						    t_vec *vec_str));

#define PAT_GET_FIELDS_GENERIC(Proc,Fields) \
t_status			Proc(data,vec_str)\
VOID_PTR			data;\
t_vec				*vec_str;\
{\
   return (pat_get_fields_generic(vec_str,\
				  Fields));\
}

#define PAT_GET_FIELDS_DECL(Proc) \
t_status			Proc(data,vec_str)\
VOID_PTR			data;\
t_vec				*vec_str;

typedef t_status	(*t_pat_get_tmpl_proc) P((VOID_PTR data,
						  t_id *id,
						  char *buf,
						  int len,
						  char *str,
						  int max_len));

#define PAT_GET_TMPL_GENERIC(Proc,Chan,ITmpl) \
t_status		Proc(data,id,buf,len,str,max_len)\
VOID_PTR		data;\
t_id			*id;\
char			*buf;\
int			len;\
char			*str;\
int			max_len;\
{\
   return (pat_get_itmpl_generic(id,\
				 buf,\
				 len,\
				 str,\
				 max_len,\
				 (Chan),\
				 (ITmpl)));\
}

#define PAT_GET_TMPL_DECL(Proc) \
t_status		Proc(data,id,buf,len,str,max_len)\
VOID_PTR		data;\
t_id			*id;\
char			*buf;\
int			len;\
char			*str;\
int			max_len;\

typedef t_status	(*t_pat_get_tmpl2_proc) P((VOID_PTR data,
						   t_id *id,
						   char *buf,
						   int len,
						   char *str,
						   int max_len));


#define PAT_GET_TMPL2_GENERIC(Proc,Chan,ITmpl2) \
t_status		Proc(data,id,buf,len,str,max_len)\
VOID_PTR		data;\
t_id			*id;\
char			*buf;\
int			len;\
char			*str;\
int			max_len;\
{\
   return (pat_get_itmpl2_generic(id,\
				  buf,\
				  len,\
				  str,\
				  max_len,\
				  (Chan),\
				  (ITmpl2)));\
}

#define PAT_GET_TMPL2_DECL(Proc) \
t_status		Proc(data,id,buf,len,str,max_len)\
VOID_PTR		data;\
t_id			*id;\
char			*buf;\
int			len;\
char			*str;\
int			max_len;\

typedef t_status  (*t_pat_has_opt_proc) P((VOID_PTR data,
					   char *buf,
					   int len,
					   t_boolean *has_opt_return,
					   t_off *opt_off_return,
					   int *opt_len_return,
					   struct s_pat **opt_pat_return,
					   VOID_PTR *opt_data_return));

#define PAT_HAS_OPT_DECL(Proc) \
t_status		Proc(data,\
			     buf,\
			     len,\
			     has_opt_return,\
			     opt_off_return,\
			     opt_len_return,\
			     opt_pat_return,\
			     opt_data_return)\
VOID_PTR		data;\
char			*buf;\
int			len;\
t_boolean		*has_opt_return;\
t_off			*opt_off_return;\
int			*opt_len_return;\
t_pat			**opt_pat_return;\
VOID_PTR		*opt_data_return;

typedef t_status	(*t_pat_adapt_len_proc) P((VOID_PTR data,
						   char *buf,
						   int len));
					
#define PAT_ADAPT_LEN_DECL(Proc) \
t_status			Proc(data,buf,len)\
VOID_PTR			data;\
char				*buf;\
int				len;
    
typedef t_status   (*t_pat_get_field_pat_proc) P((VOID_PTR data,
						  t_id *optional_id,
						  char *buf,
						  int len,
						  char *field,
						  struct s_pat **pat_return,
						  VOID_PTR *data_return));

#define PAT_GET_FIELD_PAT_GENERIC(Proc,Fields) \
t_status	Proc(data,optional_id,buf,len,field,pat_return,data_return)\
VOID_PTR	data;\
t_id		*optional_id;\
char		*buf;\
int		len;\
char		*field;\
t_pat		**pat_return;\
VOID_PTR	*data_return;\
{\
   return (pat_get_field_pat_generic(field,\
				     pat_return,\
				     data_return,\
				     (Fields)));\
}

#define PAT_GET_FIELD_PAT_DECL(Proc) \
t_status	Proc(data,optional_id,buf,len,field,pat_return,data_return)\
VOID_PTR	data;\
t_id		*optional_id;\
char		*buf;\
int		len;\
char		*field;\
t_pat		**pat_return;\
VOID_PTR	*data_return;

typedef t_status	(*t_pat_extract_proc) P((VOID_PTR data,
						 char *buf,
						 int len,
						 char *str,
						 int max_len));

#define PAT_EXTRACT_DECL(Proc) \
t_status		Proc(data,buf,len,str,max_len)\
VOID_PTR		data;\
char			*buf;\
int			len;\
char			*str;\
int			max_len;

typedef t_status	(*t_pat_insert_proc) P((VOID_PTR data,
						char *buf,
						int len,
						char *value));

#define PAT_INSERT_DECL(Proc) \
t_status		Proc(data,buf,len,value)\
VOID_PTR		data;\
char			*buf;\
int			len;\
char			*value;

typedef t_status	(*t_pat_get_choices_proc) P((VOID_PTR data,
						     char *buf,
						     int len,
						     t_vec *vec_str,
						   t_boolean *do_sort_return));

#define PAT_GET_CHOICES_DECL(Proc) \
t_status		Proc(data,buf,len,vec_str,do_sort_return)\
VOID_PTR		data;\
char			*buf;\
int			len;\
t_vec			*vec_str;\
t_boolean		*do_sort_return;

typedef struct			s_pat
{
  t_pat_name_proc		name_proc;	/* Name yourself */
  t_pat_off_proc		off_proc;	/* Get offset to sub-pattern */
  t_pat_sub_proc		sub_proc;	/* Get sub-pattern */
  t_pat_sum_proc		sum_proc;	/* Checksum yourself */
  t_pat_get_field_proc		get_field_proc;	/* Get field */
  t_pat_set_field_proc		set_field_proc;	/* Set field */
  t_pat_get_fields_proc		get_fields_proc;/* Get possible fields */
  t_pat_get_tmpl_proc		get_tmpl_proc;	/* Get HTML template */
  t_pat_get_tmpl2_proc		get_tmpl2_proc;	/* Unused for now */
  t_pat_has_opt_proc		has_opt_proc;	/* Have you got options ? */
  t_pat_adapt_len_proc		adapt_len_proc;	/* Adapt length fields */
  t_pat_get_field_pat_proc	get_field_pat_proc;/* Get more about field */
  t_pat_extract_proc		extract_proc;	/* Extract yourself */
  t_pat_insert_proc		insert_proc;	/* Insert yourself */
  t_pat_get_choices_proc	get_choices_proc;/* Get possible choices */
} t_pat;

/* PROTO patdef.c */
/* patdef.c */
t_status itmpl_format_do P((t_bridled_str *bs, char *var, int i));
t_status itmpl_format P((int i, char *itmpl_str, char *str, int max_len));
t_status get_field_to_str P((char *buf, int len, t_field *field, char *str, int max_len));
t_status set_field_from_str P((char *buf, int len, t_field *field, char *str));
t_status pat_name_generic P((t_id *optional_id, char *str, int max_len, void *chan, char *name));
t_status pat_get_field_generic P((t_id *optional_id, char *buf, int len, char *field, char *str, int max_len, t_field *fields));
t_status pat_set_field_generic P((t_id *optional_id, char *buf, int len, char *field, char *value, t_field *fields));
t_status pat_get_fields_generic P((t_vec *vec_str, t_field *fields));
t_status pat_get_itmpl_generic P((t_id *id, char *buf, int len, char *str, int max_len, void *chan, char *itmpl));
t_status pat_get_itmpl2_generic P((t_id *id, char *buf, int len, char *str, int max_len, void *chan, char *itmpl));
t_status pat_get_field_pat_generic P((char *field, t_pat **pat_return, void **data_return, t_field *fields));
void pat_print P((t_pat *pat, char *fmt, ...));
#endif
