/*
** pat_rpc.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:47:50 1999 
** Last update Thu Oct 28 20:21:05 1999 
*/
#ifndef PAT_RPC_H
#define PAT_RPC_H	1

#include "pat.h"

typedef struct			s_rpccall
{
  t_u32				rpcversion;
  t_u32				program;
  t_u32				version;
  t_u32				procedure;
} t_rpccall;

#define RPCCALL_HLEN		16

#define PAT_RPCCALL_CHECK(rpccallpar,bufpar,lenpar) \
	if ((lenpar) < RPCCALL_HLEN)\
		return (ERR_PAT_TRUNC_PAT);\
	(rpccallpar) = (t_rpccall *)(bufpar);

#define RPCCALL_PORT		111

#define RPCCALLDIRECTION_CALL	0
#define RPCCALLDIRECTION_REPLY	1

typedef struct			s_rpc
{
  t_u32				xid;
  t_u32				direction;
} t_rpc;

#define RPC_HLEN		8

#define PAT_RPC_CHECK(rpcpar,bufpar,lenpar) \
	if ((lenpar) < RPC_HLEN)\
		return (ERR_PAT_TRUNC_PAT);\
	(rpcpar) = (t_rpc *)(bufpar);

#define RPC_PORT		111

#define RPCDIRECTION_CALL	0
#define RPCDIRECTION_REPLY	1

extern t_pat			rpccall_pat;
extern t_pat			rpc_pat;

/* PROTO pat_rpc.c */
/* pat_rpc.c */
t_status rpccall_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status rpccall_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status rpccall_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status rpccall_pat_get_fields P((void *data, t_vec *vec_str));
t_status rpccall_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status rpccall_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status rpccall_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status rpccall_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status rpc_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status rpc_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status rpc_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status rpc_pat_get_fields P((void *data, t_vec *vec_str));
t_status rpc_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status rpc_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status rpc_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status rpc_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
#endif
