/*
** mg_opt.h for  in 
** 
** Made by 
** Login   <root@epita.fr>
** 
** Started on  Wed Sep  1 06:13:45 1999 
** Last update Thu Oct 28 20:17:31 1999 
*/
#ifndef MG_OPT_H
#define MG_OPT_H	1

#include "mg.h"

struct s_opt_context;

#define OPT_ALLOWMULTI		(1L<<0)		

typedef int			(*t_opt_proc) P((struct s_opt_context *oc,
						 int idx,
						 VOID_PTR addr,
						 t_status *status));
						 
typedef struct			s_opt
{
  char				*name;
  t_opt_proc			proc;
  t_off				offset;
  char				*param_comment;
  char				*comment;
  t_mask			flags;
} t_opt;

typedef struct			s_opt_context
{
  t_boolean			*tr_args;	/* MUST BE SET		*/
  int				nb_tr_args;	/* MUST BE SET		*/
  t_boolean			*tr_opts;	/* MUST BE SET		*/
  int				nb_tr_opts;	/* MUST BE SET		*/
  int				*argc;		/* MUST BE SET		*/
  char				**argv;		/* MUST BE SET		*/
  t_opt				*opts;		/* MUST BE SET		*/
  int				nb_opts;	/* MUST BE SET		*/
  char				*base_addr;	/* MUST BE SET		*/
} t_opt_context;

/* PROTO mg_opt.c */
/* mg_opt.c */
int opt_is_arg P((t_opt_context *oc, int idx, char **addr, t_status *status));
int opt_boolean_true P((t_opt_context *oc, int idx, t_boolean *addr, t_status *status));
int opt_boolean_false P((t_opt_context *oc, int idx, t_boolean *addr, t_status *status));
int opt_str P((t_opt_context *oc, int idx, char **addr, t_status *status));
int opt_s32 P((t_opt_context *oc, int idx, t_s32 *addr, t_status *status));
int opt_int P((t_opt_context *oc, int idx, int *addr, t_status *status));
int opt_tr_args_matched P((t_opt_context *oc));
void opt_build_new_args P((t_opt_context *oc, int matched));
t_status opt_init_tr_args P((t_opt_context *oc));
t_status opt_init_tr_opts P((t_opt_context *oc));
int opt_get P((t_opt_context *oc, t_status *status));
void opt_usage P((FILE *f, t_opt *opts, int nb_opts, t_boolean full_usage));
int opt_check P((t_opt *opts, int nb_opts));
#endif
