/*
** gdm.c for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 12:10:34 1999 vianney rancurel
** Last update Thu Oct 28 20:16:44 1999 
*/
#include "gdm.h"
#include "mg_dm.h"

t_boolean		global_debug_malloc = FALSE;

t_dm			gdm;

/* is a t_alloc_algorithm_proc.
   It performs a factor2 for the moment, but can be changed to
   anything else as a debug feature. */
t_status		gdm_alloc_algorithm(old_size,
					    request_size,
					    new_size)
size_t			old_size;
size_t			request_size;
size_t			*new_size;
{
  return (alloc_algorithm_factor2(old_size,request_size,new_size));
}

/* initializes the global debug malloc environnement.
   It also allocates the id. It is possible to change members of
   the global debug malloc structure by accessing the global variable gdm. 
   Note that all the gdm_* functions are used for debug. */
VOID_FUNC		gdm_init(VOID_DECL)
{
  t_status		status;
  
  if ((gdm.id = id_new(HASH_BASE,
		       VEC_BASE,
		       alloc_algorithm_factor2,
		       alloc_malloc,
		       realloc_realloc,
		       free_free,
		       "gdm",
		       &status)) == NULL)
    {
      err_print(status,"ID_NEW");
      exit(1);
    }
  dm_init(&gdm);
}

/* is a t_alloc_proc.
   If global_debug_malloc is TRUE, then memory is allocated in using a t_dm,
   else alloc_malloc(3) is used. */
VOID_PTR		gdm_alloc(size,comment1,comment2,status)
size_t			size;
char			*comment1;
char			*comment2;
t_status		*status;
{
  if (global_debug_malloc)
    return (dm_malloc(&gdm,size,comment1,comment2,status));
  else
    return (alloc_malloc(size,comment1,comment2,status));
}

/* is a t_realloc_proc.
   If global_debug_malloc is TRUE, then memory is allocated in using a t_dm,
   else realloc_realloc(3) is used. */
VOID_PTR		gdm_realloc(old_ptr,
				    size,
				    comment1,
				    comment2,
				    status)
VOID_PTR		old_ptr;
size_t			size;
char			*comment1;
char			*comment2;
t_status		*status;
{
  if (global_debug_malloc)
    return (dm_realloc(&gdm,old_ptr,size,comment1,comment2,status));
  else
    return (realloc_realloc(old_ptr,size,comment1,comment2,status));
}

/* is a t_free_proc.
   If global_debug_malloc is TRUE, then memory is freed in using a t_dm,
   else free_free(3) is used. */
VOID_FUNC		gdm_free(ptr,comment1,comment2)
VOID_PTR		ptr;
char			*comment1;
char			*comment2;
{
  if (global_debug_malloc)
    dm_free(&gdm,ptr,comment1,comment2);
  else
    free_free(ptr,comment1,comment2);
}

/* unmarks a memory zone in the global debug malloc env. */
VOID_FUNC		gdm_unmark(ptr,comment1,comment2)
VOID_PTR		ptr;
char			*comment1;
char			*comment2;
{
  if (global_debug_malloc)
    dm_unmark(&gdm,ptr,comment1,comment2);
}

/* calls dm_show(3). */
VOID_FUNC		gdm_status(VOID_DECL)
{
  dm_show(&gdm);
}
