/*
** XmgPrompt.c for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 14:14:17 1999 vianney rancurel
** Last update Thu Oct 28 20:22:22 1999 
*/
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Viewport.h>
#include "XmgMacro.h"
#include "XmgPulldown.h"
#include "XmgPrompt.h"
#include "TextField.h"

extern Widget			toplevel;

/* shows an autonomous prompt box. */
VOID_FUNC			XmgShowPromptBox(parent,
						 labelstr,
						 valuestr,
						 ok_proc,
						 cancel_proc,
						 data,
						 grab_kind)
Widget				parent;
char				*labelstr;	/* Label string */
char				*valuestr;	/* Value string */
XmgMacroMultiCallbackProc	ok_proc;	/* Ok proc */
XmgMacroMultiCallbackProc	cancel_proc;	/* Cancel proc */
XtPointer			data;		/* Data passed to callbacks */
XtGrabKind			grab_kind;	/* Grab kind */
{
  Widget			shell;
  Widget			label;
  Widget			text;
  Widget			ok;
  Widget			cancel;
  XFontStruct			*xfs;
  
  INTERFACE(parent,
            GETCHILDSHELL(shell)
            ("xmgPromptBox",transientShellWidgetClass,
             XtNmappedWhenManaged,	False,
	     XtNtransientFor,		parent,
	     XtNallowShellResize,	True,
	     CHILD("form",formWidgetClass,
                   GETCHILD(label)
                   ("label",labelWidgetClass,
		    XtNlabel,		labelstr,
		    END),
		   GETCHILD(text)
		   ("text",textfieldWidgetClass,
		    XtNfromHoriz,	label,
		    XtNstring,		valuestr,
		    XtNresizable,	True,
		    END),
                   GETCHILD(ok)
		   ("ok",commandWidgetClass,
		    XtNfromVert,	label,
		    MCALLBACK(XtNcallback,ok_proc,shell,text,data,DONE),
		    END),
		   GETCHILD(cancel)
		   ("cancel",commandWidgetClass,
		    XtNfromHoriz,	ok,
		    XtNfromVert,	text,
		    MCALLBACK(XtNcallback,cancel_proc,shell,data,DONE),
		    END),
                   END),
             MANAGE,
             END),
            ENDINTERFACE);
  XtVaGetValues(text,
		XtNfont,	&xfs,
		NULL);
  XtVaSetValues(text,
		XtNwidth,
		XTextWidth(xfs,valuestr,strlen(valuestr)) + 
		XTextWidth(xfs," ",1),
		NULL);
  XmgCenterWidget(shell);
  XmgSetDestroyOnDelete(shell);
  XtPopup(shell,grab_kind);
}

/* shows an autonomous prompt box with a pulldown instead of a text field */
VOID_FUNC		XmgShowPromptPulldownBox(parent,
						 labelstr,
						 values_vec_str,
						 valuestr,
						 ok_proc,
						 cancel_proc,
						 data,
						 grab_kind)
Widget			parent;
char			*labelstr;		/* Label string */
t_vec			*values_vec_str;	/* Vector of strings */
char			*valuestr;		/* Default value */
XmgMacroMultiCallbackProc	ok_proc;		/* Ok proc */
XmgMacroMultiCallbackProc	cancel_proc;		/* Cancel proc */
XtPointer		data;			/* Data passed to callbacks */
XtGrabKind		grab_kind;		/* Grab kind */
{
  Widget		shell;
  Widget		label;
  Widget		pulldown;
  Widget		ok;
  Widget		cancel;
  
  INTERFACE(parent,
            GETCHILDSHELL(shell)
            ("xmgPromptBox",transientShellWidgetClass,
             XtNmappedWhenManaged,	False,
	     XtNtransientFor,		parent,
	     XtNallowShellResize,	True,
	     CHILD("form",formWidgetClass,
                   GETCHILD(label)
                   ("label",labelWidgetClass,
		    XtNlabel,		labelstr,
		    END),
		   INSERTCODE(
			      pulldown =
			      XmgCreatePulldownFromVecStr(GETPARENT,
							  values_vec_str,
							  (XtCallbackProc)XmgPulldownMenuCallback);
			      XtVaSetValues(pulldown,
					    XtNlabel,		valuestr,
					    XtNfromHoriz,	label,
					    XtNresizable,	True,
					    NULL);
			      ),
                   GETCHILD(ok)
		   ("ok",commandWidgetClass,
		    XtNfromVert,	label,
		    MCALLBACK(XtNcallback,ok_proc,shell,pulldown,data,DONE),
		    END),
		   GETCHILD(cancel)
		   ("cancel",commandWidgetClass,
		    XtNfromHoriz,	ok,
		    XtNfromVert,	pulldown,
		    MCALLBACK(XtNcallback,cancel_proc,shell,data,DONE),
		    END),
                   END),
             MANAGE,
             END),
            ENDINTERFACE);
  XmgCenterWidget(shell);
  XmgSetDestroyOnDelete(shell);
  XtPopup(shell,grab_kind);
}

/* shows an autonomous prompt box with a complex pulldown */
VOID_FUNC		XmgShowPromptComplexPulldownBox(parent,
							labelstr,
							values_vec_str,
							valuestr,
							ok_proc,
							cancel_proc,
							data,
							grab_kind)
Widget			parent;
char			*labelstr;		/* Label string */
t_vec			*values_vec_str;	/* Vector of strings */
char			*valuestr;		/* Default value */
XmgMacroMultiCallbackProc	ok_proc;		/* Ok proc */
XmgMacroMultiCallbackProc	cancel_proc;		/* Cancel proc */
XtPointer		data;			/* Data passed to callbacks */
XtGrabKind		grab_kind;		/* Grab kind */
{
  Widget		shell;
  Widget		label;
  Widget		pulldown;
  Widget		ok;
  Widget		cancel;
  
  INTERFACE(parent,
            GETCHILDSHELL(shell)
            ("xmgPromptBox",transientShellWidgetClass,
             XtNmappedWhenManaged,	False,
	     XtNtransientFor,		parent,
	     XtNallowShellResize,	True,
	     CHILD("form",formWidgetClass,
                   GETCHILD(label)
                   ("label",labelWidgetClass,
		    XtNlabel,		labelstr,
		    END),
		   INSERTCODE(
			      pulldown =
			      XmgCreateComplexPulldownFromVecStr("pulldown",
								 GETPARENT,
								 values_vec_str,
								 (XtCallbackProc)XmgPulldownMenuCallback);
			      XtVaSetValues(pulldown,
					    XtNlabel,		valuestr,
					    XtNfromHoriz,	label,
					    XtNresizable,	True,
					    NULL);
			      ),
                   GETCHILD(ok)
		   ("ok",commandWidgetClass,
		    XtNfromVert,	label,
		    MCALLBACK(XtNcallback,ok_proc,shell,pulldown,data,DONE),
		    END),
		   GETCHILD(cancel)
		   ("cancel",commandWidgetClass,
		    XtNfromHoriz,	ok,
		    XtNfromVert,	pulldown,
		    MCALLBACK(XtNcallback,cancel_proc,shell,data,DONE),
		    END),
                   END),
             MANAGE,
             END),
            ENDINTERFACE);
  XmgCenterWidget(shell);
  XmgSetDestroyOnDelete(shell);
  XtPopup(shell,grab_kind);
}
