/*
** Xmg.c for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 14:15:26 1999 vianney rancurel
** Last update Thu Oct 28 20:22:38 1999 
*/
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "XmgI.h"
#include "XmgMacro.h"
#include "XmgDict.h"
#include "XmgAction.h"
#include "Xmg.h"

extern Widget		toplevel;
extern XtAppContext	app_context;

/* prints a warning message using XtWarning(3) */
#ifdef HAVE_STDARG_H
VOID_FUNC		XmgWarning(char *fmt,...)
#else
VOID_FUNC		XmgWarning(fmt,va_alist)
Widget			parent;
char			*fmt;
va_dcl
#endif
{
  va_list		ap;
  char			buf[BUFSIZ];
  
  assert(fmt);
#ifdef HAVE_STDARG_H
  va_start(ap,fmt);
#else
  va_start(ap);
  va_arg(ap,char *);
#endif
  vsnprintf(buf,sizeof (buf),fmt,ap);
  XtWarning(buf);
  va_end(ap);
}

/* centers a widget */
VOID_FUNC		XmgCenterWidget(w)
Widget			w;
{
  int			dwidth;
  int			dheight;
  Dimension		width;
  Dimension		height;
  Position		x;
  Position		y;

  dwidth = DisplayWidth(XtDisplay(w),DefaultScreen(XtDisplay(w)));
  dheight = DisplayHeight(XtDisplay(w),DefaultScreen(XtDisplay(w)));
  XtVaGetValues(w,
                XtNwidth,	&width,
                XtNheight,	&height,
                NULL);
  x = (dwidth - width)/2;
  y = (dheight - height)/2;
  XtVaSetValues(w,
                XtNx,		x,
                XtNy,		y,
                NULL);
}

/* tallies a widget with screen */
VOID_FUNC		XmgTallyWidgetWithScreen(w)
Widget			w;
{
  int			dwidth;
  int			dheight;
  Dimension		width;
  Dimension		height;
  Position		x;
  Position		y;
  Position		nx;
  Position		ny;
  Dimension		border_width;

  dwidth = DisplayWidth(XtDisplay(w),DefaultScreen(XtDisplay(w)));
  dheight = DisplayHeight(XtDisplay(w),DefaultScreen(XtDisplay(w)));
  XtVaGetValues(w,
		XtNx,		&x,
		XtNy,		&y,
                XtNwidth,	&width,
                XtNheight,	&height,
		XtNborderWidth,	&border_width,
                NULL);
  if ((x + width + border_width) > dwidth)
    nx = x - (x + width +border_width - dwidth);
  else
    nx = x;
  if ((y + height + border_width) > dheight)
    ny = y - (y + height + border_width - dheight);
  else
    ny = y;
  XtVaSetValues(w,
                XtNx,		nx,
                XtNy,		ny,
                NULL);
}

/* initializes Xmg actions, XmgPixmapDict, XmgXFSDict, XmgPixelDict */
t_status			XmgInit(VOID_DECL)
{
  t_status			status;

  XmgRegisterConverters();
  XtAppAddActions(app_context,XmgActions,XmgNumActions);
  if ((XmgPixmapDict = XMG_SMALL_DICT_NEW(&status)) == NULL)
    return (status);
  if ((XmgXFSDict = XMG_SMALL_DICT_NEW(&status)) == NULL)
    return (status);
  if ((XmgPixelDict = XMG_SMALL_DICT_NEW(&status)) == NULL)
    return (status);
}

#ifdef DEBUG
/* shows a XRectangle.
   This is a debug function. */
VOID_FUNC			XmgShowRect(rect)
XRectangle			*rect;
{
  fprintf(stderr,"+%d+%d %dx%d\n",
	  rect->x,
	  rect->y,
	  rect->width,
	  rect->height);
}

/* shows XmgPixmapDict, XmgPixelDict and XmgXFSDict.
   This is a debug function. */
VOID_FUNC			XmgStatus(VOID_DECL)
{
  fprintf(stderr,"pixmaps:\n");
  dict_walk(XmgPixmapDict,
	    (t_dict_walk_proc)XmgPixmapDictStatusWalk,
	    NULL);
  fprintf(stderr,"pixels:\n");
  dict_show_sorted(XmgPixelDict);
  fprintf(stderr,"xfs:\n");
  dict_show_sorted(XmgXFSDict);
}
#endif
