/* File   : makeip_func.c
 * Author : Karyl F. Stein <xenon@xenos.net>
 * Purpsoe: Functions for use by the makeip program.  The individual functions
 *          are detailed before the function below.
 *
 * Spak is Copyright (C)1996 Karyl F. Stein <xenon@xenos.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include <stdio.h>

#ifdef SunOS
#include <sys/types.h>        /* u_char      */
#include <netinet/in.h>       /* sockaddr_in */
#include <arpa/nameser.h>     /* MAXDNAME    */
#include <resolv.h>           /* in_addr     */
#include <netinet/in_systm.h> /* n_long      */
#endif  /* SunOS */

#ifdef BSDI31
#include <netinet/in.h>       /* sockaddr_in */
#include <arpa/nameser.h>     /* MAXDNAME    */
#include <resolv.h>           /* in_addr     */
#include <netinet/in_systm.h> /* n_long      */
#endif /* BSDI31 */

#include <netinet/ip.h>       /* IP header struct    */
#include "makeip_func.h"      /* Function prototypes */
#include "makeip_conf.h"      /* Default settings    */

/* Set defaults if not defined previously or not valid.  Do not change. */
#ifndef IP_DEFAULT_PROTOCOL
#define IP_DEFAULT_PROTOCOL 6
#endif  /* IP_DEFAULT_PROTOCOL */
#ifndef IP_DEFAULT_TTL
#define IP_DEFAULT_TTL 64
#endif  /* IP_DEFAULT_TTL */
#ifndef IP_DEFAULT_VERSION
#define IP_DEFAULT_VERSION 4
#endif  /* IP_DEFAULT_VERSION */
#ifndef IP_DEFAULT_HEADER_SIZE
#define IP_DEFAULT_HEADER_SIZE 20
#endif  /* IP_DEFAULT_HEADER_SIZE */


/* Function: new_ip_packet
 * Return  : A new IP packet header with default values set.
 */
struct ip *new_ip_packet (void) {
  struct ip *retval;

  /* Allocate the structure to hold the packet */
  if ((retval = (struct ip *) malloc(sizeof(struct ip))) == NULL) {
    fprintf(stderr, "Out of Memory\n");
    exit(1);
  }

  /* Set the packet data to the defaults */
  retval->ip_v = IP_DEFAULT_VERSION;
  retval->ip_hl = IP_DEFAULT_HEADER_SIZE / 4;          /* In 32-bit words */
  retval->ip_tos = 0;
  retval->ip_len = IP_DEFAULT_HEADER_SIZE;             /* In bytes */
  retval->ip_id = 0;
  retval->ip_off = 0;
  retval->ip_ttl = IP_DEFAULT_TTL;                     /* In seconds */
  retval->ip_p = IP_DEFAULT_PROTOCOL;
  retval->ip_sum = 0;

  return(retval);
}
