/* File   : ether_func.c
 * Author : J Hadi Salim <ad828@freenet.carleton.ca>
 * Purpose: Functions for use with ethernet routines.  The individual
 *          functions are detailed below.
 *
 * Notes  : This file has been modified by Karyl F. Stein <xenon@xenos.net>.
 *          Any bugs are my fault.
 *
 * Spak is Copyright (C)1996 Karyl F. Stein <xenon@xenos.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include <stdio.h>


/* Function: hwaddread
 * Input   : An array of 6 unsigned char values in which the result will be
 *           stored, and a string representation of a MAC address in the
 *           form a:b:c:d:e:f where a through f are two digit hexadecimal
 *           numbers.
 * Output  : The string is converted into a set of numbers and stored in the
 *           passed array.
 * Return  : 0 if successful, otherwise -1.
 *
 * Notes:
 *
 *   - Routine stolen from Abhijit Dixit somewhere on the net; can't locate
 *     where
 */
int hwaddread (unsigned char s[], char *hwadr) {
  int a, b, c, d, e, f;

  if (sscanf(hwadr,"%x:%x:%x:%x:%x:%x", &a, &b, &c, &d, &e, &f) == 6) {
    s[0] = (unsigned char) a;
    s[1] = (unsigned char) b;
    s[2] = (unsigned char) c;
    s[3] = (unsigned char) d;
    s[4] = (unsigned char) e;
    s[5] = (unsigned char) f;
    return(0);
  }

  return(-1);
}


/* Function: ipaddread
 * Input   : An array of 4 unsigned char values in which the result will be
 *           stored, and a string representation of an IP address in the
 *           form a.b.c.d where a through d are 1 to 3 digit decimal numbers.
 * Output  : The string is converted into a set of numbers and stored in the
 *           passed array.
 * Return  : 0 if successful, otherwise -1.
 *
 * Notes:
 *
 *   - Routine stolen from Abhijit Dixit somewhere on the net; can't locate
 *     where
 */
int ipaddread(char s[], char *ipadr) {
  int a, b, c, d;

  if (sscanf(ipadr,"%d.%d.%d.%d", &a, &b, &c, &d) == 4) {
    s[0] = (unsigned char) a;
    s[1] = (unsigned char) b;
    s[2] = (unsigned char) c;
    s[3] = (unsigned char) d;
    return(0);
  }

  return(-1);
}


/* Function: typeread
 * Input   :
 * Return  :
 */
int typeread (char *asc_type) {
  int a, b;

  b = sscanf(asc_type, "%x", &a);

  /* Add more error checks in the future */
  if ((a>65534) || (b!=1))
    return(-1);
  else return(a);        /* will catch -ve numbers as well */
}
