/* 
 * This is source code to CASL (Custom Audit Scripting Language)
 *
 * Copyright 1998 Secure Networks, Inc.
 * Copyright 1999 Network Associates, Inc.
 * All Rights Reserved
 *
 * BEFORE YOU INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT,
 * CAREFULLY READ THE TERMS AND CONDITIONS IN THE FILE
 * "LICENSE.TXT" ACCOMPANYING THIS DOCUMENT. IF THE FILE
 * "LICENSE.TXT" IS MISSING, IT MAY BE OBTAINED FROM
 * NETWORK ASSOCIATES. NETWORK ASSOCIATES IS PERMITTING
 * THE USE, DISTRIBUTION, AND LIMITED MODIFICATION OF THIS
 * SOFTWARE PRODUCT ON A NON-COMMERCIAL BASIS SUBJECT TO
 * ALL OF THE CONDITIONS IN THE FILE "LICENSE.TXT." BY INSTALLING,
 * USING, OR MODIFYING THE SOFTWARE PRODUCT, YOU AND ANY
 * SUBSEQUENT USER ARE AGREEING TO BE BOUND BY ALL OF THE
 * TERMS AND CONDITIONS IN THE FILE "LICENSE.TXT." IF YOU DO
 * NOT AGREE TO ALL OF THOSE TERMS AND CONDITIONS, DO NOT
 * INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT.
 */

#include "casl.h"

/* ----------------------------------------------------------------- */

#ifdef _WIN32
extern void srandom();
extern unsigned int random();
#endif

/* ----------------------------------------------------------------------------
** Builtin hook for the CASL rand() function.
*/

asr_t *casl_rand(asr_t *arg) {
	static int seed = -1;
	int ss = 0;

	if (arg && arg->asr_kids[1]) {
		error (E_USER, "too many arguments for rand()");
	}

	if(arg && arg->asr_kids[0]) {
		int ns = asr_getint_strict(arg->asr_kids[0]);
		if(ns)
			ss = seed = ns;
	} else if(seed < 0) 
		ss = seed = time(0);

	if(ss) 
		srandom(seed);

	return(asr_int(random(), 0));
}
