#include "strutil.h"

#ifndef NUL
#define NUL_DEFINED
#define NUL '\0'
#endif

/* ----------------------------------------------------------------------------
** zorch leading and trailing tabs, spaces, and newlines
*/

char *
strim(char *string) {
	int i = 0;
	char *cp;

	assert(string);

	if(!strlen(string))
		return(string);

	for(i = 0; isspace((int)string[i]); i++);
	/* do nothing */

	if(i) strcpy(string, string + i);

	cp = string + strlen(string);
	while((cp--) != string && isspace((int)*cp)) 
		*cp = NUL;	

	return(string);
}

/* ----------------------------------------------------------------------------
** reduce X * whitespace to whitespace (including newline)
*/

char *
strsc(char *string) {
	int x = 0;
	int y = 0;

	assert(string);	

	if(!strlen(string))
		return(string);

	while(string[x]) {
		if(isspace((int)string[x])) {
			if(y && string[x + 1]) 
				string[y++] = ' ';
		
			while(isspace((int)string[x]))
				x++;
		} else 
			string[y++] = string[x++];
	}

				
	string[y] = NUL;
	return(string);
}

/* ----------------------------------------------------------------------------
** strsep, return quoted tokens as single token
*/

char *strquotesep(char **string, char *delim) {
	char *s;
	char *span;
	int c, sc;
	char *tok;

	s = *string;
	if(!s)
		return(NULL);
	
	for(tok = s; ;) {
		c = *s++;

		if(c == '\"') {
			tok = s;

			while(*s != '\"') 
				s++;
			
			if(*s) 
				*s++ = '\0';

			*string = s;

			return(tok);
		}

		span = delim;
		do {
			if((sc = *span++) == c) {
				if(c == 0)
					s = NULL;
				else
					s[-1] = 0;
			
				*string = s;
				return(tok);
			}
		} while(sc != 0);
	}
}			

/* ----------------------------------------------------------------------------
** strip leading and trailing quotes
*/

char * 
strimquote(char *string) {
	assert(string);

	string = strim(string);

	if(*string == '\"') {
		string++;
		if(string[strlen(string) - 1] == '\"')
			string[strlen(string) - 1] = NUL;
	}

	return(string);
}

/* ----------------------------------------------------------------------------
** cut last whitespace / newline character from string
*/

void
chop(char *string) {
	char *cp;

	assert(string);

	if((cp = strchr(string, '\n')))
		*cp = '\0';

	return;
}

/* ----------------------------------------------------------------------------
** convert a string to lowercase in place
*/

char *strlwr (char *foo) {
	int i;
    
	for (i=0; foo && foo[i]; i++)
		if(isalpha((int)foo[i]))
	    		foo[i]=
			(char) tolower(foo[i]);

	return foo;
}

/* ----------------------------------------------------------------------------
** case-insensitive substring search
*/

char *stristr(char *foo, char *bar) {
    char *rv=0;
    char *haystack;
    char *needle;

    if (!foo || !bar)
	return foo;

    haystack = (char *)malloc (strlen(foo) +2);
    needle   = (char *)malloc (strlen(bar) +2);

    if (haystack && needle) {
	strcpy(haystack, foo); strlwr(haystack);
	strcpy(needle,   bar); strlwr(needle);

	rv = strstr(haystack, needle);

	free (haystack); 
	free (needle);
    }

    if (rv)
        return (rv - haystack + foo);
    else 
	return 0;
}

/* ----------------------------------------------------------------------------
** get the "filename" part of a fully qualified path
*/

#ifndef linux
char *basename(char *fullname, char seperator) {
	char *cp;

	assert(fullname);

	if(!seperator) 
		seperator = '/';

	cp = strrchr(fullname, seperator);

	return cp ? cp + 1 : fullname;
}	
#endif

/* ----------------------------------------------------------------------------
** quote a character in a string with a different character
*/

char *strquote(char *string, char c, char qc) {
	int i = 0;
	char *newstring;
	char *cp, *ncp;

	for(cp = string; *cp; cp++) 
		if(*cp == c)
			i++;

	ncp = newstring = (char *) NEW(strlen(string) + i + 1);

	for(cp = string; *cp; cp++) {
		if(*cp == c) 
			*ncp++ = qc;

		*ncp++ = *cp;
	}

	return(newstring);
}

/* ----------------------------------------------------------------------------
** undo this treachery
*/

char *strdquote(char *string, char c) {
	char *cp;
	char *sp;

	sp = string;
	for(cp = string; *cp; cp++) {
		if(*cp == c)
			continue;

		*sp++ = *cp;
	}

	*sp = '\0';

	return(string);
}

/* ----------------------------------------------------------------------------
** silly malloc wrapper
*/

#ifdef TRACK_MALLOCS
int g_allocation_count;
#endif

void *NEW(const int size) {
	void *ptr = (void *) calloc(1, size);
	if(!ptr) {
		fprintf(stderr, "malloc: allocation failed\n");
		assert(ptr);
	}

#ifdef TRACK_MALLOCS
	g_allocation_count++;
#endif

	return(ptr);
}

/*------------------------------------------------------------------------*/

#ifdef NUL_DEFINED
#undef NUL_DEFINED
#undef NUL
#endif
