/* 
 * This is source code to CASL (Custom Audit Scripting Language)
 *
 * Copyright 1998 Secure Networks, Inc.
 * Copyright 1999 Network Associates, Inc.
 * All Rights Reserved
 *
 * BEFORE YOU INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT,
 * CAREFULLY READ THE TERMS AND CONDITIONS IN THE FILE
 * "LICENSE.TXT" ACCOMPANYING THIS DOCUMENT. IF THE FILE
 * "LICENSE.TXT" IS MISSING, IT MAY BE OBTAINED FROM
 * NETWORK ASSOCIATES. NETWORK ASSOCIATES IS PERMITTING
 * THE USE, DISTRIBUTION, AND LIMITED MODIFICATION OF THIS
 * SOFTWARE PRODUCT ON A NON-COMMERCIAL BASIS SUBJECT TO
 * ALL OF THE CONDITIONS IN THE FILE "LICENSE.TXT." BY INSTALLING,
 * USING, OR MODIFYING THE SOFTWARE PRODUCT, YOU AND ANY
 * SUBSEQUENT USER ARE AGREEING TO BE BOUND BY ALL OF THE
 * TERMS AND CONDITIONS IN THE FILE "LICENSE.TXT." IF YOU DO
 * NOT AGREE TO ALL OF THOSE TERMS AND CONDITIONS, DO NOT
 * INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT.
 */

#ifndef UTILS_INCLUDED
#define UTILS_INCLUDED

#include "casl-asr.h"
#include "arch.h"

int string_to_int(char *);
u_long string_to_ulong(char *);
void error(int, char *, ...);
char *list_to_string(asr_t *);

void setbits(u_char *, int, int, u_long);
u_long getbits(u_char *, int, int);

void *xalloc(const int);
void *xcalloc(const int, const int);
void *xrealloc(void *, size_t);
char *xstrdup(char *);
u_char *xbufdup(u_char *, int);
u_int32_t *xulongdup(u_int32_t);
void xfree(void **);

void debugger(void);
u_int32_t resolve(char *);
char *addr_ntoa(u_int32_t);

u_int32_t c_get_int(char *);
char *c_get_str(char *);

char *strap(char *a, char *b);

char *buf2asciiz (const asr_t *buf);

#ifndef _BSD
char *strsep(char **, const char *);
#endif

#endif
