/* 
 * This is source code to CASL (Custom Audit Scripting Language)
 *
 * Copyright 1998 Secure Networks, Inc.
 * Copyright 1999 Network Associates, Inc.
 * All Rights Reserved
 *
 * BEFORE YOU INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT,
 * CAREFULLY READ THE TERMS AND CONDITIONS IN THE FILE
 * "LICENSE.TXT" ACCOMPANYING THIS DOCUMENT. IF THE FILE
 * "LICENSE.TXT" IS MISSING, IT MAY BE OBTAINED FROM
 * NETWORK ASSOCIATES. NETWORK ASSOCIATES IS PERMITTING
 * THE USE, DISTRIBUTION, AND LIMITED MODIFICATION OF THIS
 * SOFTWARE PRODUCT ON A NON-COMMERCIAL BASIS SUBJECT TO
 * ALL OF THE CONDITIONS IN THE FILE "LICENSE.TXT." BY INSTALLING,
 * USING, OR MODIFYING THE SOFTWARE PRODUCT, YOU AND ANY
 * SUBSEQUENT USER ARE AGREEING TO BE BOUND BY ALL OF THE
 * TERMS AND CONDITIONS IN THE FILE "LICENSE.TXT." IF YOU DO
 * NOT AGREE TO ALL OF THOSE TERMS AND CONDITIONS, DO NOT
 * INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT.
 */

#ifndef CASL_INCLUDED
#define CASL_INCLUDED

#include "table.h"
#include "list.h"
#include "utils.h"
#include "strutil.h"

#include "casl-asr.h"
#include "casl-eval.h"
#include "casl-symbol.h"
#include "casl-cape.h"
#include "casl-specials.h"

#include <sys/stat.h>

#include "arch.h"

extern table_t *Configuration;

#ifndef CPPFILE
#ifndef SEPERATE_CPP
#define CPPCOMMAND 	"cc -E -"
#define CPPFILE		"/usr/bin/gcc"
#else
#define CPPCOMMAND 	"cpp -"
#define CPPFILE		"/usr/bin/cpp"
#endif
#endif

#define CASL_BASEDIR_ENV 	"CASL_DIR"

#if defined(_WIN32)
#define CASL_INCLUDE_DIR 	"/Program Files/Network Associates/CyberCop Scanner/casl/include"
#define CASL_BASE_DIR		"/Program Files/Network Associates/Scanner/casl"
#elif defined(_SUNOS5)
#define CASL_INCLUDE_DIR	"/opt/casl/include"
#define CASL_BASE_DIR		"/opt/casl"
#else
#define CASL_INCLUDE_DIR	"/usr/local/casl/include"
#define	CASL_BASE_DIR		"/usr/local/casl"
#endif

#define MASTER_CONFIG		"casl-config-master.casl"

#ifdef HAVE_LIBGC
#define GC_DEBUG
#include "gc.h"
#define free(x) GC_free(x)
#endif

void Dprintf(char *, ...);

#define CASL_INFO							\
"1997, 1998 Network Associates, Inc.\n"					\
"http://www.nai.com\n"						\
"Custom Attack Simulation Language (CASL) Interpreter\n"		\
"Version 1.0\n"							

#define INTERNAL_ERROR							\
"CASL has encountered a fatal internal error and is unable to continue\n" \
"executing your script. Unless the interpreter has run out of memory\n" \
"(a known problem in this beta release), this is not normal. Please contact\n" \
"Network Associates, Inc. to report this problem.\n"

#endif

#define CASL_FUNC_PREFIX	"__xNAIcfunc"

char casl_getopt(int, char **, char *);
