/* 
 * This is source code to CASL (Custom Audit Scripting Language)
 *
 * Copyright 1998 Secure Networks, Inc.
 * Copyright 1999 Network Associates, Inc.
 * All Rights Reserved
 *
 * BEFORE YOU INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT,
 * CAREFULLY READ THE TERMS AND CONDITIONS IN THE FILE
 * "LICENSE.TXT" ACCOMPANYING THIS DOCUMENT. IF THE FILE
 * "LICENSE.TXT" IS MISSING, IT MAY BE OBTAINED FROM
 * NETWORK ASSOCIATES. NETWORK ASSOCIATES IS PERMITTING
 * THE USE, DISTRIBUTION, AND LIMITED MODIFICATION OF THIS
 * SOFTWARE PRODUCT ON A NON-COMMERCIAL BASIS SUBJECT TO
 * ALL OF THE CONDITIONS IN THE FILE "LICENSE.TXT." BY INSTALLING,
 * USING, OR MODIFYING THE SOFTWARE PRODUCT, YOU AND ANY
 * SUBSEQUENT USER ARE AGREEING TO BE BOUND BY ALL OF THE
 * TERMS AND CONDITIONS IN THE FILE "LICENSE.TXT." IF YOU DO
 * NOT AGREE TO ALL OF THOSE TERMS AND CONDITIONS, DO NOT
 * INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT.
 */

#ifndef SPECIALS_INCLUDED
#define SPECIALS_INCLUDED

void special_cc_interface(asr_t *);
void special_cc_gateway(asr_t *);
void special_cc_alwaysarp(asr_t *);
void special_cc_netmask(asr_t *);
void special_cc_gateway_mac(asr_t *);
void special_cc_local_mac(asr_t *);
void special_cc_nokernelarp(asr_t *);
void special_cc_arpfallback(asr_t *);
void special_null_variable(asr_t *);


struct special_s {

	char *name;
	void (*handler)(asr_t *);

};

#ifdef SPECIAL_DEFINED

struct special_s SpecialTab[] = {

	{ CC_INTERFACE, 		special_cc_interface },
	{ CC_GATEWAY, 			special_cc_gateway },
	{ CC_GATEWAY_MAC,  		special_cc_gateway_mac },
	{ CC_LOCAL_MAC, 		special_cc_local_mac },
	{ CC_NETMASK,			special_cc_netmask },
	{ CC_ALWAYSARP,			special_cc_alwaysarp },
	{ CC_NOKERNELARP,		special_cc_nokernelarp },
	{ CC_ARPFALLBACK,		special_cc_arpfallback },
	{ NULL_VARIABLE,		special_null_variable },
	{ NULL, NULL }

};

#else

extern struct special_s SpecialTab[];

#endif
#endif
