/* 
 * This is source code to CASL (Custom Audit Scripting Language)
 *
 * Copyright 1998 Secure Networks, Inc.
 * Copyright 1999 Network Associates, Inc.
 * All Rights Reserved
 *
 * BEFORE YOU INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT,
 * CAREFULLY READ THE TERMS AND CONDITIONS IN THE FILE
 * "LICENSE.TXT" ACCOMPANYING THIS DOCUMENT. IF THE FILE
 * "LICENSE.TXT" IS MISSING, IT MAY BE OBTAINED FROM
 * NETWORK ASSOCIATES. NETWORK ASSOCIATES IS PERMITTING
 * THE USE, DISTRIBUTION, AND LIMITED MODIFICATION OF THIS
 * SOFTWARE PRODUCT ON A NON-COMMERCIAL BASIS SUBJECT TO
 * ALL OF THE CONDITIONS IN THE FILE "LICENSE.TXT." BY INSTALLING,
 * USING, OR MODIFYING THE SOFTWARE PRODUCT, YOU AND ANY
 * SUBSEQUENT USER ARE AGREEING TO BE BOUND BY ALL OF THE
 * TERMS AND CONDITIONS IN THE FILE "LICENSE.TXT." IF YOU DO
 * NOT AGREE TO ALL OF THOSE TERMS AND CONDITIONS, DO NOT
 * INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT.
 */

#ifndef CASL_ASR_INCLUDED
#define CASL_ASR_INCLUDED

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <stdarg.h>

typedef struct _asr {
	int asr_type;
	int asr_size;

	int asr_line;
	char *asr_file;

	void *asr_extra;
	void *asr_base;

	int asr_count;

	union {
		struct _asr **kids;
		char *id;
		char *string;
		char  character;
		u_long integer;
		long int sinteger;
		unsigned char *buffer;
	} asr_u;

#define asr_buf		asr_u.buffer
#define asr_kids 		asr_u.kids
#define asr_ident 		asr_u.id
#define asr_str 		asr_u.string
#define asr_character 	asr_u.character
#define asr_integer		asr_u.integer
#define asr_sinteger		asr_u.sinteger


} asr_t;

/* XXX */

typedef asr_t *asrtp;

struct arity {
	int type;
	int arity;
};

#define N_ID			0
#define N_INT			1
#define N_NEGINT		2
#define N_STRING		3
#define N_CHAR			4
#define LIST			5
#define N_CALL			6
#define N_ASSIGN		7
#define N_IDX			8
#define N_FIELD			9
#define N_RANGE			10
#define N_ITE			11
#define N_FOR			12
#define N_WHILE			13
#define N_FOREACH		14
#define N_NEG			15
#define N_POP			16
#define N_HEAD			16
#define N_PLUS			17
#define N_MINUS			18
#define N_MUL			19
#define N_DIV			20
#define N_EQ			21
#define N_NE			22
#define N_GT			23
#define N_LT			24
#define N_GE			25
#define N_LE			26
#define N_AND			27
#define N_OR			28
#define N_FUNC			29
#define N_BODY			30
#define N_STRUCT		31
#define N_STRUCTDEF		32
#define N_RETURN		33
#define N_SIZET			34
#define N_SIZESPEC		35
#define N_EXPR			36
#define N_NEW			37
#define N_EXTRACT		38
#define N_BUFFER		39
#define N_DEBUG			40
#define N_DUMP			41
#define N_NOT			42
#define N_TAIL			43
#define N_PLIST			44
#define N_PTAIL			45
#define N_SNAME			46
#define N_END			47
#define N_EXTRACT2		48
#define N_BREAK			49
#define N_CONTINUE		50
#define N_TRON			51
#define N_TROFF			52
#define N_COPY			53
#define N_SCALE			54
#define N_MOD			55
#define N_BLSHIFT		56
#define N_BRSHIFT		57
#define N_BOR			58
#define N_BAND			59
#define N_BXOR			60
#define N_BNOT			61
#define N_CREATELIST		62
#define N_PREINCR		63
#define N_PREDECR		64
#define N_POSTINCR		65
#define N_POSTDECR		66

#define S_BIT			0		
#define S_BYT			1
#define S_WRD			2
#define S_DWD			3
#define S_VAR			4
#define S_DEF			5

asr_t *asr_new(int);
asr_t *asr_id(char *id, int line);
asr_t *asr_sizet(int i);
asr_t *asr_int(unsigned long i, int line);
asr_t *asr_string(char *string, int line);
asr_t *asr_char(char c, int line);
asr_t *asr_buffer(int size, char *);
asr_t *asr_node(int type, ...);
asr_t *asr_int_long(u_long l, int line);

char *asr_buffer_struct(asr_t *);
void asr_buffer_struct_set(asr_t *, char *);
void asr_buf_move(asr_t *, asr_t *, int);
void asr_buf_slide(asr_t *, int);
int asr_buf_size(asr_t *);
void asr_buf_resize(asr_t *, int);

void asr_print(asr_t *);
int asr_basetype(asr_t *);
int asr_tobuf(asr_t *, u_char **);
int asr_strep(asr_t *, char **);
unsigned long asr_getint(asr_t *);
unsigned long asr_getint_strict(asr_t *);
asr_t *asr_copy(asr_t *);

void alloc_push(void);
void alloc_pop(void);
void alloc_collect(void);
void alloc_register(asr_t *);
void alloc_unregister(asr_t *);
void alloc_uplref(asr_t *);
void alloc_downlref(asr_t *);
void alloc_upref(asr_t *);
void alloc_downref(asr_t *);
void asr_safefree(asr_t **);
void asr_sfree(asr_t **);
int  alloc_isref(asr_t *);

#define NULL_VARIABLE "null"
extern asr_t *null;

#endif



