/* 
 * This is source code to CASL (Custom Audit Scripting Language)
 *
 * Copyright 1998 Secure Networks, Inc.
 * Copyright 1999 Network Associates, Inc.
 * All Rights Reserved
 *
 * BEFORE YOU INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT,
 * CAREFULLY READ THE TERMS AND CONDITIONS IN THE FILE
 * "LICENSE.TXT" ACCOMPANYING THIS DOCUMENT. IF THE FILE
 * "LICENSE.TXT" IS MISSING, IT MAY BE OBTAINED FROM
 * NETWORK ASSOCIATES. NETWORK ASSOCIATES IS PERMITTING
 * THE USE, DISTRIBUTION, AND LIMITED MODIFICATION OF THIS
 * SOFTWARE PRODUCT ON A NON-COMMERCIAL BASIS SUBJECT TO
 * ALL OF THE CONDITIONS IN THE FILE "LICENSE.TXT." BY INSTALLING,
 * USING, OR MODIFYING THE SOFTWARE PRODUCT, YOU AND ANY
 * SUBSEQUENT USER ARE AGREEING TO BE BOUND BY ALL OF THE
 * TERMS AND CONDITIONS IN THE FILE "LICENSE.TXT." IF YOU DO
 * NOT AGREE TO ALL OF THOSE TERMS AND CONDITIONS, DO NOT
 * INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT.
 */

#ifndef ARCH_INCLUDED
#define ARCH_INCLUDED

#if defined(_FREEBSD) || defined(_OPENBSD) || defined(_BSDI)
#define _BSD
#endif

#ifdef _SUNOS5
  typedef int int32_t;
  typedef unsigned int u_int32_t;
  typedef unsigned short u_int16_t;
  #define BIG_ENDIAN 1
  #define LITTLE_ENDIAN 2
  /*XXX this may have to change if we ever do x86-solaris */
  #define BYTE_ORDER BIG_ENDIAN
  #define INADDR_NONE     ((unsigned int)0xffffffff)
#endif

#ifdef _WIN32
  /* endian is defined in <sys/param.h>, dont ask me why */
  #include <sys/param.h>
  #define ETHER_ADDR_LEN 6
#endif


#endif
