#
# configure arch dependant flags
#


# set the $(SNI_OSTYPE) variable to one of:
#     linux openbsd freebsd bsdi sunos5 win32
# this can be overridden by defining $(SNI_OSTYPE) before including this file
ifndef SNI_OSTYPE
UNAME= $(shell uname -s)
ifeq ($(UNAME), IRIX)
  SNI_OSTYPE= irix
  OSFLAGS= -D_IRIX
endif
ifeq ($(UNAME), Linux)
  SNI_OSTYPE= linux
  OSFLAGS= -D_LINUX
endif
ifeq ($(UNAME), OpenBSD)
  SNI_OSTYPE= openbsd
  OSFLAGS= -D_OPENBSD
endif
ifeq ($(UNAME), FreeBSD)
  SNI_OSTYPE= freebsd
  OSFLAGS= -D_FREEBSD
endif
ifeq ($(UNAME), BSD/OS)
  SNI_OSTYPE= bsdi
  OSFLAGS= -D_BSDI
endif
ifeq ($(UNAME), SunOS)
  SNI_OSTYPE= sunos5
  OSFLAGS= -D_SUNOS5
endif

# XXX this can go away, as it is only for OLD b18 
ifeq ($(UNAME), CYGWIN32/NT)
  SNI_OSTYPE= win32
  OSFLAGS= -D_WIN32
endif

ifeq ($(UNAME), CYGWIN32_NT)
  SNI_OSTYPE= win32
  OSFLAGS= -D_WIN32
  INCLUDE_PATH+= -I/usr/local/include
endif
endif

# if $(SNI_OSTYPE) is still undefined, its an unsupported platform
# try to be useful by setting an obviously bogus value
ifndef SNI_OSTYPE
SNI_OSTYPE= ---unknown-os-type-$(UNAME)---
endif


# choose appropriate settings for the ostype
STATIC= -static
SUFFIX=
CPPCMD=	cpp -
CC= gcc

ifeq ($(SNI_OSTYPE), sunos5)
    STATIC=
    LIBS+= /usr/lib/libsocket.a /usr/lib/libnsl.a /usr/lib/libintl.a -ldl
    LEX= flex
    YACC= byacc
endif

ifeq ($(SNI_OSTYPE), win32)
    SUFFIX= .exe
    LIBS+= -ladvapi32
    # XXX - we should provide our own cpp
    YACC= byacc
    LN= cp

    LIBS:= -L$(SNI_BASEDIR)/lib -L/usr/local/sni/lib $(LIBS) -lresolv
    INCLUDE_PATH+= -I$(SNI_BASEDIR)/include -I/usr/local/sni/include
endif

