#ifndef _SENDIP_RIP_H
#define _SENDIP_RIP_H

enum ripOptionsEnum
{
	version=1,
	command=2,
	addressFamily=4,
	routeTag=8,
	address=16,
	subnetMask=32,
	nextHop=64,
	metric=128
};

struct rip_options
{
	uint32_t address;
	uint32_t subnetMask;
	uint32_t nextHop;
	uint32_t metric;

	uint8_t version;
	uint8_t command;
	uint16_t addressFamily;
	uint16_t routeTagOrAuthenticationType; /* routeTag unless performing authentication */
	char password[16];
	unsigned char authenticate; /* 0x0 for no, 0x1 for yes */
	unsigned char whichFieldsSpecified; /* & with ripOptionsMenu */
};



#endif
