/* 
 * $smu-mark$ 
 * $name: getifname.c$ 
 * $author: Salvatore Sanfilippo <antirez@invece.org>$ 
 * $copyright: Copyright (C) 1999 by Salvatore Sanfilippo$ 
 * $license: This software is under GPL version 2 of license$ 
 * $date: Fri Nov  5 11:55:47 MET 1999$ 
 * $rev: 8$ 
 */ 

#include <stdio.h>		/* perror */
#include <string.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>		/* struct sockaddr_in */
#include <arpa/inet.h>		/* inet_ntoa */
#include <net/if.h>
#include <unistd.h>		/* close */

#include "hping2.h"
#include "globals.h"

int get_if_name(void)
{
	int fd;
	struct ifconf	ifc;
	struct ifreq	ibuf[16],
			ifr,
			*ifrp,
			*ifend;
	struct sockaddr_in sa;

	if ( (fd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
		perror("[get_if_name] socket(AF_INET, SOCK_DGRAM, 0)");
		return -1;
	}

	bzero((void*)ibuf, sizeof(struct ifreq)*16);
	ifc.ifc_len = sizeof ibuf;
	ifc.ifc_buf = (caddr_t) ibuf;

	/* gets interfaces list */
	if ( ioctl(fd, SIOCGIFCONF, (char*)&ifc) == -1 ||
	     ifc.ifc_len < sizeof(struct ifreq)		) {
		perror("[get_if_name] ioctl(SIOCGIFCONF)");
		close(fd);
		return -1;
	}

	/* ifrp points to buffer and ifend points to buffer's end */
	ifrp = ibuf;
	ifend = (struct ifreq*) ((char*)ibuf + ifc.ifc_len);

	for (; ifrp < ifend; ifrp++) {
		strncpy(ifr.ifr_name, ifrp->ifr_name, sizeof(ifr.ifr_name));

		if ( ioctl(fd, SIOCGIFFLAGS, (char*)&ifr) == -1) {
/*
			if (opt_debug)
				perror("[get_if_name] ioctl(SIOCGIFFLAGS)");
*/
			continue;
		}

		if (opt_debug)
			printf("if %s: ", ifr.ifr_name);

		if ( !(ifr.ifr_flags & IFF_UP) )	/* if down */
		{
			if (opt_debug)
				printf("DOWN\n");
			continue;
		}

		if (ifr.ifr_flags & IFF_LOOPBACK)	/* if loopback */
		{
			if (opt_debug)
				printf("LOOPBACK, SKIPPED\n");
			continue;
		}

		if ( ifname[0] != '\0' && !strstr(ifr.ifr_name, ifname))
		{
			if (opt_debug)
				printf("DONT MATCH (but seems to be UP)\n");
			continue;
		}

		if (opt_debug)
			printf("OK\n");

		/* interface found, save if name */
		strncpy(ifname, ifr.ifr_name, 1024);

		/* get if address */
		if ( ioctl(fd, SIOCGIFADDR, (char*)&ifr) == -1) {
			perror("[get_if_name] ioctl(SIOCGIFADDR)");
			exit(1);
		}

		/* save if address */
		memcpy(&sa, &ifr.ifr_ifru.ifru_addr,
			sizeof(struct sockaddr_in));
		strncpy(ifstraddr, inet_ntoa(sa.sin_addr), 1024);

#if (defined OSTYPE_LINUX)
		/* get if mtu */
		if ( ioctl(fd, SIOCGIFMTU, (char*)&ifr) == 1) {
			perror("Warning: [get_if_name] ioctl(SIOCGIFMTU)");
			printf("using default MTU: 1500\n");
			h_if_mtu = 1500;
		}
		else
		{
			h_if_mtu = ifr.ifr_mtu;
		}
#else
		h_if_mtu = 1500; /* FIXME: very stupid */
#endif /* OSTYPE_LINUX */

		close(fd);
		return 0;
	}
	/* interface not found, use 'lo' */
	strncpy(ifname, "lo", 1024);
	strncpy(ifstraddr, "127.0.0.1", 1024);
	h_if_mtu = 1500;
	close(fd);
	return 0;
}
