/*
    udp.c: Fills the udp header in the packet.
    Copyright (C) 1999 by Marcelo Gornstein

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    see "COPYING" file for details.

If you want to contact me:
Marcelo Gornstein
mgornstein@usa.net
*/
#include <sys/types.h>
#include <sys/socket.h>
#include "definitions.h"

void send_udp (struct PACKET p)
{
#if COMPILE_UDP
struct PSEUDO_HEADER *pseudo;
unsigned char buffer [p.bufflen];

p.data = buffer;
p.iph = (struct iphdr *) (p.data);
p.udph = (struct udphdr *) (p.data + IPLEN);
pseudo = (struct PSEUDO_HEADER *) (p.data + 
				IPLEN - sizeof (struct PSEUDO_HEADER));
memset (p.data, '\0', p.bufflen);

fill_pseudo (pseudo, p);

p.udph->source = htons (p.src_port);
p.udph->dest = htons (p.dst_port);
printf ("UDP Checksum: %d\n", p.udph->check = in_cksum (pseudo, 
						sizeof (struct PSEUDO_HEADER) + 
						UDPLEN));
fill_ip (p);
send_packet (p, IPLEN + UDPLEN);

#endif
}
