/*
    tcp.c: fills the tcp part of the packet.
    Copyright (C) 1999 by Marcelo Gornstein

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    see "COPYING" file for details.

If you want to contact me:
Marcelo Gornstein
mgornstein@usa.net
*/
#include <sys/types.h>
#include <sys/socket.h>
#include "definitions.h"

void send_tcp (struct PACKET p)
{
#if COMPILE_TCP
struct PSEUDO_HEADER *pseudo;
unsigned char buffer [p.bufflen];

p.data = buffer;
p.iph = (struct iphdr *) (p.data);
p.tcph = (struct tcphdr *) (p.data + IPLEN);
pseudo = (struct PSEUDO_HEADER *) (p.data + 
				IPLEN - sizeof (struct PSEUDO_HEADER));
memset (p.data, '\0', p.bufflen);

fill_pseudo (pseudo, p);

p.tcph->source = htons (p.src_port);
p.tcph->dest = htons (p.dst_port);
p.tcph->seq = p.seq;
p.tcph->ack_seq = htonl (p.ack_seq);
p.tcph->window = htons (p.window);
p.tcph->syn = p.syn;
p.tcph->fin = p.fin;
p.tcph->rst = p.rst;
p.tcph->ack = p.ack;
p.tcph->psh = p.psh;
p.tcph->urg = p.urg;
printf ("TCP Checksum: %d\n", p.tcph->check = in_cksum (pseudo, 
						sizeof (struct PSEUDO_HEADER) + 
						TCPLEN));
printf ("Window size: %d\n", p.window);
printf ("Sending flags: ");
if (p.syn) printf ("syn ");
if (p.fin) printf ("fin ");
if (p.urg) printf ("urg ");
if (p.psh) printf ("psh ");
if (p.ack) printf ("ack ");
if (p.rst) printf ("rst ");
printf ("\n");

fill_ip (p);
send_packet (p, IPLEN + TCPLEN);

#endif
}
