/*
    main.c: main part of Send Packet.
    Copyright (C) 1999 by Marcelo Gornstein

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    see "COPYING" file for details.

If you want to contact me:
Marcelo Gornstein
mgornstein@usa.net
*/

#include <stdio.h>
#include <unistd.h>
#include <netdb.h>
#include "../config.h"
#include "definitions.h"

struct PACKET packet;
int i = 0;
char sendfile = 0;

void show_help (void);
void load_defaults (void);
void init_all (void);
void fill_info (struct PACKET *p);
void show_info (void);
int main (int argc, char *argv []);
void sexit (void);

void show_help (void)
{
printf ("%s\n", COPYRIGHT);
printf ("Version: %s.%s\n", MAJOR_VERSION, MINOR_VERSION);
printf ("sendpacket <-h> <-size n> <-src ip> <-dst ip> <-sprt port> <-dprt port> <-sname hostname> <-dname hostname> <-proto p>\n");
}

void load_defaults (void)
{
if (!packet.bufflen) packet.bufflen = MAX_PACK_SIZE;
if (packet.src_host.host_ip[0] == 0) 
	strcpy (packet.src_host.host_ip, DEFAULT_SRC_HOST);
if (packet.dst_host.host_ip[0] == 0)
	strcpy (packet.dst_host.host_ip, DEFAULT_DST_HOST);
if (packet.ttl == 0) packet.ttl = DEFAULT_PACK_TTL;
if (packet.proto[0] == 0) strcpy (packet.proto, DEFAULT_PROTO);
if (packet.file[0] == 0) strcpy (packet.file, DEFAULT_DATA);

#if COMPILE_TCP
if (packet.seq == 0) packet.seq = DEFAULT_INIT_SEQNUM;
if (packet.ack_seq == 0) packet.ack_seq = DEFAULT_INIT_ACKSEQNUM;
if (packet.window == 0) packet.window = DEFAULT_WINDOW_SIZE;
if (packet.syn == 0) packet.syn = SEND_SYN_FLAG;
if (packet.ack == 0) packet.ack = SEND_ACK_FLAG;
if (packet.psh == 0) packet.psh = SEND_PSH_FLAG;
if (packet.urg == 0) packet.urg = SEND_URG_FLAG;
if (packet.rst == 0) packet.rst = SEND_RST_FLAG;
if (packet.fin == 0) packet.fin = SEND_FIN_FLAG;
#endif

#if (COMPILE_TCP | COMPILE_UDP)
if (!packet.dst_port) packet.dst_port = DEFAULT_DST_PORT;
if (!packet.src_port) packet.src_port = DEFAULT_SRC_PORT;
#endif

#if COMPILE_ICMP
if (packet.msg == 1) packet.msg = DEFAULT_ICMP_MSG;
if (packet.code == 13) packet.code = DEFAULT_ICMP_CODE;
if (packet.host.s_addr == 0) inet_aton (DEFAULT_ICMP_IP, &packet.host);
if (packet.to.s_addr == 0) inet_aton (DEFAULT_ICMP_IPTO, &packet.to);
#endif

#if SEND_DATA_FILE
sendfile++;
#endif
}

void init_all (void)
{
memset (&packet, '\0', sizeof (struct PACKET));
packet.msg = 1;
packet.code = 13;
}

void fill_info (struct PACKET *p)
{
struct hostent *h;
inet_aton (p->src_host.host_ip, &p->src_host.naddr);
inet_aton (p->dst_host.host_ip, &p->dst_host.naddr);

if (p->src_host.host_name[0] != 0)
	{
	h = (struct hostent *) (gethostbyname(p->src_host.host_name));
	if (!h) { herror ("Couldn't find source IP address"); exit (-1); }
	memcpy ((void *) (&p->src_host.naddr), (void *) h->h_addr, sizeof (struct in_addr));
	strcpy (p->src_host.host_ip, (char *) inet_ntoa (p->src_host.naddr.s_addr));
	} else {
		h = gethostbyaddr ((char *)(&p->src_host.naddr), 
						sizeof (struct in_addr), 
						AF_INET);
		if (!h) strcpy (p->src_host.host_name, "N/A");
			else strcpy (p->src_host.host_name, h->h_name);
		}

if (p->dst_host.host_name[0] != 0)
	{
	h = (struct hostent *) (gethostbyname(p->dst_host.host_name));
	if (!h) { herror ("Couldn't find target IP address"); exit (-1); }
	memcpy ((void *) (&p->dst_host.naddr), (void *) h->h_addr, sizeof (struct in_addr));
	strcpy (p->dst_host.host_ip, (char *) inet_ntoa (p->dst_host.naddr.s_addr));
	} else {
		h = gethostbyaddr ((char *)(&p->dst_host.naddr), 
						sizeof (struct in_addr), 
						AF_INET);
		if (!h) strcpy (p->dst_host.host_name, "N/A");
			else strcpy (p->dst_host.host_name, h->h_name);
		}

}

void show_info (void)
{
printf ("Using packet size: %d\n", packet.bufflen);
printf ("Source IP address: %s <%s>\n", packet.src_host.host_ip,
					packet.src_host.host_name);
printf ("Target IP address: %s <%s>\n", packet.dst_host.host_ip,
					packet.dst_host.host_name);
printf ("Using protocol %s\n", packet.proto);
printf ("ttl: %d\n", packet.ttl);
#if (COMPILE_UDP | COMPILE_TCP)
if (strncmp (packet.proto, "icmp", 4))
{ 
printf ("Source port: %d\n", packet.src_port);
printf ("Destiny port: %d\n", packet.dst_port);
} 
#endif

#if COMPILE_TCP
if (!strncmp (packet.proto, "tcp",3))
{
printf ("Init seq number: %d\n", packet.seq);
printf ("Init ack seq number: %d\n", packet.ack_seq);
}
#endif

#if COMPILE_ICMP
if (!strncmp (packet.proto, "icmp",4))
{
if (packet.msg == ICMP_ECHO) printf ("Sending echo request\n");
if (packet.msg == ICMP_ECHOREPLY) printf ("Sending echo reply\n");
if (packet.msg == ICMP_DEST_UNREACH) {
	printf ("Sending destination unreacheable: ");
	if (packet.code == 0) printf ("Network unreachable\n");
	if (packet.code == 1) printf ("Host unreachable\n");
	if (packet.code == 2) printf ("Protocol unreachable\n");
	if (packet.code == 3) printf ("Port unreachable\n");
	if (packet.code == 4) printf ("Fragmentation needed\n");
	if (packet.code == 5) printf ("Source route failed\n");
	if (packet.code == 6) printf ("Network unknown\n");
	if (packet.code == 7) printf ("Host unknown\n");
	if (packet.code == 8) printf ("Host isolated\n");
	if (packet.code == 9) printf ("Target network communication forbidden\n");
	if (packet.code == 10) printf ("Target host communication forbidden\n");
	if (packet.code == 11) printf ("Target network unreachable by TOS\n");
	if (packet.code == 12) printf ("Target host unreachable by TOS\n");
					}
if (packet.msg == ICMP_SOURCE_QUENCH) printf ("Sending source quench\n");
if (packet.msg == ICMP_REDIRECT) {
	printf ("Sending icmp redirect %s ", inet_ntoa (packet.host));
	if (packet.code == 0) printf ("net to\n");
	if (packet.code == 1) printf ("host to\n");
	if (packet.code == 2) printf ("net TOS to\n");
	if (packet.code == 3) printf ("host TOS to\n");
					}
if (packet.msg == ICMP_TIME_EXCEEDED) {
	printf ("Sending time exceeded ");
	if (packet.code == 0) printf ("TTL exceeded\n");
	if (packet.code == 1) printf ("Fragment reassembly time exceeded\n");
					}
if (packet.msg == ICMP_PARAMETERPROB) printf ("Sending parameter problem\n");
if (packet.msg == ICMP_TIMESTAMP) printf ("Sending timestamp request\n");
if (packet.msg == ICMP_TIMESTAMPREPLY) printf ("Sending timestamp reply\n");
if (packet.msg == ICMP_INFO_REQUEST) printf ("Sending information request\n");
if (packet.msg == ICMP_INFO_REPLY) printf ("Sending information reply\n");
if (packet.msg == ICMP_ADDRESS) printf ("Sending netmask request\n");
if (packet.msg == ICMP_ADDRESSREPLY) printf ("Sending netmask reply\n");
printf ("Target host/network: %s\n", inet_ntoa (packet.to));
}
#endif

}

int main (int argc, char *argv [])
{
init_all ();
if (argc >= 2)
	{

	for (i = 1; i <= (argc - 1); i++)
	{
	if (!strcmp (argv [i], "-h")) { show_help (); exit (0); }
	if (!strncmp (argv [i], "-size", 5)) packet.bufflen = atoi (argv [i+1]);
	if (!strncmp (argv [i], "-file", 5)) strcpy (packet.file, argv [i+1]);
	if (!strncmp (argv [i], "-src", 4)) strcpy (packet.src_host.host_ip, argv [i+1]);
	if (!strncmp (argv [i], "-dst", 4)) strcpy (packet.dst_host.host_ip, argv [i+1]);
	if (!strncmp (argv [i], "-sname", 6)) strcpy (packet.src_host.host_name, argv [i+1]);
	if (!strncmp (argv [i], "-dname", 6)) strcpy (packet.dst_host.host_name, argv [i+1]);
	if (!strncmp (argv [i], "-ttl", 4)) packet.ttl = atoi (argv [i+1]);
	if (!strncmp (argv [i], "-proto", 6)) strcpy (packet.proto, argv [i+1]);

	#if (COMPILE_TCP | COMPILE_UDP)
	if (!strncmp (argv [i], "-sprt", 5)) packet.src_port = atoi (argv[i+1]);
	if (!strncmp (argv [i], "-dprt", 5)) packet.dst_port = atoi (argv[i+1]);
	#endif

	#if COMPILE_ICMP
	if (!strncmp (argv [i], "-code", 5)) packet.code = atoi (argv [i+1]);
	if (!strncmp (argv [i], "-to", 4)) inet_aton (argv [i + 1], &packet.to);
	if (!strncmp (argv [i], "-host", 3)) inet_aton (argv [i + 1], &packet.host);
	if (!strncmp (argv [i], "-sendfile", 9)) sendfile++;
	if (!strncmp (argv [i], "-msg", 4)) {
	if (!strcmp (argv [i+1], "echo")) packet.msg = ICMP_ECHO;
	if (!strcmp (argv [i+1], "echoreply")) packet.msg = ICMP_ECHOREPLY;
	if (!strcmp (argv [i+1], "destunreach")) packet.msg = ICMP_DEST_UNREACH;
	if (!strcmp (argv [i+1], "srcquench")) packet.msg = ICMP_SOURCE_QUENCH;
	if (!strcmp (argv [i+1], "redirect")) packet.msg = ICMP_REDIRECT;
	if (!strcmp (argv [i+1], "timexceeded")) packet.msg = ICMP_TIME_EXCEEDED;
	if (!strcmp (argv [i+1], "parameterprob")) packet.msg = ICMP_PARAMETERPROB;
	if (!strcmp (argv [i+1], "timestamp")) packet.msg = ICMP_TIMESTAMP;
	if (!strcmp (argv [i+1], "timestampreply")) packet.msg = ICMP_TIMESTAMPREPLY;
	if (!strcmp (argv [i+1], "inforequest")) packet.msg = ICMP_INFO_REQUEST;
	if (!strcmp (argv [i+1], "inforeply")) packet.msg = ICMP_INFO_REPLY;
	if (!strcmp (argv [i+1], "address")) packet.msg = ICMP_ADDRESS;
	if (!strcmp (argv [i+1], "addressreply")) packet.msg = ICMP_ADDRESSREPLY;
				}
	#endif
	
	#if COMPILE_TCP
	if (!strncmp (argv [i], "-seq", 4)) packet.seq = atoi (argv [i+1]);
	if (!strncmp (argv [i], "-ack", 4)) packet.ack_seq = atoi (argv [i+1]);
	if (!strncmp (argv [i], "-w", 2)) packet.window = atoi (argv[i+1]);
	if (!strncmp (argv [i], "-f", 2)) {
		if (!strncmp (argv [i+1], "ack", 3)) packet.ack = 1;
		if (!strncmp (argv [i+1], "rst", 3)) packet.rst = 1;
		if (!strncmp (argv [i+1], "fin", 3)) packet.fin = 1;
		if (!strncmp (argv [i+1], "syn", 3)) packet.syn = 1;
		if (!strncmp (argv [i+1], "psh", 3)) packet.psh = 1;
		if (!strncmp (argv [i+1], "urg", 3)) packet.urg = 1;
					  }	
	#endif
	}

	}
load_defaults ();
fill_info (&packet);
printf ("%s\n", COPYRIGHT);
printf ("Version: %s.%s\n", MAJOR_VERSION, MINOR_VERSION);
show_info ();

#if COMPILE_TCP
	if (!strncmp (packet.proto, "tcp", 3)) send_tcp (packet);
#endif

#if COMPILE_UDP
	if (!strncmp (packet.proto, "udp", 3)) send_udp (packet); 
#endif

#if COMPILE_ICMP
	if (!strncmp (packet.proto, "icmp", 4)) send_icmp (packet);
#endif

exit (0);
}

void sexit (void)
{
perror ("Error!");
exit (-1);
}
