/*
    icmp.c: fills the icmp part of the packet.
    Copyright (C) 1999 by Marcelo Gornstein

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    see "COPYING" file for details.

If you want to contact me:
Marcelo Gornstein
mgornstein@usa.net
*/
#include <sys/types.h>
#include <sys/socket.h>
#include "definitions.h"

void send_icmp (struct PACKET p)
{
#if COMPILE_ICMP
struct PSEUDO_HEADER *pseudo;
struct iphdr *ip;
struct tcphdr *tcp;
unsigned char buffer [p.bufflen];

p.data = buffer;
p.iph = (struct iphdr *) (p.data);
p.icmph = (struct icmphdr *) (p.data + IPLEN);
pseudo = (struct PSEUDO_HEADER *) (p.data + 
				IPLEN - sizeof (struct PSEUDO_HEADER));
ip = (struct iphdr *) (p.data + IPLEN + ICMPLEN);
tcp = (struct tcphdr *) (p.data + IPLEN + ICMPLEN + IPLEN);
memset (p.data, '\0', p.bufflen);

fill_pseudo (pseudo, p);
p.icmph->type = p.msg;

ip->version = 4;
ip->ihl = 5;
ip->ttl = p.ttl;
ip->tos = 0;
ip->tot_len = htons (IPLEN + TCPLEN);
ip->protocol = 6;
ip->id = random () % 1996;
ip->saddr = p.to.s_addr;
ip->daddr = p.host.s_addr;
ip->check = in_cksum (ip, IPLEN);
tcp->source = htons (p.src_port);
tcp->dest = htons (p.dst_port);
tcp->check = in_cksum (pseudo, sizeof (struct PSEUDO_HEADER) + TCPLEN);
p.icmph->code = p.code;

if ((p.icmph->type == ICMP_ECHO) || (p.icmph->type == ICMP_ECHOREPLY))
{
p.icmph->un.echo.id = getpid ();
p.icmph->un.echo.sequence = 0;
p.icmph->code = 0;
}

if (p.icmph->type == ICMP_REDIRECT) p.icmph->un.gateway = p.to.s_addr;

if (p.icmph->type == ICMP_ADDRESSREPLY) 
{
p.icmph->un.echo.id = getpid ();
p.icmph->un.echo.sequence = 0;
p.icmph->code = 0;
p.icmph->un.gateway = p.to.s_addr;
}

if ((p.icmph->type == ICMP_TIMESTAMP) || (p.icmph->type == ICMP_TIMESTAMPREPLY))
{
p.icmph->un.echo.id = getpid ();
p.icmph->un.echo.sequence = 0;
p.icmph->code = 0;
}

printf ("ICMP Checksum: %d\n", p.icmph->checksum = in_cksum (pseudo, 
						sizeof (struct PSEUDO_HEADER) + 
						ICMPLEN));
fill_ip (p);
send_packet (p, IPLEN + ICMPLEN);

#endif
}
