# -sam k (commport5@lucidx.com)

# usable colors:
# CLEAR RESET BOLD UNDERLINE UNDERSCORE BLINK REVERSE CONCEALED BLACK RED GREEN YELLOW BLUE
# MAGENTA CYAN WHITE ON_BLACK ON_RED ON_GREEN ON_YELLOW ON_BLUE ON_MAGENTA ON_CYAN ON_WHITE

%attributes = (
 'clear'      => 0,
 'reset'      => 0,
 'bold'       => 1,
 'dark'       => 2,
 'underline'  => 4,
 'underscore' => 4,
 'blink'      => 5,
 'reverse'    => 7,
 'concealed'  => 8,
 'black'      => 30,
 'red'        => 31,
 'green'      => 32,
 'yellow'     => 33,
 'blue'       => 34,
 'magenta'    => 35,
 'cyan'       => 36,
 'white'      => 37,
 'on_black'   => 40,
 'on_red'     => 41,
 'on_green'   => 42,
 'on_yellow'  => 43,
 'on_blue'    => 44,
 'on_magenta' => 45,
 'on_cyan'    => 46,
 'on_white'   => 47,
);

sub color {
 my @codes = map { split } @_;
 my $attribute = '';
 foreach (@codes) {
  $_ = lc $_;
  $attribute .= $attributes{$_} . ';';
 }
 chop $attribute;
 ($attribute ne '') ? "\e[${attribute}m" : undef;
}

sub colored {
 my ($strng, @codes);
 if (ref $_[0]) {
  @codes = @{+shift};
  $strng = join ('', @_);
 }
 else {
  $strng = shift;
  @codes = @_;
 }
 &color (@codes) . $strng . "\e[0m";
}

1;
