#
#
#	Options
#
#		-size n
#		-fullselect bool
#		-highlight bool
#		-highlightbg color
#		-highlightcmd command			<cmd> option
#
#		-needcombo command				<cmd> option -> 0/1
#		-fillcombo command				<cmd> option comboWidget 
#		-needbutton command				<cmd> option -> "" or callback
#
#		-beforecmd command				<cmd> option value -> value (to display)
#		-command command				<cmd> option value -> value (to display)
#		-aftercmd command				<cmd>
#
#		-handlevar bool
#		-handlevarcmd command			<cmd> mode(set/unset) option value
#
#		-tip cmd						<cmd> option tag (help|value)
#
#
#	Commands
#
#		table::new <pathname> ?options?
#		table::add:editable <pathname> text option tag ?value 0? ?pos end?
#		table::add:noeditable <pathname> text option tag ?pos end?
#		table::add:message <pathname> text tag ?pos end?
#		table::remove <pathname> option
#		table::editsize <pathname>
#

namespace eval table {
}


proc table::new {w args} {
variable $w.f
upvar 0 $w.f data


	# parse options
	set data(v:size) 20
	set data(v:fullselect) 0
	set data(v:highlight) 0
	set data(v:handlevar) 0
	set bg salmon
	set fg blue
	foreach {opt value} $args {
		if {$opt == "-size"} {
			set data(v:size) $value
		} elseif {$opt == "-messagecolor"} {
			set fg $value
		} elseif {$opt == "-highlightcmd"} {
			set data(v:cb:highlight) $value
		} elseif {$opt == "-highlightbg"} {
			set bg $value
		} elseif {$opt == "-highlight"} {
			set data(v:highlight) $value
		} elseif {$opt == "-needcombo"} {
			set data(v:cb:needcombo) $value
		} elseif {$opt == "-fillcombo"} {
			set data(v:cb:fillcombo) $value
		} elseif {$opt == "-needbutton"} {
			set data(v:cb:needbutton) $value
		} elseif {$opt == "-beforecmd"} {
			set data(v:cb:before) $value
		} elseif {$opt == "-command"} {
			set data(v:cb:command) $value
		} elseif {$opt == "-aftercmd"} {
			set data(v:cb:after) $value
		} elseif {$opt == "-handlevar"} {
			set data(v:handlevar) $value
		} elseif {$opt == "-handlevarcmd"} {
			set data(v:cb:handlevar) $value
		} elseif {$opt == "-fullselect"} {
			set data(v:fullselect) $value
		} elseif {$opt == "-tip"} {
			set data(v:cb:tip) $value
		}
	}

	# main frame
	set f [frame $w.f]

	# the display of the mapper
	set sb_disp [scrollbar $f.sbdisp -bd 1 -orient vertical -highlightthickness 0 -takefocus 0 -width 8]
    $sb_disp configure -command "$f.text yview"

	set data(w:text) [text $f.text -bd 1 -relief sunken -yscrollcommand "$sb_disp set" \
			-height 10 -font fixed -cursor {} \
			-insertofftime 1000000000 -insertontime 0 \
			-selectbackground lightskyblue -selectborderwidth 0 -highlightthickness 0]
	  bindtags $data(w:text) "$f.text Table $f all"
	  if {[info exists data(v:cb:tip)]} {
		  bind Table <Motion> "table::tip $f %x %y %X %Y"
		  bind Table <Leave> "table::tip:cancel $f"
	  }
	  $f.text tag configure highlight -background $bg
	  $f.text tag configure message -foreground $fg

	# the combo box for edition
	set combo [toplevel $f.combo]
	  wm overrideredirect $combo 1
	  wm withdraw $combo

	  set data(w:combo) [text $combo.t -bd 1 -width 42 -height 10 -font fixed \
			-takefocus 0 -wrap none -bg gray92]
	  bindtags $combo.t "$combo.t . all"
	  $combo.t tag configure highlight -background lightskyblue
	  bind $combo.t <Motion> "table::edit:combo:scroll $f Motion %x %y"
	  bind $combo.t <1> {
			set tmp [%W get "@%x,%y linestart" "@%x,%y lineend"]
			set __edit([winfo parent %W]) [lindex $tmp 0]
	  }
	  pack $combo.t


	# layout
	grid $sb_disp	$data(w:text)	-sticky news
	#grid configure $sb_disp -pady 1
	grid rowconfigure $f {0} -weight 1
	grid columnconfigure $f {0} -weight 0
	grid columnconfigure $f {1} -weight 1

	# some init
	set data(v:edit:inprogress) 0
	set data(v:noeditable) {}
	set data(v:message) {}
	set data(t:tip) -1
	set data(v:usetip) 1

	# return new widget
	return $f
}

#---------------------------------------------------------------------------------------

bind Table <1> "table::highlight %W %y"
bind Table <1> "+table::edit:check %W %x %y"
bind Table <Configure> "table::setDisplaySize %W %w"


#=======================================================================================


proc table::add:message {w text tag {pos end}} {
variable $w
upvar 0 $w data

	if {$pos == "end"} {
		set pos [expr int([$data(w:text) index "end linestart - 1 line"])]
	}
	$data(w:text) insert "$pos.0" "$text\n"
	$data(w:text) tag add message "$pos.0" "$pos.end"
	lappend data(v:noeditable) $pos.0
	lappend data(v:message) $pos.0
}

#---------------------------------------------------------------------------------------

proc table::add:editable {w text option tag {value 0} {pos end}} {
variable $w
upvar 0 $w data


	if {$pos == "end"} {
		set pos [expr int([$data(w:text) index "end linestart - 1 line"])]
	}
	set data(tag:$pos.0) $tag
	set data(option:$pos.0) $option
	$data(w:text) insert "$pos.0" "[format %-$data(v:size)s $text]$value\n"
}

#---------------------------------------------------------------------------------------

proc table::add:noeditable {w text option tag {pos end}} {
variable $w
upvar 0 $w data

	if {$pos == "end"} {
		set pos [expr int([$data(w:text) index "end linestart - 1 line"])]
	}
	set data(tag:$pos.0) $tag
	set data(option:$pos.0) $option
	$data(w:text) insert "$pos.0" "[format %-$data(v:size)s $text]\n"
	lappend data(v:noeditable) $pos.0
}

#---------------------------------------------------------------------------------------

proc table::clear {w} {
variable $w
upvar 0 $w data


	$data(w:text) delete 0.0 end
	foreach n [array names data tag:*] {
		unset data($n)
	}
	foreach n [array names data option:*] {
		unset data($n)
	}
}

#---------------------------------------------------------------------------------------

proc table::remove {w option} {
variable $w
upvar 0 $w data

	set index [$data(w:text) search -exact -- "$option " 1.0]
	if {$index == {}} {
		return -code error "option '$option' not used in table"
	}
	$data(w:text) delete "$index linestart" "$index lineend"
}

#---------------------------------------------------------------------------------------

proc table::editsize {w} {
variable $w
upvar 0 $w data

	return $data(v:editsize)
}

#=======================================================================================


proc table::setDisplaySize {w width} {
set w [winfo parent $w]
variable $w
upvar 0 $w data


	set char [expr int($width/6.15)-$data(v:size)]
	set data(v:editsize) $char
	$data(w:combo) configure -width $char
}

#---------------------------------------------------------------------------------------

proc table::highlight {w y} {
set w [winfo parent $w]
variable $w
upvar 0 $w data


	set index [$data(w:text) index "@0,$y"]
	set data(t:index) $index
	if {[lsearch -exact $data(v:message) $index] != -1} {
		# non editable line
#puts "non editable"
		$data(w:text) tag remove highlight 0.0 end
		set data(t:option) ""
		return
	}

	if {[catch {set data(t:option) $data(option:$index)}]} {
		return
	}

	if {$data(v:highlight)} {
		$data(w:text) tag remove highlight 0.0 end
		$data(w:text) tag add highlight $index "$index lineend"
	}
	# callback to do something
	if {[info exists data(v:cb:highlight)]} {
		uplevel #0 $data(v:cb:highlight) $data(t:option) $data(tag:$index)
	}
}


#=======================================================================================


proc table::edit:check {w x y} {
set w [winfo parent $w]
variable $w
upvar 0 $w data
global __edit


	set data(t:x) $x
	set data(t:y) $y

	if {$data(t:option) == "\n" 
			|| [lsearch -exact $data(v:noeditable) $data(t:index)] != -1} {
		return
	}

	# check if not already in edition
	if {$data(v:edit:inprogress)} {
		edit:cancel $w
		set data(v:edit:inprogress) 0
	}
	# check if we want to edit or view
	if {!$data(v:fullselect) && \
				[$data(w:text) compare [$data(w:text) index "@$x,$y"] \
				< [$data(w:text) index "@$x,$y linestart+$data(v:size)c"]]} {
		return
	}

	# do edition
	set data(v:edit:inprogress) 1
	tip:setmode $w off
	uplevel #0 "set __typed($w) 0"
	# create entry widget
	destroy $data(w:text).e
	entry $data(w:text).e -width $data(v:editsize) -bd 0 -highlightthickness 0 \
			-selectbackground lightskyblue -selectborderwidth 0 \
			-bg gray92 -font fixed -textvariable __edit($w)
	bind $data(w:text).e <Return> "table::edit:doIt $w"
	bind $data(w:text).e <Escape> "table::edit:cancel $w"
    bind $data(w:combo) <ButtonRelease-1> "table::edit:doIt $w"
	bind $data(w:text).e <Key> "set __typed($w) 1"
	bind $data(w:text).e <Up> "table::edit:combo:scroll $w %K 0 0"
	bind $data(w:text).e <Down> "table::edit:combo:scroll $w %K 0 0"
	bind $data(w:text).e <Prior> "table::edit:combo:scroll $w %K 0 0"
	bind $data(w:text).e <Next> "table::edit:combo:scroll $w %K 0 0"
	bind $data(w:text).e <Map> "grab set $w"
	bind $data(w:text).e <Destroy> "grab release $w"
	# create button widget
	destroy $data(w:text).b
	button $data(w:text).b -bd 0 -highlightthickness 0 -relief flat -padx 0 -pady 0 -anchor nw

	# get the line edited
	set data(t:line) [expr int([$data(w:text) index "@$data(t:x),$data(t:y) linestart"])]	
	# get value
	set __edit($w) [$data(w:text) get $data(t:line).20 $data(t:line).end]
	set data(t:oldvalue) $__edit($w)

	# callback before switching to edit mode
	if {[info exists data(v:cb:before)]} {
		set char [$data(w:text) get "@$data(t:x),$data(t:y)" "@$data(t:x),$data(t:y)+1char"]
		set word [string trim [$data(w:text) get "@$data(t:x),$data(t:y) wordstart-1char" \
											 "@$data(t:x),$data(t:y)+1char wordend"]]
		if {[string first $word {\n}] != -1} {
			set char ""
			set word ""
		}
		set result [uplevel #0 $data(v:cb:before) $data(t:option) [list $__edit($w)] \
							[list $char] [list $word]]
		if {$result != ""} {
			set data(v:edit:inprogress) 0
			tip:setmode $w on
			# update display
			$data(w:text) delete $data(t:line).20 $data(t:line).end
	        $data(w:text) insert $data(t:line).20 $result    
			# callback
			if {[info exists data(v:cb:after)]} {
				uplevel #0 $data(v:cb:after)
			}
			# rehighlight item
			highlight $data(w:text) $data(t:y)
			return
		}
	}

	# substitute it with entry widget
	set data(t:hascombo) 0
	set data(t:hasbutton) 0
	$data(w:text) delete $data(t:line).20 $data(t:line).end
	$data(w:text) window create $data(t:line).20 -window $data(w:text).e
	focus $data(w:text).e

	# check if combo list needed
	if {[info exists data(v:cb:needcombo)]} {
		set result [uplevel #0 $data(v:cb:needcombo) $data(t:option)]
		if {$result} {
			set data(t:hascombo) 1
			edit:combo:show $w
		}
	}
	# check if button needed
	if {[info exists data(v:cb:needbutton)]} {
		set result [uplevel #0 $data(v:cb:needbutton) $data(t:option)]
		if {$result != ""} {
			set data(t:hasbutton) 1
			set data(t:cb:compute) $result
			$data(w:text).b configure -command "table::edit:compute $w" -image imgCompute
			$data(w:text) delete $data(t:line).17 $data(t:line).20
			$data(w:text) window create $data(t:line).17 -window $data(w:text).b
		}
	}
}


proc table::edit:doIt {w} {
variable $w
upvar 0 $w data
global __edit __typed


	# if combo, then take current entry as selected value
	if {$data(t:hascombo) && !$__typed($w)} {
		set edit [$data(w:combo) get "$data(t:combo:line).0" "$data(t:combo:line).end"]
		set edit [lindex $edit 0]
		if {$edit != ""} {
			set __edit($w) $edit
		}
	}

	# check if we are referencing a variable
	if {$data(v:handlevar) && [string index $__edit($w) 0] == "\$"} {
#puts "<<table::edit:doIt>> SUBSTITUTION -- $__edit($w)"
		set isVar 1
		if {[info exists data(v:cb:handlevar)]} {
			uplevel #0 $data(v:cb:handlevar) set $data(t:option) [list $__edit($w)]
		}
		set value "[uplevel #0 [list subst $__edit($w)]]"
	} else {
		set isVar 0
		if {[info exists data(v:cb:handlevar)]} {
			uplevel #0 $data(v:cb:handlevar) unset $data(t:option) dummy
		}
		set value $__edit($w)
	}

	# callback for update
	if {[info exists data(v:cb:command)]} {
		if {[catch {set result [uplevel #0 $data(v:cb:command) $data(t:option) [list $value]]} msg]} {
#puts "<<table::edit:doIt>> ERROR -- $msg"
			set isVar 0
			set result $data(t:oldvalue)
		}
	}

	# remove combo
	wm withdraw $w.combo
	# set new value
#puts "<<table::edit:doIt>> isvar = $isVar"
	if {!$isVar} {
		set __edit($w) $result
	}
	if {$data(t:hasbutton)} {
		$data(w:text) delete $data(t:line).17 $data(t:line).end
		$data(w:text) insert $data(t:line).17 "   $__edit($w)"
	} else {
		$data(w:text) delete $data(t:line).20 $data(t:line).end
		$data(w:text) insert $data(t:line).20 "$__edit($w)"
	}

	# finished
	set data(v:edit:inprogress) 0
	tip:setmode $w on
	# callback
	if {[info exists data(v:cb:after)]} {
		uplevel #0 $data(v:cb:after)
	}
	# rehighlight item
	highlight $w.text $data(t:y)
}


proc table::edit:cancel {w} {
variable $w
upvar 0 $w data
global __edit


	# remove combo
	wm withdraw $w.combo
	# restore value
	if {$data(t:hasbutton)} {
		$data(w:text) delete $data(t:line).17 $data(t:line).end
		$data(w:text) insert $data(t:line).17 "   $data(t:oldvalue)"
	} else {
		$data(w:text) delete $data(t:line).20 $data(t:line).end
		$data(w:text) insert $data(t:line).20 "$data(t:oldvalue)"
	}
	# finished
	set data(v:edit:inprogress) 0
	tip:setmode $w on
	# rehighlight item
	highlight $w.text $data(t:y)
}

#---------------------------------------------------------------------------------------

proc table::edit:compute {w} {
variable $w
upvar 0 $w data
global __edit

	set __edit($w) [uplevel #0 $data(t:cb:compute)]
	edit:doIt $w
}

#---------------------------------------------------------------------------------------

proc table::edit:combo:show {w} {
variable $w
upvar 0 $w data
global __edit


	# populate it
	$data(w:combo) delete 1.0 end
	if {![info exists data(v:cb:fillcombo)]} {
		return -code error "need callback procedure to fill the combo"
	}
	uplevel #0 $data(v:cb:fillcombo) $data(t:option) $data(w:combo)
	$data(w:combo) delete "end-1c" "end"
	# show it
	set bbox [$data(w:text) bbox $data(t:line).20]
	set X [expr [lindex $bbox 0]-2+[winfo rootx $data(w:text)]]
	set Y [expr [lindex $bbox 1]+2+[lindex $bbox 3]+[winfo rooty $data(w:text)]]
	wm geometry $w.combo +$X+$Y
	wm deiconify $w.combo
	raise $w.combo
	# binding for automasking
	bind $data(w:text).e <FocusIn> "wm deiconify $w.combo"
	bind $data(w:text).e <FocusOut> "wm withdraw $w.combo"
	# some init
	set index [$data(w:combo) search -regexp -- "^$__edit($w)\[ \\t\]" 1.0]
#puts "<<table::edit:combo:show>> searching $__edit($w) @ $index"
	if {$index != ""} {
		set data(t:combo:line) [expr int([$data(w:combo) index "$index+1c linestart"])]
		$data(w:combo) tag add highlight "$index+1c linestart" "$index+1c lineend"
		$data(w:combo) see $index
	} else {
		set data(t:combo:line) 0
	}
}

proc table::edit:combo:scroll {w mode x y} {
variable $w
upvar 0 $w data
global __typed


	if {!$data(t:hascombo)} {
		return
	}

	if {$mode != "Motion"} {
		set __typed($w) 0
	}

	switch $mode {
		Motion	{ set data(t:combo:line) [expr int([$data(w:combo) index "@$x,$y linestart"])] }
		Up		{ incr data(t:combo:line) -1 }
		Down	{ incr data(t:combo:line) }
		Prior	{ incr data(t:combo:line) -10 }
		Next	{ incr data(t:combo:line) 10 }
	}
	set max [expr int([$data(w:combo) index "end -1c linestart"])]
	if {$data(t:combo:line) < 1} {
		set data(t:combo:line) 1
	} elseif {$data(t:combo:line) > $max} {
		set data(t:combo:line) $max
	}

	$data(w:combo) tag remove highlight 1.0 end				
	$data(w:combo) tag add highlight "$data(t:combo:line).0" "$data(t:combo:line).end"
	$data(w:combo) see "$data(t:combo:line).0"
}


#=======================================================================================


proc table::tip {w x y X Y} {
variable $w
upvar 0 $w data


	if {$data(v:usetip)} {
		after cancel $data(t:tip)
		destroy .__tip__
		set data(t:tip) [after 500 "table::tip:show $w $x $y $X $Y"]
	}
}

proc table::tip:cancel {w} {
variable $w
upvar 0 $w data

	after cancel $data(t:tip)
	destroy .__tip__
}

proc table::tip:setmode {w mode} {
variable $w
upvar 0 $w data


	if {$mode == "off"} {
		after cancel $data(t:tip)
		destroy .__tip__
		set data(v:usetip) 0
	} else {
		set data(v:usetip) 1
	}
}

proc table::tip:show {w x y X Y} {
variable $w
upvar 0 $w data


	# get the tip
	set index [$data(w:text) index "@0,$y"]
	if {[catch {set option $data(option:$index)}]} {
		# not on a valid line
		return
	}
	scan [$data(w:text) index "@$x,$y"] "%d.%d" dummy posx
	if {$posx < $data(v:size)} {
		set mode help
	} else {
		if {[lsearch -exact $data(v:noeditable) $index] != -1} {
			return
		}
		set mode value
	}
	set text [uplevel #0 $data(v:cb:tip) $option $data(tag:$index) $mode]
	if {$text == ""} {
		return
	}

	# display it
	toplevel .__tip__
	wm overrideredirect .__tip__ 1
	wm geometry .__tip__ +[expr $X+13]+[expr $Y+13]
	frame .__tip__.b -bg black -bd 1
	label .__tip__.b.l -background lightyellow -font {Helvetica 10} -text $text
	pack .__tip__.b .__tip__.b.l
}


#=======================================================================================

image create bitmap imgCompute -file compute.bmp


proc dummy {} {

#---------------------------------------------------------------------------------------

wm geometry . +0+0
destroy .top
toplevel .top
wm geometry .top +50+300


proc toto_after {option value} {

	puts "<<toto_after>> $option $value"

	return $value
}

set table [table::new .top -size 20 -command "toto_after"]


puts "packing $table"
pack $table


table::add $table -src toto 1.1.1.1
table::add $table -dst toto 1.1.1.1
table::add $table -flag toto 0
}