#-------------------------------------------------------------------------------------------------
#   TFTP - Trivial File Transfert Protocol
#-------------------------------------------------------------------------------------------------

protocol tftp = {
	spec = "RFC 1350"
    size = '%computedsize'

    field -opcode @ (0, 2) = {
		type = list {
			       1 "rrq" "rrq"
			       2 "wrq" "wrq"
			       3 "data" "data"
			       4 "ack" "ack"
			       5 "error" "error"
			   }
		help = "opcode"
		default = 1
	}

	field -data @ (2, '%variable') = {
		type = switch('%field(-opcode)') {
				   1, 2		mapper(tftp_request)
				   3, 4		mapper(tftp_block)
				   5		mapper(tftp_error)
			   }
		help = "data according to opcode"
	}
}

protocol tftp_request = {
	spec = "RFC 1350"
    size = '%computedsize'

    field -filename @ (0, '%variable') = {
		type = string(c)
		help = "filename"
	}

    field -mode @ ('%follows', '%variable') = {
		type = string(c)
		help = "filename"
	}
}

protocol tftp_block = {
	spec = "RFC 1350"
    size = 2

    field -block @ (0, 2) = {
		type = integer
		help = "block number"
	}
}

protocol tftp_error = {
	spec = "RFC 1350"
    size = '%computedsize'

    field -code @ (0, 2) = {
		type = integer
		help = "error code"
	}

    field -message @ (2, '%variable') = {
		type = string(c)
		help = "error message"
	}
}
