/* 
 * This is source code to CASL (Custom Audit Scripting Language)
 *
 * Copyright 1998 Secure Networks, Inc.
 * Copyright 1999 Network Associates, Inc.
 * All Rights Reserved
 *
 * BEFORE YOU INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT,
 * CAREFULLY READ THE TERMS AND CONDITIONS IN THE FILE
 * "LICENSE.TXT" ACCOMPANYING THIS DOCUMENT. IF THE FILE
 * "LICENSE.TXT" IS MISSING, IT MAY BE OBTAINED FROM
 * NETWORK ASSOCIATES. NETWORK ASSOCIATES IS PERMITTING
 * THE USE, DISTRIBUTION, AND LIMITED MODIFICATION OF THIS
 * SOFTWARE PRODUCT ON A NON-COMMERCIAL BASIS SUBJECT TO
 * ALL OF THE CONDITIONS IN THE FILE "LICENSE.TXT." BY INSTALLING,
 * USING, OR MODIFYING THE SOFTWARE PRODUCT, YOU AND ANY
 * SUBSEQUENT USER ARE AGREEING TO BE BOUND BY ALL OF THE
 * TERMS AND CONDITIONS IN THE FILE "LICENSE.TXT." IF YOU DO
 * NOT AGREE TO ALL OF THOSE TERMS AND CONDITIONS, DO NOT
 * INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT.
 */

#ifndef CAPE_INCLUDED
#define CAPE_INCLUDED

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <setjmp.h>
#include <net/if.h>

#if defined(_BSD) || defined(_BSDI) || defined(_FREEBSD)
#include <sys/param.h>
#include <sys/sysctl.h>
#include <net/route.h>
#include <net/if_dl.h>
#endif

#ifdef _BSDI
#include <sys/param.h>
#endif

#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include "net/in_systm.h"
#include "net/ip.h"
#include "net/udp.h"
#include "net/tcp.h"
#include "net/pcap.h"
#include "net/if_arp.h"
#include "net/if_ether.h"

#include "nettab.h"

#define ACCUM_ZERO 		       	0xffff
#define CAPE_MAXIOVS		       	4096

#define ETHER_FRAME_SIZE		       	14
#define ETHER_ADDR_LEN			6
#define IP_HEADER_SIZE		      	20

#define MAX_LOCAL_INTERFACES		256

#define CAPEBUFSIZ				4096

#define CC_DESTINATION			"CC_DESTINATION"

#define CC_INTERFACE			"CC_Interface"
#define CC_NETMASK			"CC_Netmask"
#define CC_GATEWAY			"CC_Gateway"
#define CC_GATEWAY_MAC			"CC_Gateway_MAC"

#define CC_LOCAL_MAC			"CC_Local_MAC"
#define CC_ALWAYSARP			"CC_ARP_All"
#define CC_NOKERNELARP			"CC_No_Kernel_ARP"
#define CC_ARPFALLBACK			"CC_Fallback_Gateway"

#define CC_GATEWAY_MAC_NONE		"none"
#define CC_GATEWAY_MAC_NONE_ENV		"CC_NOGATEWAY"
#define CC_GATEWAY_MAC_AUTO		"auto"
#define CC_LOCAL_MAC_AUTO		"auto"
#define CC_AUTO				"auto"

extern pcap_t *Packet_Context;
extern char *CASL_Default_Interface;
extern u_int32_t CASL_Default_Gateway;
extern u_int32_t CASL_IP_Address;
extern u_int32_t CASL_Netmask;
extern struct ether_addr *CASL_Gateway_MAC;
extern struct ether_addr *CASL_Local_MAC;

asr_t *casl_ip_output(asr_t *);
asr_t *casl_ip_input(asr_t *);
asr_t *casl_checksum(asr_t *);
asr_t *casl_ip_filter(asr_t *);
asr_t *casl_ip_fixup(asr_t *);
asr_t *casl_ip_range(asr_t *);

void ip_init(void *);
int ip_filter(char *);
list_t *inet_addrs(char *);

/* XXX inconsistant */

int list_coagulate(asr_t *, u_char **);
u_char *coagulate(struct iovec *, int, int *);
u_short cksum_accum(u_short, void *, int);
u_char *casl_arp_resolve(u_int32_t);

u_int32_t get_address_from_interface(char *);
char *get_interface_from_address(u_int32_t address);
char *get_local_interface(void);
u_int32_t get_default_gateway(void);
int isinnetwork(u_int32_t, u_int32_t, u_int32_t);

struct ether_addr *ether_aton(char *);
char *ether_ntoa(struct ether_addr *);

extern int IP_Initialized;

#ifndef _FREEBSD
char *ether_ntoa(struct ether_addr *);
struct ether_addr *ether_aton(char *);
#endif

#endif
