/* 
 * $smu-mark$ 
 * $name: getlhs.c$ 
 * $author: Salvatore Sanfilippo <antirez@invece.org>$ 
 * $copyright: Copyright (C) 1999 by Salvatore Sanfilippo$ 
 * $license: This software is under GPL version 2 of license$ 
 * $date: Fri Nov  5 11:55:47 MET 1999$ 
 * $rev: 8$ 
 */ 

#include <string.h>

#include "hping2.h"
#include "globals.h"

int get_linkhdr_size(char *ifname)
{

/*
 *	PPP
 */

#ifdef OSTYPE_LINUX	/* Linux */
	if ( strstr(ifname, "ppp") )
	{
		linkhdr_size = PPPHDR_SIZE_LINUX;
		return 0;
	}
#endif

#ifdef OSTYPE_FREEBSD	/* FreeBSD */
	if ( strstr(ifname, "ppp") )
	{
		linkhdr_size = PPPHDR_SIZE_FREEBSD;
		return 0;
	}
#endif

#ifdef OSTYPE_OPENBSD /* OpenBSD */
	if ( strstr(ifname, "ppp") )
	{
		linkhdr_size = PPPHDR_SIZE_OPENBSD;
		return 0;
	}
#endif

/* XXX: if you port hping2 to BSDI remember
 * that PPPHDR_SIZE_BSDOS must be 24 for some
 * BSDI versions (see libpcap for more information)
 */

/*
 *	Ethernet
 */

#ifdef OSTYPE_LINUX	/* Linux */
	else if ( strstr(ifname, "eth") )
	{
		linkhdr_size = ETHHDR_SIZE;
		return 0;
	}
#endif

#ifdef OSTYPE_FREEBSD	/* FreeBSD */
	else if ( strstr(ifname, "eth") /* ? */
	     ||   strstr(ifname, "ed")
	     ||   strstr(ifname, "ne")
	     ||   strstr(ifname, "xl")	/* 3com */
	     ||   strstr(ifname, "vx")	/* 3com (older model) */
	     ||   strstr(ifname, "fxp")	/* Intel EtherExpress Pro/100B */
	     ||   strstr(ifname, "al")	/* ADMtek Inc. AL981 "Comet" chip. */
	     ||   strstr(ifname, "de")	/* Digital Equipment DC21040 */
	     ||   strstr(ifname, "mx")	/* Macronix 98713, 987615 ans 98725 */
	     ||   strstr(ifname, "rl")	/* RealTek 8129/8139 */
	     ||   strstr(ifname, "sf")	/* Adaptec Duralink PCI */
	     ||   strstr(ifname, "sk")	/* SysKonnect SK-984x */
	     ||   strstr(ifname, "tl")	/* Compaq Netelligent 10/10+TNETE100 */
	     ||   strstr(ifname, "tx")	/* SMC 9432TX */
	     ||   strstr(ifname, "wb"))	/* Winbond W89C840F chip */
	{
		linkhdr_size = ETHHDR_SIZE;
		return 0;
	}
#endif

#ifdef OSTYPE_OPENBSD /* OpenBSD FIXME: grepped from FreeBSD, it's OK? */
	else if ( strstr(ifname, "eth") /* ? */
	     ||   strstr(ifname, "ed")
	     ||   strstr(ifname, "ne")
	     ||   strstr(ifname, "xl")	/* 3com */
	     ||   strstr(ifname, "vx")	/* 3com (older model) */
	     ||   strstr(ifname, "fxp")	/* Intel EtherExpress Pro/100B */
	     ||   strstr(ifname, "al")	/* ADMtek Inc. AL981 "Comet" chip. */
	     ||   strstr(ifname, "de")	/* Digital Equipment DC21040 */
	     ||   strstr(ifname, "mx")	/* Macronix 98713, 987615 ans 98725 */
	     ||   strstr(ifname, "rl")	/* RealTek 8129/8139 */
	     ||   strstr(ifname, "sf")	/* Adaptec Duralink PCI */
	     ||   strstr(ifname, "sk")	/* SysKonnect SK-984x */
	     ||   strstr(ifname, "tl")	/* Compaq Netelligent 10/10+TNETE100 */
	     ||   strstr(ifname, "tx")	/* SMC 9432TX */
	     ||   strstr(ifname, "wb"))	/* Winbond W89C840F chip */
	{
		linkhdr_size = ETHHDR_SIZE;
		return 0;
	}
#endif

/*
 *	Loopback
 */

	else if ( strstr(ifname, "lo") )
	{
		linkhdr_size = LOHDR_SIZE;
		return 0;
	}
	else
		return -1;
}
