/* 
 * This is source code to CASL (Custom Audit Scripting Language)
 *
 * Copyright 1998 Secure Networks, Inc.
 * Copyright 1999 Network Associates, Inc.
 * All Rights Reserved
 *
 * BEFORE YOU INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT,
 * CAREFULLY READ THE TERMS AND CONDITIONS IN THE FILE
 * "LICENSE.TXT" ACCOMPANYING THIS DOCUMENT. IF THE FILE
 * "LICENSE.TXT" IS MISSING, IT MAY BE OBTAINED FROM
 * NETWORK ASSOCIATES. NETWORK ASSOCIATES IS PERMITTING
 * THE USE, DISTRIBUTION, AND LIMITED MODIFICATION OF THIS
 * SOFTWARE PRODUCT ON A NON-COMMERCIAL BASIS SUBJECT TO
 * ALL OF THE CONDITIONS IN THE FILE "LICENSE.TXT." BY INSTALLING,
 * USING, OR MODIFYING THE SOFTWARE PRODUCT, YOU AND ANY
 * SUBSEQUENT USER ARE AGREEING TO BE BOUND BY ALL OF THE
 * TERMS AND CONDITIONS IN THE FILE "LICENSE.TXT." IF YOU DO
 * NOT AGREE TO ALL OF THOSE TERMS AND CONDITIONS, DO NOT
 * INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT.
 */

#ifndef NETTAB_H
#define NETTAB_H

#ifdef DEBUG
 #define IFDEBUG(x) (x)
#else
 #define IFDEBUG(x)
#endif

struct iflist {
    struct iflist *next;
    char *name;
    int ipaddr;
    int netmask;
    int index;				/* used by NT for matching SNMP */
    char macaddr[6];
};

struct routelist {
    struct routelist *next;
    struct iflist *iface;
    int ipaddr;
    int netmask;
    int gateway;
    int metric;
};

struct pcap;

/* platform independant */
void destroy_iflist(struct iflist *);
void destroy_routelist(struct routelist *);
int iface_lookup(int, struct iflist **);
int route_lookup(int, int *, struct iflist **);

/* platform dependant */
struct iflist *get_iflist(void);
struct routelist *get_routelist(struct iflist *);

#endif /* NETTAB_H */
