/* 
 * This is source code to CASL (Custom Audit Scripting Language)
 *
 * Copyright 1998 Secure Networks, Inc.
 * Copyright 1999 Network Associates, Inc.
 * All Rights Reserved
 *
 * BEFORE YOU INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT,
 * CAREFULLY READ THE TERMS AND CONDITIONS IN THE FILE
 * "LICENSE.TXT" ACCOMPANYING THIS DOCUMENT. IF THE FILE
 * "LICENSE.TXT" IS MISSING, IT MAY BE OBTAINED FROM
 * NETWORK ASSOCIATES. NETWORK ASSOCIATES IS PERMITTING
 * THE USE, DISTRIBUTION, AND LIMITED MODIFICATION OF THIS
 * SOFTWARE PRODUCT ON A NON-COMMERCIAL BASIS SUBJECT TO
 * ALL OF THE CONDITIONS IN THE FILE "LICENSE.TXT." BY INSTALLING,
 * USING, OR MODIFYING THE SOFTWARE PRODUCT, YOU AND ANY
 * SUBSEQUENT USER ARE AGREEING TO BE BOUND BY ALL OF THE
 * TERMS AND CONDITIONS IN THE FILE "LICENSE.TXT." IF YOU DO
 * NOT AGREE TO ALL OF THOSE TERMS AND CONDITIONS, DO NOT
 * INSTALL, USE, OR MODIFY THIS SOFTWARE PRODUCT.
 */

#ifndef EVAL_INCLUDED
#define EVAL_INCLUDED

#include "table.h"
#include "list.h"
#include "casl-asr.h"

typedef struct _st {
	char *st_name;
	u_char st_flags;
	table_t *st_sds;
	int st_scale;
} st;

typedef struct _sdef {
	char *sd_name;
	int   sd_bitoffset;
	int   sd_type;
	
	union {
		int   bitlength;
		char *id;
		asr_t *func;
	} sd_u;
} sdef;

#define S_RESIZEABLE	1

#define S_STRUCT	0
#define S_VAL	 	1
#define S_FUNC	   	2
#define S_BUF		3

#define sd_bitlength sd_u.bitlength
#define sd_id sd_u.id
#define sd_func sd_u.func

asr_t *eval_expr(asr_t *);
asr_t *eval_call(asr_t *);
asr_t *eval_assign(asr_t *);
asr_t *eval_neg(asr_t *);
asr_t *eval_not(asr_t *);
asr_t *eval_list(asr_t *);
asr_t *eval_head(asr_t *);
asr_t *eval_tail(asr_t *);
asr_t *eval_plist(asr_t *);
asr_t *eval_ptail(asr_t *);
asr_t *eval_idx(asr_t *);
asr_t *eval_id(asr_t *);
asr_t *eval_idx(asr_t *);
asr_t *eval_string(asr_t *);
asr_t *eval_new(asr_t *);
asr_t *eval_copy(asr_t *);
asr_t *eval_extract(asr_t *);
asr_t *eval_statement(asr_t *);
asr_t *eval_while(asr_t *);
asr_t *eval_ite(asr_t *);
asr_t *eval_for(asr_t *);
asr_t *eval_foreach(asr_t *);
asr_t *eval_new(asr_t *);
asr_t *eval_extract(asr_t *);
asr_t *eval_extract2(asr_t *);
asr_t *eval_sname(asr_t *);
asr_t *eval_incr(asr_t *, int);
asr_t *eval_decr(asr_t *, int);

/* don't return asr's */

void  eval_struct(asr_t *);
sdef *eval_field(asr_t *, int *);

/* not directly called */

asr_t *eval_assign_idx(asr_t *, asr_t *);

asr_t *struct_assign(asr_t *, asr_t *, asr_t *);
asr_t *struct_get(asr_t *, asr_t *);

int list_items(asr_t *);
int list_eq(asr_t *, asr_t *);
asr_t *list_copy(asr_t *);
asr_t *list_expand(asr_t *);

void asr_buf_setbits(asr_t *, int, int, u_long, int);
void asr_buf_setbytes(asr_t *, int, int, u_long, int);
void asr_buf_setwords(asr_t *, int, int, u_long, int);
void asr_buf_setdwords(asr_t *, int, int, u_long, int);

u_long asr_get_bits(asr_t *, int, int);
u_long asr_get_bytes(asr_t *, int, int);
u_long asr_get_words(asr_t *, int, int);
u_long asr_get_dwords(asr_t *, int, int);

int boolean(asr_t *);

asr_t *lookup(asr_t *);
u_long lookup_num(char *);
char *lookup_string(char *);

void asr_buf_string(asr_t *buf, int start, int stop, char *string, int);

/* XXX SHUT UP GCC */

void asr_free(asr_t **);
void asr_free_tree(asr_t *);

#define E_INTERNAL	0
#define E_USER		1
#define E_WARN		2

#endif
