/*
    send_packet.c: sends a packet over a raw socket.
    Copyright (C) 1999 by Marcelo Gornstein

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    see "COPYING" file for details.

If you want to contact me:
Marcelo Gornstein
mgornstein@usa.net
*/
#include <sys/types.h>
#include <sys/socket.h>
#include <fcntl.h>
#include "definitions.h"

extern char sendfile;

void send_packet (struct PACKET p, int len)
{
int s;
int fd;
int i;
struct sockaddr_in pck_info;
s = socket (AF_INET, SOCK_RAW, IPPROTO_RAW);
if (s < 0) { perror ("Error opening socket"); exit (-1); }
pck_info.sin_family = AF_INET;
pck_info.sin_addr.s_addr = p.dst_host.naddr.s_addr;
if (sendfile)	{
		printf ("Sending file %s\n", p.file);
		fd = open (p.file, O_RDONLY);
		if (fd < 0) { perror ("Error"); exit (-1); }
		for (i = 0; i < (p.bufflen - len); i++ )
			{
			read (fd, p.data + len + i, 1); 
			}
		close (fd);
		}
sendto (s, p.data, p.bufflen, 0, (struct sockaddr *) (&pck_info), 
					sizeof (struct sockaddr));
close (s);
}
