/*
    ip.c: ip part of Send Packet.
    Copyright (C) 1999 by Marcelo Gornstein

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    see "COPYING" file for details.

If you want to contact me:
Marcelo Gornstein
mgornstein@usa.net
*/

#include <sys/types.h>
#include <sys/socket.h>
#include "definitions.h"

void fill_ip (struct PACKET p)
{
memset ((void *) (p.iph), '\0', sizeof (struct iphdr));
p.iph->version = 4;
p.iph->ihl = 5;
p.iph->ttl = p.ttl;
p.iph->tos = 0;

#if COMPILE_TCP
if (!strncmp (p.proto, "tcp", 3))	{
					p.iph->tot_len = htons (IPLEN + TCPLEN);
					p.iph->protocol = 6;
					}
#endif

#if COMPILE_UDP
if (!strncmp (p.proto, "udp", 3))	{
					p.iph->tot_len = htons (IPLEN + UDPLEN);
					p.iph->protocol = 17;
					}
#endif

#if COMPILE_ICMP
if (!strncmp (p.proto, "icmp", 4))	{
					p.iph->tot_len = htons (IPLEN + ICMPLEN);
					p.iph->protocol = 1;
					}
#endif

p.iph->id = random () % 1996;
p.iph->saddr = p.src_host.naddr.s_addr;
p.iph->daddr = p.dst_host.naddr.s_addr;
p.iph->check = in_cksum (p.data, IPLEN);
printf ("IP Checksum: %d\n", p.iph->check);
}
